/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.peer.swing;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JComponent;
import oracle.bpm.draw.Color;
import oracle.bpm.draw.FontMetrics;
import oracle.bpm.draw.Graphics;
import oracle.bpm.draw.GraphicsUtils;
import oracle.bpm.geom.Insets;
import oracle.bpm.ui.Cursor;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.Margin;
import oracle.bpm.ui.Overriding;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.border.Border;
import oracle.bpm.ui.event.FocusListener;
import oracle.bpm.ui.event.KeyListener;
import oracle.bpm.ui.event.MouseListener;
import oracle.bpm.ui.event.MouseMotionListener;
import oracle.bpm.ui.event.SizeListener;
import oracle.bpm.ui.event.VisibilityListener;
import oracle.bpm.ui.peer.ComponentPeer;
import oracle.bpm.ui.peer.swing.AwtConverter;
import oracle.bpm.ui.peer.swing.SwingImage;
import oracle.bpm.ui.peer.swing.SwingPeer;
import oracle.bpm.ui.peer.swing.event.SwingFocusListener;
import oracle.bpm.ui.peer.swing.event.SwingKeyListener;
import oracle.bpm.ui.peer.swing.event.SwingMouseListener;
import oracle.bpm.ui.peer.swing.event.SwingMouseMotionListener;
import oracle.bpm.ui.peer.swing.event.SwingSizeListener;

public class SwingComponent
extends SwingPeer
implements ComponentPeer {
    private Component component;
    private SwingComponent parent;
    private VisibilityListener visibilityListener;

    public SwingComponent(SwingComponent parent, Component component) {
        this.setParent(parent);
        this.setComponent(component);
    }

    public static Object getClientProperty(Component component, String key) {
        Object result;
        if (component instanceof JComponent) {
            JComponent jcomponent = (JComponent)component;
            result = jcomponent.getClientProperty(key);
        } else {
            result = null;
        }
        return result;
    }

    public static void paintHorizontalSquiggleLine(java.awt.Graphics g, Component component, String text, Color color) {
        int xStart;
        Font f = component.getFont();
        java.awt.FontMetrics fontMetrics = component.getFontMetrics(f);
        int descent = fontMetrics.getDescent();
        int strWidth = fontMetrics.stringWidth(text == null ? "" : text);
        Rectangle b = component.getBounds();
        int squiggleWidth = strWidth > 0 ? strWidth : 50;
        Rectangle r = new Rectangle(0, b.height - descent, squiggleWidth, 2);
        g.setColor(AwtConverter.toAwt(color));
        int x = r.x;
        while ((double)x < r.getX() + r.getWidth() && !((double)(xStart = x + 2) > r.getX() + r.getWidth())) {
            g.drawLine(x, r.y + r.height, xStart, r.y);
            int xEnd = x + 4;
            if ((double)xEnd > r.getX() + r.getWidth()) {
                xEnd = r.x + r.width;
            }
            g.drawLine(x + 2, r.y, xEnd, r.y + r.height);
            x += 4;
        }
    }

    @Override
    public void setBackground(Color color) {
        this.getInputTarget().setBackground(AwtConverter.toAwt(color));
    }

    @Override
    public Color getBackground() {
        return AwtConverter.fromAwt(this.getInputTarget().getBackground());
    }

    @Override
    public void setBorder(Border border) {
        this.getJComponent().setBorder(border != null ? border.asSwing() : null);
    }

    @Override
    public Border getBorder() {
        return Border.get(this.getJComponent().getBorder());
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        this.getComponent().setBounds(x, y, width, height);
    }

    @Override
    public Object getClientProperty(String key) {
        JComponent comp = this.getJComponent();
        Object result = comp != null ? comp.getClientProperty(key) : super.getClientProperty(key);
        return result;
    }

    @Override
    public ComponentOrientation getComponentOrientation() {
        return this.getComponent().getComponentOrientation();
    }

    @Override
    public void setCursor(Cursor cursor) {
        this.getComponent().setCursor(cursor.asAwtCursor());
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.getComponent().setEnabled(enabled);
    }

    @Override
    public boolean isEnabled() {
        return this.getComponent().isEnabled();
    }

    @Override
    public boolean isDisposed() {
        return this.getClientProperty("disposed") == Boolean.TRUE;
    }

    @Override
    public void makeRecyclable() {
    }

    @Override
    public void dispose() {
        if (!this.isDisposed()) {
            this.putClientProperty("disposed", Boolean.TRUE);
            int childCount = this.getComponentCount();
            for (int i = 0; i < childCount; ++i) {
                UiComponent child = this.getComponent(i);
                child.getPeer().dispose();
            }
            if (this.visibilityListener != null) {
                this.visibilityListener.onDispose();
            }
        }
    }

    @Override
    public void setFocusCycleRoot(boolean b) {
    }

    @Override
    public void setFocusable(boolean focusable) {
        this.getInputTarget().setFocusable(focusable);
    }

    @Override
    public void setFont(oracle.bpm.draw.Font font) {
        this.getInputTarget().setFont(AwtConverter.toAwt(font));
    }

    @Override
    public oracle.bpm.draw.Font getFont() {
        return oracle.bpm.draw.Font.valueOf(this.getInputTarget().getFont());
    }

    @Override
    public FontMetrics getFontMetrics(oracle.bpm.draw.Font font) {
        return AwtConverter.fromAwt(this.getInputTarget().getFontMetrics(AwtConverter.toAwt(font)));
    }

    @Override
    public void setForeground(Color color) {
        this.getInputTarget().setForeground(AwtConverter.toAwt(color));
    }

    @Override
    public Color getForeground() {
        return AwtConverter.fromAwt(this.getInputTarget().getForeground());
    }

    @Override
    public Graphics getGraphics() {
        return GraphicsUtils.create(this.component.getGraphics());
    }

    @Override
    public int getHeight() {
        return this.getComponent().getHeight();
    }

    @Override
    public void setInsets(Margin margin) {
    }

    @Override
    public Margin getInsets() {
        Insets insets = AwtConverter.fromAwt(this.getJComponent().getInsets());
        return new Margin(insets.top, insets.left, insets.bottom, insets.right);
    }

    @Override
    public void setLocation(int x, int y) {
        this.getComponent().setLocation(x, y);
    }

    @Override
    public oracle.bpm.geom.Point getLocation() {
        return AwtConverter.fromAwt(this.getComponent().getLocation());
    }

    @Override
    public oracle.bpm.geom.Point getLocationOnScreen() {
        return AwtConverter.fromAwt(this.getComponent().getLocationOnScreen());
    }

    @Override
    public void setMaximumSize(oracle.bpm.geom.Dimension dimension) {
        this.getComponent().setMaximumSize(SwingComponent.asSwingDimension(dimension));
    }

    @Override
    public void setMinimumSize(oracle.bpm.geom.Dimension dimension) {
        this.getComponent().setMinimumSize(SwingComponent.asSwingDimension(dimension));
    }

    @Override
    public final oracle.bpm.geom.Dimension getMaximumSize() {
        oracle.bpm.geom.Dimension result;
        Component component = this.getComponent();
        if (component instanceof ExtendedSwing) {
            ExtendedSwing swing = (ExtendedSwing)((Object)component);
            result = AwtConverter.fromAwt(swing.getDefaultMaximumSize());
        } else {
            assert (!this.getOverridings().isOverridesMaximumSize()) : this.getUiComponent().getClass() + " must not override getMaximumSize()";
            result = AwtConverter.fromAwt(component.getMaximumSize());
        }
        return result;
    }

    @Override
    public final oracle.bpm.geom.Dimension getMinimumSize() {
        oracle.bpm.geom.Dimension result;
        Component component = this.getComponent();
        if (component instanceof ExtendedSwing) {
            ExtendedSwing swing = (ExtendedSwing)((Object)component);
            result = AwtConverter.fromAwt(swing.getDefaultMinimumSize());
        } else {
            assert (!this.getOverridings().isOverridesMinimumSize()) : this.getUiComponent().getClass() + " must not override getMinimumSize()";
            result = AwtConverter.fromAwt(component.getMinimumSize());
        }
        return result;
    }

    @Override
    public MouseListener[] getMouseListeners() {
        return null;
    }

    @Override
    public MouseMotionListener[] getMouseMotionListeners() {
        return null;
    }

    @Override
    public void setName(String name) {
        this.getComponent().setName(name);
    }

    @Override
    public String getName() {
        return this.getComponent().getName();
    }

    @Override
    public Object getNative() {
        return this.component;
    }

    @Override
    public void setOpaque(boolean opaque) {
        this.getJComponent().setOpaque(opaque);
    }

    @Override
    public boolean isOpaque() {
        return this.getJComponent().isOpaque();
    }

    public SwingComponent getParent() {
        return this.parent;
    }

    @Override
    public void setPreferredSize(oracle.bpm.geom.Dimension dimension) {
        this.getComponent().setPreferredSize(SwingComponent.asSwingDimension(dimension));
    }

    @Override
    public oracle.bpm.geom.Dimension getPreferredSize() {
        oracle.bpm.geom.Dimension result;
        Component component = this.getComponent();
        if (component instanceof ExtendedSwing) {
            ExtendedSwing swing = (ExtendedSwing)((Object)component);
            result = AwtConverter.fromAwt(swing.getDefaultPreferredSize());
        } else {
            result = AwtConverter.fromAwt(component.getPreferredSize());
        }
        return result;
    }

    @Override
    public void setRequestFocusEnabled(boolean enabled) {
    }

    @Override
    public void setSize(int width, int height) {
        this.getComponent().setSize(width, height);
    }

    @Override
    public void setSize(oracle.bpm.geom.Dimension size) {
        this.getComponent().setSize(SwingComponent.asSwingDimension(size));
    }

    @Override
    public oracle.bpm.geom.Dimension getSize() {
        return AwtConverter.fromAwt(this.getComponent().getSize());
    }

    @Override
    public void setToolTipText(String text) {
        Component target = this.getInputTarget();
        if (target instanceof JComponent) {
            ((JComponent)target).setToolTipText(text);
        }
    }

    @Override
    public String getToolTipText() {
        Component target = this.getInputTarget();
        return target instanceof JComponent ? ((JComponent)target).getToolTipText() : null;
    }

    @Override
    public void setVisible(boolean visible) {
        this.getComponent().setVisible(visible);
        if (!visible && this.visibilityListener != null) {
            this.visibilityListener.onDispose();
        }
    }

    @Override
    public boolean isVisible() {
        return this.getComponent().isVisible();
    }

    @Override
    public int getWidth() {
        return this.getComponent().getWidth();
    }

    @Override
    public int getX() {
        return this.getComponent().getX();
    }

    @Override
    public int getY() {
        return this.getComponent().getY();
    }

    public void add(UiComponent component, Object constraints) {
        this.getContainer().add((Component)SwingComponent.asSwing(component), constraints);
    }

    public void add(UiComponent component, Object constraints, int index) {
        this.getContainer().add(SwingComponent.asSwing(component), constraints, index);
    }

    @Override
    public void addFocusListener(FocusListener listener) {
        this.getInputTarget().addFocusListener(SwingFocusListener.get(listener));
    }

    @Override
    public void addKeyListener(KeyListener listener) {
        this.getKeyTarget().addKeyListener(SwingKeyListener.get(listener));
    }

    @Override
    public void addMouseListener(MouseListener listener) {
        this.getMouseTarget().addMouseListener(SwingMouseListener.get(listener));
    }

    @Override
    public void addMouseMotionListener(MouseMotionListener listener) {
        this.getMouseTarget().addMouseMotionListener(SwingMouseMotionListener.get(listener));
    }

    @Override
    public void addSizeListener(SizeListener listener) {
        SwingSizeListener l = SwingSizeListener.get(listener);
        this.getComponent().addComponentListener(l);
    }

    @Override
    public void removeSizeListener(SizeListener listener) {
        SwingSizeListener l = SwingSizeListener.get(listener);
        this.getComponent().removeComponentListener(l);
    }

    @Override
    public boolean hasFocus() {
        return this.getInputTarget().hasFocus();
    }

    @Override
    public void invalidate() {
        this.getComponent().invalidate();
    }

    @Override
    public void paint(Graphics g) {
        Component component = this.getComponent();
        if (component instanceof ExtendedSwing) {
            ExtendedSwing swing = (ExtendedSwing)((Object)component);
            swing.defaultPaint(AwtConverter.toAwt(g));
        } else assert (false) : this.getUiComponent().getClass() + " must not override paint()";
    }

    @Override
    public void paintComponent(Graphics g) {
        Component component = this.getComponent();
        if (component instanceof ExtendedSwing) {
            ExtendedSwing swing = (ExtendedSwing)((Object)component);
            swing.defaultPaintComponent(AwtConverter.toAwt(g));
        } else assert (false) : this.getUiComponent().getClass() + " must not override paint()";
    }

    @Override
    public void putClientProperty(String key, Object value) {
        JComponent comp = this.getJComponent();
        if (comp != null) {
            comp.putClientProperty(key, value);
        } else {
            super.putClientProperty(key, value);
        }
    }

    @Override
    public void removeFocusListener(FocusListener listener) {
        this.getInputTarget().removeFocusListener(SwingFocusListener.get(listener));
    }

    @Override
    public void removeKeyListener(KeyListener listener) {
        this.getKeyTarget().removeKeyListener(SwingKeyListener.get(listener));
    }

    @Override
    public void removeMouseListener(MouseListener listener) {
        this.getMouseTarget().removeMouseListener(SwingMouseListener.get(listener));
    }

    @Override
    public void removeMouseMotionListener(MouseMotionListener listener) {
        this.getMouseTarget().removeMouseMotionListener(SwingMouseMotionListener.get(listener));
    }

    @Override
    public void repaint() {
        this.getComponent().repaint();
    }

    @Override
    public void requestFocus() {
        this.getInputTarget().requestFocusInWindow();
    }

    @Override
    public void revalidate() {
        JComponent component = this.getJComponent();
        assert (component != null) : "Null JComponent found for this: " + this;
        component.revalidate();
    }

    @Override
    public void transferFocus() {
        this.getComponent().transferFocus();
    }

    @Override
    public void updateUI() {
    }

    @Override
    public void validate() {
        this.getComponent().validate();
    }

    @Override
    public void paintImmediately(oracle.bpm.geom.Rectangle rect) {
        this.paintImmediately(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight());
    }

    @Override
    public void paintImmediately(int x, int y, int w, int h) {
        this.getJComponent().paintImmediately(x, y, w, h);
    }

    public JComponent getJComponent() {
        return this.component instanceof JComponent ? (JComponent)this.component : null;
    }

    @Override
    public int getComponentCount() {
        return this.getContainer().getComponentCount();
    }

    @Override
    public UiComponent getComponent(int index) {
        return UiComponent.get(this.getContainer().getComponent(index));
    }

    @Override
    public void addVisibilityListener(VisibilityListener listener) {
        this.visibilityListener = listener;
    }

    @Override
    public void removeVisibilityListener(VisibilityListener listener) {
        if (this.visibilityListener != null && this.visibilityListener.equals(listener)) {
            this.visibilityListener = null;
        }
    }

    @Override
    public void moveOnTop() {
        this.getJComponent().setComponentZOrder(this.getJComponent(), 0);
    }

    @Override
    public void changeParent(UiComponent contentPane) {
    }

    public Component getInputTarget() {
        return this.getComponent();
    }

    public void setComponent(Component component) {
        this.component = component;
    }

    protected static JComponent asSwing(UiComponent component) {
        return component != null ? component.asSwing() : null;
    }

    protected static Dimension asSwingDimension(oracle.bpm.geom.Dimension dimension) {
        return dimension != null ? new Dimension(dimension.getWidth(), dimension.getHeight()) : null;
    }

    protected static Icon asSwingIcon(Image icon) {
        return icon != null ? icon.asSwingIcon() : null;
    }

    protected static Point asSwingPoint(oracle.bpm.geom.Point point) {
        return new Point(point.getX(), point.getY());
    }

    protected Component getMouseTarget() {
        return this.getInputTarget();
    }

    protected Component getKeyTarget() {
        return this.getInputTarget();
    }

    protected Component getComponent() {
        return this.component;
    }

    protected Container getContainer() {
        return (Container)this.getComponent();
    }

    protected Overriding getOverridings() {
        return Overriding.get(this.getUiComponent().getClass());
    }

    protected UiComponent getUiComponent() {
        return (UiComponent)this.getClientProperty("oracle.bpm.ui.key");
    }

    protected UiComponent getUiComponent(Component object) {
        UiComponent uiComponent = (UiComponent)SwingComponent.getClientProperty(object, "oracle.bpm.ui.key");
        if (uiComponent == null) {
            System.err.println("Could not get ui component from " + object);
        }
        return uiComponent;
    }

    protected Icon getIconFrom(Image image) {
        if (image != null) {
            SwingImage swingImage = (SwingImage)image.getPeer();
            Icon icon = swingImage.getIcon();
            return icon;
        }
        return null;
    }

    private void setParent(SwingComponent parent) {
        this.parent = parent;
    }

    public static interface ExtendedSwing {
        public Dimension getDefaultMaximumSize();

        public Dimension getDefaultMinimumSize();

        public Dimension getDefaultPreferredSize();

        public void defaultPaint(java.awt.Graphics var1);

        public void defaultPaintComponent(java.awt.Graphics var1);
    }
}

