/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.peer.swing;

import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import oracle.bpm.draw.AlphaComposite;
import oracle.bpm.draw.Color;
import oracle.bpm.draw.FontMetrics;
import oracle.bpm.draw.Graphics;
import oracle.bpm.draw.GraphicsUtils;
import oracle.bpm.ui.FontStyle;
import oracle.bpm.ui.peer.swing.SwingFont;
import oracle.bpm.ui.peer.swing.SwingFontMetrics;
import oracle.bpm.ui.peer.swing.SwingGraphics;
import org.jetbrains.annotations.NotNull;

public class AwtConverter {
    public static oracle.bpm.geom.Point fromAwt(Point point) {
        return point != null ? new oracle.bpm.geom.Point(point.x, point.y) : null;
    }

    public static oracle.bpm.geom.Dimension fromAwt(Dimension dimension) {
        return dimension != null ? oracle.bpm.geom.Dimension.valueOf((int)dimension.width, (int)dimension.height) : null;
    }

    public static oracle.bpm.geom.Rectangle fromAwt(Rectangle rectangle) {
        return rectangle != null ? new oracle.bpm.geom.Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height) : null;
    }

    public static oracle.bpm.geom.Insets fromAwt(Insets insets) {
        return new oracle.bpm.geom.Insets(insets.top, insets.left, insets.bottom, insets.right);
    }

    public static Color fromAwt(java.awt.Color color) {
        return color != null ? Color.valueOf(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()) : null;
    }

    public static Graphics fromAwt(java.awt.Graphics graphics) {
        return GraphicsUtils.create(graphics);
    }

    public static FontMetrics fromAwt(java.awt.FontMetrics fontMetrics) {
        return new SwingFontMetrics(fontMetrics);
    }

    public static Point toAwt(oracle.bpm.geom.Point point) {
        return new Point(point.getX(), point.getY());
    }

    public static Rectangle toAwt(oracle.bpm.geom.Rectangle rectangle) {
        return new Rectangle(rectangle.getX(), rectangle.getY(), rectangle.getWidth(), rectangle.getHeight());
    }

    public static Dimension toAwt(oracle.bpm.geom.Dimension dimension) {
        return new Dimension(dimension.getWidth(), dimension.getHeight());
    }

    public static Insets toAwt(oracle.bpm.geom.Insets insets) {
        return new Insets(insets.top, insets.left, insets.bottom, insets.right);
    }

    public static java.awt.Color toAwt(Color color) {
        return color != null ? new java.awt.Color(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()) : null;
    }

    public static java.awt.Graphics toAwt(Graphics graphics) {
        assert (graphics instanceof SwingGraphics);
        return ((SwingGraphics)graphics).getAwtGraphics();
    }

    public static Font toAwt(oracle.bpm.draw.Font font) {
        assert (font == null || font.getPeer() instanceof SwingFont);
        return font != null ? ((SwingFont)font.getPeer()).getAwtFont() : null;
    }

    public static AlphaComposite fromAwt(@NotNull Composite composite) {
        AlphaComposite result = AlphaComposite.SRC_OVER;
        if (composite.equals(java.awt.AlphaComposite.SrcOver)) {
            result = AlphaComposite.SRC_OVER;
        } else if (composite.equals(java.awt.AlphaComposite.Clear)) {
            result = AlphaComposite.CLEAR;
        } else if (composite.equals(java.awt.AlphaComposite.Dst)) {
            result = AlphaComposite.DST;
        } else if (composite.equals(java.awt.AlphaComposite.DstAtop)) {
            result = AlphaComposite.DST_ATOP;
        } else if (composite.equals(java.awt.AlphaComposite.DstIn)) {
            result = AlphaComposite.DST_IN;
        } else if (composite.equals(java.awt.AlphaComposite.DstOut)) {
            result = AlphaComposite.DST_OUT;
        } else if (composite.equals(java.awt.AlphaComposite.DstOver)) {
            result = AlphaComposite.DST_OVER;
        } else if (composite.equals(java.awt.AlphaComposite.Src)) {
            result = AlphaComposite.SRC;
        } else if (composite.equals(java.awt.AlphaComposite.SrcIn)) {
            result = AlphaComposite.SRC_IN;
        } else if (composite.equals(java.awt.AlphaComposite.SrcOut)) {
            result = AlphaComposite.SRC_OUT;
        } else if (composite.equals(java.awt.AlphaComposite.SrcAtop)) {
            result = AlphaComposite.SRC_ATOP;
        } else if (composite.equals(java.awt.AlphaComposite.Xor)) {
            result = AlphaComposite.XOR;
        }
        return result;
    }

    public static Composite toAwt(@NotNull AlphaComposite composite) {
        java.awt.AlphaComposite result;
        switch (composite) {
            case SRC_OVER: {
                result = java.awt.AlphaComposite.SrcOver;
                break;
            }
            case CLEAR: {
                result = java.awt.AlphaComposite.Clear;
                break;
            }
            case DST: {
                result = java.awt.AlphaComposite.Dst;
                break;
            }
            case DST_ATOP: {
                result = java.awt.AlphaComposite.DstAtop;
                break;
            }
            case DST_IN: {
                result = java.awt.AlphaComposite.DstIn;
                break;
            }
            case DST_OUT: {
                result = java.awt.AlphaComposite.DstOut;
                break;
            }
            case DST_OVER: {
                result = java.awt.AlphaComposite.DstOver;
                break;
            }
            case SRC: {
                result = java.awt.AlphaComposite.Src;
                break;
            }
            case SRC_ATOP: {
                result = java.awt.AlphaComposite.SrcAtop;
                break;
            }
            case SRC_IN: {
                result = java.awt.AlphaComposite.SrcIn;
                break;
            }
            case SRC_OUT: {
                result = java.awt.AlphaComposite.SrcOut;
                break;
            }
            case XOR: {
                result = java.awt.AlphaComposite.Xor;
                break;
            }
            default: {
                result = java.awt.AlphaComposite.SrcOver;
            }
        }
        return result;
    }

    static oracle.bpm.draw.Font fromAwt(Font font) {
        return oracle.bpm.draw.Font.valueOf(font.getName(), FontStyle.valueOf((int)font.getStyle()), font.getSize());
    }
}

