/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.monitor;

import oracle.bpm.msg.CoreMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.Dialog;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.ScrollPolicy;
import oracle.bpm.ui.Timer;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiUtilities;
import oracle.bpm.ui.Utilities;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.layout.AttributeConstraint;
import oracle.bpm.ui.layout.AttributeType;
import oracle.bpm.ui.layout.GridBagLayout;
import oracle.bpm.ui.layout.RelativeLayout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.monitor.UiProgressMonitor;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.statusbar.StatusBar;
import oracle.bpm.ui.text.TextArea;
import oracle.bpm.util.ProgressMonitor;

public class ProgressMonitorGUI
extends Panel
implements ProgressMonitor {
    private Button cancelButton;
    private Listener cancelListener;
    private int currentTask = 0;
    private int errorCount = 0;
    private Msg lastPendingMessage;
    private int lastPercent = Integer.MIN_VALUE;
    private int logLevel = 1;
    private TextArea logText;
    private int nTasks = 0;
    private StringBuilder pendingMessages = new StringBuilder();
    private boolean popupMsgOnErrors = false;
    private UiProgressMonitor progressBar;
    private UiProgressMonitor progressBarTotal;
    private StatusBar statusBar;
    private boolean taskCompleted = false;
    private Timer timer;
    private Msg title;
    private boolean visibleLog;
    private int warningCount = 0;

    public ProgressMonitorGUI(UiContainer parent, Msg title, boolean isCancelable, boolean logMessages, int nTasks, BaseAction[] actionArray) {
        super(parent, title);
        this.setLayout(new BorderLayout());
        this.nTasks = nTasks;
        this.visibleLog = logMessages;
        this.init(isCancelable, actionArray, false);
    }

    public ProgressMonitorGUI(UiContainer parent, Msg title, boolean isCancelable, boolean logMessages, int nTasks, BaseAction[] actionArray, boolean indeterminateProgress) {
        super(parent, title);
        this.setLayout(new BorderLayout());
        this.nTasks = nTasks;
        this.visibleLog = logMessages;
        this.init(isCancelable, actionArray, indeterminateProgress);
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public void setListener(Listener listener) {
        this.cancelListener = listener;
    }

    public boolean isTaskCompleted() {
        return this.taskCompleted;
    }

    public void setTitle(Msg title) {
        this.title = title;
    }

    @Override
    public Msg getTitleMsg() {
        return this.title;
    }

    public void setVisibleStatusBar(boolean b) {
        if (this.statusBar != null) {
            this.statusBar.setVisible(b);
        }
    }

    public int getWarningCount() {
        return this.warningCount;
    }

    public void addCancelListener() {
        if (this.cancelButton != null) {
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ProgressMonitorGUI.this.cancelButton.setEnabled(false);
                    ProgressMonitorGUI.this.statusBar.showNotice(UIMsg.CANCELLING);
                }
            });
        }
    }

    public void completeTask() {
        int actual;
        this.taskCompleted = true;
        if (this.timer != null) {
            this.timer.stop();
            this.timer = null;
        }
        if ((actual = this.progressBar.getValue()) <= 0 || actual >= 100) {
            return;
        }
        for (int i = actual + 1; i <= 100 && this.isVisible(); ++i) {
            this.progress(i);
        }
        this.sleep(50);
        if (!this.visibleLog) {
            // empty if block
        }
    }

    public void error(Msg msg) {
        this.progressMessage(CoreMsg.ERROR_MSG((String)msg.toString()));
        ++this.errorCount;
        if (this.popupMsgOnErrors) {
            Msg titleMsg = this.getTitleMsg() == null ? UIMsg.TO_MSG("") : this.getTitleMsg();
            MessageDialog.showError(titleMsg, msg);
        }
    }

    public void info(Msg message) {
        this.info(1, message);
    }

    public void info(int level, Msg message) {
        if (level <= this.logLevel) {
            this.progressMessage(message);
        }
    }

    public void phase(Msg msg) {
        this.phaseMessage(msg);
    }

    public void progress(final int percent) {
        if (this.lastPercent == percent) {
            return;
        }
        if (!UiUtilities.isEventDispatchThread()) {
            UiUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ProgressMonitorGUI.this.progress(percent);
                }
            });
            return;
        }
        if (percent == -1) {
            this.progressBar.setIndeterminate(true);
            this.lastPercent = percent;
            return;
        }
        int correctPercent = percent;
        if (percent >= 1000) {
            correctPercent = 0;
            this.progressBar.setIndeterminate(false);
        } else if (percent == -2) {
            this.progressBar.setIndeterminate(false);
            correctPercent = 100;
        } else if (percent < 0 || percent > 100) {
            throw new IllegalArgumentException("Percent must be a value between 0 and 100 or greater than 1000 for automatic update using a timer, and not: " + percent);
        }
        this.progressBar.setValue(correctPercent);
        this.lastPercent = correctPercent;
        if (this.nTasks > 1 && correctPercent > 0) {
            if (this.currentTask > this.nTasks) {
                this.currentTask = this.nTasks;
            }
            int offset = (this.currentTask - 1) * (100 / this.nTasks);
            int totalPercent = offset + correctPercent / this.nTasks;
            this.progressBarTotal.setTask(UIMsg.TOTAL_PROGRESS(this.currentTask, this.nTasks).getString());
            this.progressBarTotal.setValue(totalPercent);
        }
        if (percent >= 1000) {
            this.automaticUpdateProgressBar(percent);
        }
    }

    public void showMessageDialog(final Dialog d) {
        if (!UiUtilities.isEventDispatchThread()) {
            UiUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    d.setVisible(true);
                }
            });
        } else {
            d.setVisible(true);
        }
    }

    public void warning(Msg message) {
        this.progressMessage(CoreMsg.WARNING_MSG((String)message.toString()));
        ++this.warningCount;
    }

    protected boolean isCanceled() {
        return this.cancelButton != null && !this.cancelButton.isEnabled();
    }

    protected void sleep(int ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void automaticUpdateProgressBar(int duration) {
        int increments;
        int delay;
        if (this.timer == null) {
            this.timer = new Timer(0, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int percent = ProgressMonitorGUI.this.progressBar.getValue() + 1;
                    if (percent > 99 || ProgressMonitorGUI.this.isCanceled()) {
                        ProgressMonitorGUI.this.timer.stop();
                    } else {
                        ProgressMonitorGUI.this.progress(percent);
                        if (percent >= 70 && percent % 10 == 0) {
                            ProgressMonitorGUI.this.timer.setDelay(ProgressMonitorGUI.this.timer.getDelay() * 2);
                        }
                    }
                }
            });
        }
        if ((delay = duration / (increments = 100)) > 0) {
            this.timer.setInitialDelay(delay);
            this.timer.setDelay(delay);
            this.timer.start();
        }
    }

    private void fireCancelEvent() {
        if (this.cancelListener != null) {
            this.cancelListener.cancel();
        }
    }

    private void init(boolean isCancelable, BaseAction[] actionArray, boolean indeterminateProgress) {
        Panel mainPanel = new Panel(this);
        RelativeLayout relativeLayout = new RelativeLayout();
        mainPanel.setLayout(relativeLayout);
        String upper = "_container";
        AttributeType location = AttributeType.TOP;
        if (this.nTasks > 1) {
            this.progressBarTotal = new UiProgressMonitor(mainPanel);
            String TOTAL_STRING = "total";
            mainPanel.add(this.progressBarTotal, "total");
            relativeLayout.addConstraint("total", AttributeType.TOP, new AttributeConstraint(upper, location, 5));
            relativeLayout.addConstraint("total", AttributeType.LEFT, new AttributeConstraint("_container", AttributeType.LEFT, 5));
            upper = "total";
            location = AttributeType.BOTTOM;
        }
        if (this.visibleLog) {
            this.logText = new TextArea(mainPanel, ScrollPolicy.ALWAYS, ScrollPolicy.AS_NEEDED);
            this.logText.setEditable(false);
            this.logText.setRows(15);
            String LOG_STRING = "log";
            mainPanel.add(this.logText, "log");
            relativeLayout.addConstraint("log", AttributeType.TOP, new AttributeConstraint(upper, location, 5));
            relativeLayout.addConstraint("log", AttributeType.LEFT, new AttributeConstraint("_container", AttributeType.LEFT, 5));
            relativeLayout.addConstraint("log", AttributeType.RIGHT, new AttributeConstraint("_container", AttributeType.RIGHT, -5));
            upper = "log";
            location = AttributeType.BOTTOM;
        }
        this.progressBar = new UiProgressMonitor(mainPanel);
        this.progressBar.setIndeterminate(indeterminateProgress);
        if (indeterminateProgress) {
            this.progressBar.setMessage("");
        }
        String PROGRESS_STRING = "progress";
        mainPanel.add(this.progressBar, "progress");
        relativeLayout.addConstraint("progress", AttributeType.TOP, new AttributeConstraint(upper, location, 5));
        relativeLayout.addConstraint("progress", AttributeType.LEFT, new AttributeConstraint("_container", AttributeType.LEFT, 5));
        relativeLayout.addConstraint("progress", AttributeType.RIGHT, new AttributeConstraint("_container", AttributeType.RIGHT, 5));
        Panel cancelPanel = null;
        if (isCancelable) {
            cancelPanel = new Panel(this);
            cancelPanel.setLayout(new GridBagLayout());
            this.cancelButton = new Button((UiContainer)cancelPanel, CoreMsg.CANCEL);
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    try {
                        ProgressMonitorGUI.this.fireCancelEvent();
                    }
                    catch (Exception e) {
                        ProgressMonitorGUI.this.statusBar.showWarning(UIMsg.CANNOT_CANCEL);
                    }
                }
            });
            this.statusBar = new StatusBar(cancelPanel);
            this.statusBar.makeRecyclable();
            Utilities.addConstrainedComponent(cancelPanel, this.statusBar, 0, 0, 1, 1, 2, 17, 1.0, 0.0, 5, 5, 5, 5);
            if (actionArray != null) {
                for (int i = 0; i < actionArray.length; ++i) {
                    Utilities.addConstrainedComponent(cancelPanel, new Button((UiContainer)cancelPanel, actionArray[i]), 1 + i, 0, 1, 1, 0, 13, 0.0, 0.0, 5, 5, 5, 5);
                }
            }
            Utilities.addConstrainedComponent(cancelPanel, this.cancelButton, actionArray == null ? 1 : 1 + actionArray.length, 0, 1, 1, 0, 13, 0.0, 0.0, 5, 5, 5, 5);
        }
        this.add(mainPanel, "Center");
        if (cancelPanel != null) {
            this.add(cancelPanel, "South");
        }
    }

    private void phaseMessage(final Msg msg) {
        if (this.isDisposed()) {
            return;
        }
        if (!UiUtilities.isEventDispatchThread()) {
            UiUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ProgressMonitorGUI.this.phaseMessage(msg);
                }
            });
            return;
        }
        this.completeTask();
        ++this.currentTask;
        if (this.lastPercent > 0) {
            this.progress(0);
            this.taskCompleted = false;
        }
        if (this.logText != null) {
            this.logText.append(msg.getString() + "\n");
            this.logText.setCaretPosition(this.logText.getTextLength());
        } else {
            this.progressBar.setTask(msg.getString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void progressMessage(Msg msg) {
        boolean launchRunnable;
        StringBuilder stringBuilder = this.pendingMessages;
        synchronized (stringBuilder) {
            launchRunnable = this.pendingMessages.length() == 0;
            this.pendingMessages.append(msg.getString()).append("\n");
            this.lastPendingMessage = msg;
        }
        if (launchRunnable) {
            if (!UiUtilities.isEventDispatchThread()) {
                UiUtilities.invokeLater(new MessageProcessor());
                return;
            }
            this.processPendingMessages();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPendingMessages() {
        String lastMessage;
        String messages;
        StringBuilder stringBuilder = this.pendingMessages;
        synchronized (stringBuilder) {
            messages = this.pendingMessages.toString();
            lastMessage = this.lastPendingMessage.getString();
            this.pendingMessages.setLength(0);
            this.lastPendingMessage = null;
        }
        if (this.logText != null && !this.logText.isDisposed()) {
            this.logText.append(messages);
            this.logText.setCaretPosition(this.logText.getTextLength());
        } else if (!this.progressBar.isDisposed()) {
            this.progressBar.setTask(lastMessage);
        }
    }

    private final class MessageProcessor
    implements Runnable {
        private MessageProcessor() {
        }

        @Override
        public void run() {
            ProgressMonitorGUI.this.processPendingMessages();
        }
    }

    public static class CancelMonitorException
    extends RuntimeException {
        static final long serialVersionUID = -280315527816645373L;
        static final long serialCheck = -873242776300953089L;

        public CancelMonitorException() {
            super("Progress Monitor Cancelled");
        }
    }

    public static interface Listener {
        public void cancel();
    }
}

