/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.monitor;

import oracle.bpm.draw.Color;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.ScrollPolicy;
import oracle.bpm.ui.SwingWorker;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiUtilities;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.ui.layout.form.PanelBuilder;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.text.TextArea;

class DetailPanel
extends Panel {
    private Button arrowButton;
    private Label instructionLabel;
    private boolean isShowDetail = DEFAULT_STATE;
    private LoggerPanel loggerPanel;
    private static boolean DEFAULT_STATE = false;

    DetailPanel(UiContainer parent) {
        super(parent);
        this.setLayout(new BorderLayout());
        this.init();
    }

    public LoggerPanel getLoggerPanel() {
        return this.loggerPanel;
    }

    private Msg getMsg(boolean selected) {
        return selected ? UIMsg.HIDE_PROGRESS_DETAILS : UIMsg.SHOW_PROGRESS_DETAILS;
    }

    private void init() {
        Panel container = new Panel(this);
        this.arrowButton = new Button((UiContainer)container, this.getMsg(DEFAULT_STATE), 2);
        this.arrowButton.setBorder(null);
        this.arrowButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DetailPanel.this.showAndHideDetail();
            }
        });
        this.instructionLabel = Label.create((UiContainer)container, UIMsg.SHOW_PROGRESS_DETAILS);
        this.loggerPanel = new LoggerPanel(container);
        this.loggerPanel.setVisible(DEFAULT_STATE);
        String colSpecs = "pref, 5dlu, pref:grow";
        String rowSpecs = "pref, 2dlu, pref:grow";
        FormLayout layout = new FormLayout(colSpecs, rowSpecs);
        PanelBuilder builder = layout.createBuilder(container);
        CellConstraints cc = layout.createCellConstraints();
        builder.add((UiComponent)this.arrowButton, cc.xy(1, 1));
        builder.add((UiComponent)this.instructionLabel, cc.xy(3, 1));
        builder.add((UiComponent)this.loggerPanel, cc.xywh(1, 3, 3, 1));
        this.add(container, "Center");
    }

    private void showAndHideDetail() {
        SwingWorker worker = new SwingWorker(){

            public Object construct() {
                return null;
            }

            @Override
            public void finished() {
                DetailPanel.this.isShowDetail = !DetailPanel.this.isShowDetail;
                Msg msg = DetailPanel.this.getMsg(DetailPanel.this.isShowDetail);
                DetailPanel.this.arrowButton.setMsg(msg);
                DetailPanel.this.instructionLabel.setMsg(msg);
                DetailPanel.this.loggerPanel.setVisible(DetailPanel.this.isShowDetail);
                UiWindow w = UiUtilities.getWindowAncestor(DetailPanel.this);
                if (w != null) {
                    w.pack();
                }
            }
        };
        worker.start();
    }

    static class LoggerPanel
    extends TextArea {
        private static String INDENT = "   ";
        private static final Color BACKGROUND_COLOR = Color.BLACK;
        private static final Color FOREGROUND_COLOR = Color.GREEN;

        LoggerPanel(UiContainer parent) {
            super(parent, ScrollPolicy.ALWAYS, ScrollPolicy.ALWAYS);
            this.setRows(6);
            this.setColumns(20);
            this.setEditable(false);
            this.setBackground(BACKGROUND_COLOR);
            this.setForeground(FOREGROUND_COLOR);
        }

        public void detail(Msg msg) {
            this.append(INDENT + msg.getString());
        }

        public void error(Msg msg) {
            this.append(INDENT + UIMsg.ERROR.getString() + ": " + msg.getString());
        }

        public void info(Msg msg) {
            this.append(INDENT + msg.getString());
        }

        public void task(Msg msg) {
            this.append(msg.getString());
        }

        public void warning(Msg msg) {
            this.append(INDENT + UIMsg.WARNING.getString() + ": " + msg.getString());
        }

        @Override
        public void append(String s) {
            super.append(s + "\n");
            this.setCaretPosition(this.getTextLength());
        }
    }
}

