/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.layout.form;

import java.util.logging.Logger;
import oracle.bpm.ui.layout.form.ConstantSize;
import oracle.bpm.ui.layout.form.MacLayoutStyle;
import oracle.bpm.ui.layout.form.Size;
import oracle.bpm.ui.layout.form.WindowsLayoutStyle;

public abstract class LayoutStyle {
    private static LayoutStyle current = LayoutStyle.initialLayoutStyle();

    public abstract ConstantSize getButtonBarPad();

    public abstract Size getDefaultButtonHeight();

    public abstract Size getDefaultButtonWidth();

    public abstract ConstantSize getDialogMarginX();

    public abstract ConstantSize getDialogMarginY();

    public abstract ConstantSize getLabelComponentPadX();

    public abstract boolean isLeftToRightButtonOrder();

    public abstract ConstantSize getLinePad();

    public abstract ConstantSize getNarrowLinePad();

    public abstract ConstantSize getParagraphPad();

    public abstract ConstantSize getRelatedComponentsPadX();

    public abstract ConstantSize getRelatedComponentsPadY();

    public abstract ConstantSize getTabbedDialogMarginX();

    public abstract ConstantSize getTabbedDialogMarginY();

    public abstract ConstantSize getUnrelatedComponentsPadX();

    public abstract ConstantSize getUnrelatedComponentsPadY();

    public static void setCurrent(LayoutStyle newLayoutStyle) {
        current = newLayoutStyle;
    }

    public static LayoutStyle getCurrent() {
        return current;
    }

    private static boolean isOSMac() {
        return LayoutStyle.getSystemProperty("os.name").startsWith("Mac");
    }

    private static String getSystemProperty(String key) {
        try {
            return System.getProperty(key);
        }
        catch (SecurityException e) {
            Logger.getLogger(LayoutStyle.class.getName()).warning("Can't read the System property " + key + ".");
            return "";
        }
    }

    private static LayoutStyle initialLayoutStyle() {
        if (LayoutStyle.isOSMac()) {
            return MacLayoutStyle.INSTANCE;
        }
        return WindowsLayoutStyle.INSTANCE;
    }
}

