/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.layout.form;

import java.util.ResourceBundle;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.layout.form.ConstantSize;
import oracle.bpm.ui.layout.form.FormFactory;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.ui.layout.form.I15dPanelBuilder;
import oracle.bpm.ui.layout.form.RowSpec;

public final class DefaultFormBuilder
extends I15dPanelBuilder {
    private int leadingColumnOffset = 0;
    private RowSpec lineGapSpec = FormFactory.LINE_GAP_ROWSPEC;
    private RowSpec paragraphGapSpec = FormFactory.PARAGRAPH_GAP_ROWSPEC;
    private boolean rowGroupingEnabled = false;

    public DefaultFormBuilder(UiContainer parent, FormLayout layout) {
        this(layout, new Panel(parent));
    }

    public DefaultFormBuilder(FormLayout layout, Panel panel) {
        this(layout, null, panel);
    }

    @Deprecated
    public DefaultFormBuilder(Panel panel, FormLayout layout) {
        this(layout, null, panel);
    }

    public DefaultFormBuilder(UiContainer parent, FormLayout layout, ResourceBundle bundle) {
        this(layout, bundle, new Panel(parent));
    }

    public DefaultFormBuilder(FormLayout layout, ResourceBundle bundle, Panel panel) {
        super(layout, bundle, panel);
    }

    @Deprecated
    public DefaultFormBuilder(Panel panel, FormLayout layout, ResourceBundle bundle) {
        super(layout, bundle, panel);
    }

    public void setLeadingColumnOffset(int columnOffset) {
        this.leadingColumnOffset = columnOffset;
    }

    public int getLeadingColumnOffset() {
        return this.leadingColumnOffset;
    }

    public void setLineGapSize(ConstantSize lineGapSize) {
        RowSpec rowSpec;
        this.lineGapSpec = rowSpec = FormFactory.createGapRowSpec(lineGapSize);
    }

    public RowSpec getLineGapSpec() {
        return this.lineGapSpec;
    }

    public void setParagraphGapSize(ConstantSize paragraphGapSize) {
        RowSpec rowSpec;
        this.paragraphGapSpec = rowSpec = FormFactory.createGapRowSpec(paragraphGapSize);
    }

    public void setRowGroupingEnabled(boolean enabled) {
        this.rowGroupingEnabled = enabled;
    }

    public boolean isRowGroupingEnabled() {
        return this.rowGroupingEnabled;
    }

    public void append(UiComponent component) {
        this.append(component, 1);
    }

    public void append(UiComponent component, int columnSpan) {
        this.ensureCursorColumnInGrid();
        this.ensureHasGapRow(this.lineGapSpec);
        this.ensureHasComponentLine();
        this.add(component, this.createLeftAdjustedConstraints(columnSpan));
        this.nextColumn(columnSpan + 1);
    }

    public void append(UiComponent c1, UiComponent c2) {
        this.append(c1);
        this.append(c2);
    }

    public void append(UiComponent c1, UiComponent c2, UiComponent c3) {
        this.append(c1);
        this.append(c2);
        this.append(c3);
    }

    public Label append(UiContainer parent, String textWithMnemonic) {
        Label label = this.getComponentFactory().createLabel(parent, textWithMnemonic);
        this.append(label);
        return label;
    }

    public Label append(String textWithMnemonic, UiComponent component) {
        return this.append(textWithMnemonic, component, 1);
    }

    public Label append(String textWithMnemonic, UiComponent c, int columnSpan) {
        Label label = this.append(null, textWithMnemonic);
        label.setLabelFor(c);
        this.append(c, columnSpan);
        return label;
    }

    public Label append(String textWithMnemonic, UiComponent c1, UiComponent c2) {
        Label label = this.append(textWithMnemonic, c1);
        this.append(c2);
        return label;
    }

    public void append(String textWithMnemonic, UiComponent c1, UiComponent c2, int colSpan) {
        this.append(textWithMnemonic, c1);
        this.append(c2, colSpan);
    }

    public Label append(String textWithMnemonic, UiComponent c1, UiComponent c2, UiComponent c3) {
        Label label = this.append(textWithMnemonic, c1, c2);
        this.append(c3);
        return label;
    }

    public Label append(String textWithMnemonic, UiComponent c1, UiComponent c2, UiComponent c3, UiComponent c4) {
        Label label = this.append(textWithMnemonic, c1, c2, c3);
        this.append(c4);
        return label;
    }

    public Label appendI15d(String resourceKey) {
        return this.append(null, this.getI15dString(resourceKey));
    }

    public Label appendI15d(String resourceKey, UiComponent c, int columnSpan) {
        Label label = this.appendI15d(resourceKey);
        this.append(c, columnSpan);
        return label;
    }

    public Label appendI15d(String resourceKey, UiComponent component) {
        return this.appendI15d(resourceKey, component, 1);
    }

    public Label appendI15d(String resourceKey, UiComponent component, boolean nextLine) {
        Label label = this.appendI15d(resourceKey, component, 1);
        if (nextLine) {
            this.nextLine();
        }
        return label;
    }

    public Label appendI15d(String resourceKey, UiComponent c1, UiComponent c2) {
        Label label = this.appendI15d(resourceKey, c1);
        this.append(c2);
        return label;
    }

    public Label appendI15d(String resourceKey, UiComponent c1, UiComponent c2, int colSpan) {
        Label label = this.appendI15d(resourceKey, c1);
        this.append(c2, colSpan);
        return label;
    }

    public Label appendI15d(String resourceKey, UiComponent c1, UiComponent c2, UiComponent c3) {
        Label label = this.appendI15d(resourceKey, c1, c2);
        this.append(c3);
        return label;
    }

    public Label appendI15d(String resourceKey, UiComponent c1, UiComponent c2, UiComponent c3, UiComponent c4) {
        Label label = this.appendI15d(resourceKey, c1, c2, c3);
        this.append(c4);
        return label;
    }

    public void appendI15dSeparator(String resourceKey) {
        this.appendSeparator(this.getI15dString(resourceKey));
    }

    public Label appendI15dTitle(UiContainer parent, String resourceKey) {
        return this.appendTitle(parent, this.getI15dString(resourceKey));
    }

    public UiComponent appendSeparator() {
        return this.appendSeparator("");
    }

    public UiComponent appendSeparator(String text) {
        this.ensureCursorColumnInGrid();
        this.ensureHasGapRow(this.paragraphGapSpec);
        this.ensureHasComponentLine();
        this.setColumn(super.getLeadingColumn());
        int columnSpan = this.getColumnCount();
        this.setColumnSpan(this.getColumnCount());
        UiComponent titledSeparator = this.addSeparator(text);
        this.setColumnSpan(1);
        this.nextColumn(columnSpan);
        return titledSeparator;
    }

    public Label appendTitle(UiContainer parent, String textWithMnemonic) {
        Label titleLabel = this.getComponentFactory().createTitle(parent, textWithMnemonic);
        this.append(titleLabel);
        return titleLabel;
    }

    @Override
    protected int getLeadingColumn() {
        int column = super.getLeadingColumn();
        return column + this.getLeadingColumnOffset() * this.getColumnIncrementSign();
    }

    private RowSpec getCursorRowSpec() {
        return this.getLayout().getRowSpec(this.getRow());
    }

    private void ensureCursorColumnInGrid() {
        if (this.isLeftToRight() && this.getColumn() > this.getColumnCount() || !this.isLeftToRight() && this.getColumn() < 1) {
            this.nextLine();
        }
    }

    private void ensureHasComponentLine() {
        if (this.getRow() <= this.getRowCount()) {
            return;
        }
        this.appendRow(FormFactory.PREF_ROWSPEC);
        if (this.isRowGroupingEnabled()) {
            this.getLayout().addGroupedRow(this.getRow());
        }
    }

    private void ensureHasGapRow(RowSpec gapRowSpec) {
        RowSpec rowSpec;
        if (this.getRow() == 1 || this.getRow() <= this.getRowCount()) {
            return;
        }
        if (this.getRow() <= this.getRowCount() && (rowSpec = this.getCursorRowSpec()) == gapRowSpec) {
            return;
        }
        this.appendRow(gapRowSpec);
        this.nextLine();
    }
}

