/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.layout.form;

import oracle.bpm.ui.Button;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.layout.form.Borders;
import oracle.bpm.ui.layout.form.ColumnSpec;
import oracle.bpm.ui.layout.form.ConstantSize;
import oracle.bpm.ui.layout.form.FormFactory;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.ui.layout.form.LayoutStyle;
import oracle.bpm.ui.layout.form.PanelBuilder;
import oracle.bpm.ui.layout.form.RowSpec;

public final class ButtonBarBuilder
extends PanelBuilder {
    private boolean leftToRight = LayoutStyle.getCurrent().isLeftToRightButtonOrder();
    private static final ColumnSpec[] COL_SPECS = new ColumnSpec[0];
    private static final RowSpec[] ROW_SPECS = new RowSpec[]{new RowSpec("center:pref")};
    private static final String NARROW_KEY = "jgoodies.isNarrow";

    public ButtonBarBuilder(UiContainer parent) {
        this(new Panel(parent));
    }

    public ButtonBarBuilder(Panel panel) {
        super(new FormLayout(COL_SPECS, ROW_SPECS), panel);
    }

    public static ButtonBarBuilder createLeftToRightBuilder(UiContainer parent) {
        ButtonBarBuilder builder = new ButtonBarBuilder(parent);
        builder.setLeftToRightButtonOrder(true);
        return builder;
    }

    public void setDefaultButtonBarGapBorder() {
        this.getPanel().setBorder(Borders.BUTTON_BAR_GAP_BORDER);
    }

    public void setLeftToRightButtonOrder(boolean newButtonOrder) {
        this.leftToRight = newButtonOrder;
    }

    public boolean isLeftToRightButtonOrder() {
        return this.leftToRight;
    }

    public void addFixed(UiComponent component) {
        this.getLayout().appendColumn(FormFactory.PREF_COLSPEC);
        this.add(component);
        this.nextColumn();
    }

    public void addFixedNarrow(UiComponent component) {
        component.putClientProperty(NARROW_KEY, Boolean.TRUE);
        this.addFixed(component);
    }

    public void addGlue() {
        this.appendGlueColumn();
        this.nextColumn();
    }

    public void addGridded(UiComponent component) {
        this.getLayout().appendColumn(FormFactory.BUTTON_COLSPEC);
        this.getLayout().addGroupedColumn(this.getColumn());
        component.putClientProperty(NARROW_KEY, Boolean.TRUE);
        this.add(component);
        this.nextColumn();
    }

    public void addGriddedButtons(Button[] buttons) {
        int length = buttons.length;
        for (int i = 0; i < length; ++i) {
            int index = this.leftToRight ? i : length - 1 - i;
            this.addGridded(buttons[index]);
            if (i >= buttons.length - 1) continue;
            this.addRelatedGap();
        }
    }

    public void addGriddedGrowing(UiComponent component) {
        this.getLayout().appendColumn(FormFactory.GROWING_BUTTON_COLSPEC);
        this.getLayout().addGroupedColumn(this.getColumn());
        component.putClientProperty(NARROW_KEY, Boolean.TRUE);
        this.add(component);
        this.nextColumn();
    }

    public void addGriddedGrowingButtons(Button[] buttons) {
        int length = buttons.length;
        for (int i = 0; i < length; ++i) {
            int index = this.leftToRight ? i : length - 1 - i;
            this.addGriddedGrowing(buttons[index]);
            if (i >= buttons.length - 1) continue;
            this.addRelatedGap();
        }
    }

    public void addRelatedGap() {
        this.appendRelatedComponentsGapColumn();
        this.nextColumn();
    }

    public void addStrut(ConstantSize size) {
        this.getLayout().appendColumn(new ColumnSpec(ColumnSpec.LEFT, size, 0.0));
        this.nextColumn();
    }

    public void addUnrelatedGap() {
        this.appendUnrelatedComponentsGapColumn();
        this.nextColumn();
    }
}

