/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.layout.border;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.bpm.geom.Dimension;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.Frame;
import oracle.bpm.ui.Margin;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiType;
import oracle.bpm.ui.layout.Layout;

public class BorderLayout
implements Layout {
    private Map<String, UiComponent> cache = new HashMap<String, UiComponent>();
    private int hgap;
    private int vgap;
    public static final String NORTH = "North";
    public static final String SOUTH = "South";
    public static final String EAST = "East";
    public static final String WEST = "West";
    public static final String CENTER = "Center";
    public static final String BEFORE_FIRST_LINE = "First";
    public static final String AFTER_LAST_LINE = "Last";
    public static final String BEFORE_LINE_BEGINS = "Before";
    public static final String AFTER_LINE_ENDS = "After";
    public static final String PAGE_START = "First";
    public static final String PAGE_END = "Last";
    public static final String LINE_START = "Before";
    public static final String LINE_END = "After";
    public static final String[] VALID_LAYOUT_DATA = new String[]{"North", "South", "East", "West", "Center", "First", "Last", "Before", "After", "First", "Last", "Before", "After"};

    public BorderLayout() {
        this(0, 0);
    }

    public BorderLayout(int hgap, int vgap) {
        this.hgap = hgap;
        this.vgap = vgap;
    }

    public static void main(String[] args) {
        Ui.initialize(UiType.SWT);
        Frame frame = new Frame("Title");
        UiContainer contentPane = frame.getContentPane();
        Panel panel = new Panel(contentPane);
        panel.setLayout(new BorderLayout());
        Button north = new Button(panel);
        north.setText("north");
        Button east = new Button(panel);
        east.setText("east");
        Button south = new Button(panel);
        south.setText("south");
        Button west = new Button(panel);
        west.setText("west");
        Button center = new Button(panel);
        center.setText("center");
        panel.add(north, NORTH);
        panel.add(east, EAST);
        panel.add(south, SOUTH);
        panel.add(west, WEST);
        panel.add(center, CENTER);
        contentPane.add(panel, CENTER);
        frame.setSize(400, 300);
        frame.setVisible(true);
    }

    public void addLayoutComponent(UiComponent comp, Object constraints) {
        if (constraints != null && !(constraints instanceof String)) {
            throw new IllegalArgumentException("constraint must be a string");
        }
        this.addLayoutComponent((String)constraints, comp);
    }

    public void addLayoutComponent(String name, UiComponent comp) {
    }

    public int getHgap() {
        return this.hgap;
    }

    @Override
    public float getLayoutAlignmentX(UiContainer parent) {
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(UiContainer parent) {
        return 0.5f;
    }

    public int getVgap() {
        return this.vgap;
    }

    @Override
    public void invalidateLayout(UiContainer target) {
        this.cache.clear();
    }

    @Override
    public void validateAddedComponent(UiContainer container, UiComponent component, Object constraints) {
    }

    @Override
    public void layoutContainer(UiContainer target) {
        Dimension d;
        Margin insets = target.getInsets();
        int top = insets.top;
        int bottom = target.getHeight() - insets.bottom;
        int left = insets.left;
        int right = target.getWidth() - insets.right;
        boolean ltr = target.getComponentOrientation().isLeftToRight();
        UiComponent c = this.getChild(target, NORTH, ltr);
        if (c != null) {
            d = c.getPreferredSize();
            c.setBounds(left, top, right - left, d.getHeight());
            top += d.getHeight() + this.vgap;
        }
        if ((c = this.getChild(target, SOUTH, ltr)) != null) {
            d = c.getPreferredSize();
            c.setBounds(left, bottom - d.getHeight(), right - left, d.getHeight());
            bottom -= d.getHeight() + this.vgap;
        }
        if ((c = this.getChild(target, EAST, ltr)) != null) {
            d = c.getPreferredSize();
            c.setBounds(right - d.getWidth(), top, d.getWidth(), bottom - top);
            right -= d.getWidth() + this.hgap;
        }
        if ((c = this.getChild(target, WEST, ltr)) != null) {
            d = c.getPreferredSize();
            c.setBounds(left, top, d.getWidth(), bottom - top);
            left += d.getWidth() + this.hgap;
        }
        if ((c = this.getChild(target, CENTER, ltr)) != null) {
            c.setBounds(left, top, right - left, bottom - top);
        }
        target.repaint();
    }

    @Override
    public Dimension maximumLayoutSize(UiContainer target) {
        return Dimension.MAX_VALUE;
    }

    @Override
    public Dimension minimumLayoutSize(UiContainer target) {
        Dimension d;
        boolean ltr = target.getComponentOrientation().isLeftToRight();
        int width = 0;
        int height = 0;
        UiComponent c = this.getChild(target, EAST, ltr);
        if (c != null) {
            d = c.getMinimumSize();
            width += d.getWidth() + this.hgap;
            height = Math.max(d.getHeight(), height);
        }
        if ((c = this.getChild(target, WEST, ltr)) != null) {
            d = c.getMinimumSize();
            width += d.getWidth() + this.hgap;
            height = Math.max(d.getHeight(), height);
        }
        if ((c = this.getChild(target, CENTER, ltr)) != null) {
            d = c.getMinimumSize();
            width += d.getWidth();
            height = Math.max(d.getHeight(), height);
        }
        if ((c = this.getChild(target, NORTH, ltr)) != null) {
            d = c.getMinimumSize();
            width = Math.max(d.getWidth(), width);
            height += d.getHeight() + this.vgap;
        }
        if ((c = this.getChild(target, SOUTH, ltr)) != null) {
            d = c.getMinimumSize();
            width = Math.max(d.getWidth(), width);
            height += d.getHeight() + this.vgap;
        }
        Margin insets = target.getInsets();
        return Dimension.valueOf((int)(width += insets.left + insets.right), (int)(height += insets.top + insets.bottom));
    }

    @Override
    public Dimension preferredLayoutSize(UiContainer target) {
        Dimension d;
        boolean ltr = target.getComponentOrientation().isLeftToRight();
        int width = 0;
        int height = 0;
        UiComponent c = this.getChild(target, EAST, ltr);
        if (c != null) {
            d = c.getPreferredSize();
            width += d.getWidth() + this.hgap;
            height = Math.max(d.getHeight(), height);
        }
        if ((c = this.getChild(target, WEST, ltr)) != null) {
            d = c.getPreferredSize();
            width += d.getWidth() + this.hgap;
            height = Math.max(d.getHeight(), height);
        }
        if ((c = this.getChild(target, CENTER, ltr)) != null) {
            d = c.getPreferredSize();
            width += d.getWidth();
            height = Math.max(d.getHeight(), height);
        }
        if ((c = this.getChild(target, NORTH, ltr)) != null) {
            d = c.getPreferredSize();
            width = Math.max(d.getWidth(), width);
            height += d.getHeight() + this.vgap;
        }
        if ((c = this.getChild(target, SOUTH, ltr)) != null) {
            d = c.getPreferredSize();
            width = Math.max(d.getWidth(), width);
            height += d.getHeight() + this.vgap;
        }
        Margin insets = target.getInsets();
        return Dimension.valueOf((int)(width += insets.left + insets.right), (int)(height += insets.top + insets.bottom));
    }

    @Override
    public void removeLayoutComponent(UiComponent comp) {
    }

    public void setHgap(int hgap) {
        this.hgap = hgap;
    }

    public void setVgap(int vgap) {
        this.vgap = vgap;
    }

    private UiComponent getChild(UiContainer container, String key, boolean ltr) {
        UiComponent result = this.cache.get(key);
        if (result != null) {
            result = result.isVisible() ? result : null;
        } else {
            List<UiComponent> children = container.getChildren();
            for (UiComponent component : children) {
                Object data = component.getLayoutData();
                if (data == null || !(data instanceof String)) {
                    data = CENTER;
                }
                if (!key.equals(data)) continue;
                this.cache.put(key, component);
                result = component.isVisible() ? component : null;
                break;
            }
        }
        return result;
    }
}

