/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.layout;

import java.util.HashSet;
import java.util.Set;
import oracle.bpm.geom.Dimension;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.layout.Layout;

public class LayoutDebugger
implements Layout {
    private Layout delegate;
    private static Set<Layout> debugged = new HashSet<Layout>();

    public LayoutDebugger(Layout delegate) {
        this.delegate = delegate;
        debugged.add(delegate);
    }

    public static void print(Layout layout, String message) {
        if (LayoutDebugger.isDebugged(layout)) {
            System.out.println("[" + (Object)((Object)Ui.getType()) + "]    " + message);
        }
    }

    public static boolean isDebugged(Layout layout) {
        return debugged.contains(layout);
    }

    @Override
    public void validateAddedComponent(UiContainer container, UiComponent component, Object constraints) {
    }

    @Override
    public float getLayoutAlignmentX(UiContainer container) {
        return this.intercept("getLayoutAlignmentX", container, Float.valueOf(this.delegate.getLayoutAlignmentX(container))).floatValue();
    }

    @Override
    public float getLayoutAlignmentY(UiContainer container) {
        return this.intercept("getLayoutAlignmentY", container, Float.valueOf(this.delegate.getLayoutAlignmentY(container))).floatValue();
    }

    @Override
    public void invalidateLayout(UiContainer container) {
        this.intercept("invalidateLayout", container, Void.class);
        this.delegate.invalidateLayout(container);
    }

    @Override
    public void layoutContainer(UiContainer container) {
        this.intercept("layoutContainer", container, Void.class);
        this.delegate.layoutContainer(container);
    }

    @Override
    public Dimension maximumLayoutSize(UiContainer container) {
        return this.intercept("maximumLayoutSize", container, this.delegate.maximumLayoutSize(container));
    }

    @Override
    public Dimension minimumLayoutSize(UiContainer container) {
        return this.intercept("minimumLayoutSize", container, this.delegate.minimumLayoutSize(container));
    }

    @Override
    public Dimension preferredLayoutSize(UiContainer container) {
        return this.intercept("preferredLayoutSize", container, this.delegate.preferredLayoutSize(container));
    }

    @Override
    public void removeLayoutComponent(UiComponent container) {
        this.intercept("removeLayoutComponent", container, Void.class);
    }

    private <T> T intercept(String method, UiComponent container, T result) {
        System.out.println("[" + (Object)((Object)Ui.getType()) + "] " + this.delegate.getClass().getSimpleName() + "." + method + "(" + container + ") -> " + result);
        return result;
    }
}

