/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.layout;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import oracle.bpm.ui.layout.Attribute;

public class DependencyManager {
    private Map<Attribute, Node> nodes = new HashMap<Attribute, Node>();
    private List<Node> roots;
    private List<Attribute> sortedNodes;
    private boolean valid = false;
    public static final String VERSION = "$Id: DependencyManager.java /main/2 2010/04/16 12:28:44 ferorodr Exp $";
    public static final String ROOT_NAME = "_container";

    public void add(Attribute dependent, Attribute anchor) throws IllegalStateException {
        Node anchorNode = this.getNode(anchor);
        this.getNode(dependent);
        if (anchorNode.hasDependent(dependent)) {
            throw new IllegalStateException(dependent + " already dependent on " + anchor);
        }
        anchorNode.addDependent(dependent);
    }

    public List sort() {
        if (this.sortedNodes != null) {
            return this.sortedNodes;
        }
        if (!this.valid) {
            this.validate();
        }
        ArrayList<Attribute> result = new ArrayList<Attribute>(this.nodes.size());
        for (Node root : this.roots) {
            this.recursiveSort(result, root);
        }
        this.sortedNodes = Collections.unmodifiableList(result);
        return this.sortedNodes;
    }

    public void validate() {
        this.roots = this.getRootNodes();
        for (Node root : this.roots) {
            if (!root.attribute.getComponent().equals(ROOT_NAME)) {
                throw new IllegalStateException("Unresolvable dependency: " + root.attribute);
            }
            this.checkNodeForCycles(root, 0);
        }
        this.valid = true;
    }

    private Node getNode(Attribute attribute) {
        Node node = this.nodes.get(attribute);
        if (node == null) {
            node = new Node(attribute);
            this.nodes.put(attribute, node);
        }
        return node;
    }

    private List<Node> getRootNodes() {
        this.resetNodes();
        for (Node anchorNode : this.nodes.values()) {
            for (int i = 0; i < anchorNode.size(); ++i) {
                Attribute dependentAttribute = anchorNode.getDependent(i);
                if (dependentAttribute.equals(anchorNode.attribute)) {
                    throw new IllegalStateException(anchorNode + " depends on itself");
                }
                ++this.nodes.get((Object)dependentAttribute).refCount;
            }
        }
        ArrayList<Node> roots = new ArrayList<Node>();
        for (Node candidate : this.nodes.values()) {
            if (candidate.refCount != 0) continue;
            roots.add(candidate);
        }
        return roots;
    }

    private void checkNodeForCycles(Node node, int depth) {
        if (++depth > this.nodes.size()) {
            throw new IllegalStateException("Cycle detected for attribute " + node.attribute);
        }
        for (int i = 0; i < node.size(); ++i) {
            Attribute dependentAttribute = node.getDependent(i);
            Node dependentNode = this.nodes.get(dependentAttribute);
            this.checkNodeForCycles(dependentNode, depth);
        }
    }

    private void recursiveSort(List<Attribute> sorted, Node anchorNode) {
        for (int i = 0; i < anchorNode.size(); ++i) {
            Attribute dependentAttribute = anchorNode.getDependent(i);
            Node dependentNode = this.nodes.get(dependentAttribute);
            if (--dependentNode.refCount != 0) continue;
            sorted.add(dependentAttribute);
            this.recursiveSort(sorted, dependentNode);
        }
    }

    private void resetNodes() {
        for (Node node : this.nodes.values()) {
            node.refCount = 0;
        }
    }

    private static class Node {
        final Attribute attribute;
        List<Attribute> dependents = new LinkedList<Attribute>();
        int refCount;

        Node(Attribute attribute) {
            this.attribute = attribute;
        }

        Attribute getDependent(int index) {
            return this.dependents.get(index);
        }

        void addDependent(Attribute attribute) {
            this.dependents.add(attribute);
        }

        boolean hasDependent(Attribute dependent) {
            return this.dependents.contains(dependent);
        }

        int size() {
            return this.dependents.size();
        }
    }
}

