/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.layout;

import java.awt.ComponentOrientation;
import java.util.List;
import oracle.bpm.geom.Dimension;
import oracle.bpm.lang.exception.ProgramException;
import oracle.bpm.ui.Margin;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.layout.Layout;

public final class BoxLayout
implements Layout {
    private int axis;
    private int componentCount = 0;
    private SizeRequirements[] xChildren;
    private SizeRequirements xTotal;
    private SizeRequirements[] yChildren;
    private SizeRequirements yTotal;
    public static final int X_AXIS = 0;
    public static final int Y_AXIS = 1;
    private static final int LINE_AXIS = 2;
    public static final int PAGE_AXIS = 3;

    public BoxLayout(UiContainer target) {
        this(target, 1);
    }

    public BoxLayout(UiContainer target, int axis) {
        if (axis != 0 && axis != 1 && axis != 2 && axis != 3) {
            throw new IllegalArgumentException("Invalid axis");
        }
        this.axis = axis;
    }

    @Override
    public void validateAddedComponent(UiContainer container, UiComponent component, Object constraints) {
        if (!Ui.isSwing()) {
            List<UiComponent> children = container.getChildren();
            ProgramException.assertTrue((children.get(this.componentCount) == component ? 1 : 0) != 0, (String)("Invalid order for child: components must be added in the same order as they were created. \nInvalid component: " + component + "; parent is " + this + ". \nWas expecting: " + children.get(this.componentCount) + "\n"));
        }
        ++this.componentCount;
    }

    @Override
    public synchronized float getLayoutAlignmentX(UiContainer target) {
        BoxLayout.checkContainer();
        this.checkRequests(target);
        return this.xTotal.alignment;
    }

    @Override
    public synchronized float getLayoutAlignmentY(UiContainer target) {
        BoxLayout.checkContainer();
        this.checkRequests(target);
        return this.yTotal.alignment;
    }

    @Override
    public synchronized void invalidateLayout(UiContainer target) {
        BoxLayout.checkContainer();
        this.resetChildren();
        this.xTotal = null;
        this.yTotal = null;
    }

    @Override
    public void layoutContainer(UiContainer target) {
        BoxLayout.checkContainer();
        Dimension alloc = target.getSize();
        Margin in = target.getInsets();
        int width = alloc.getWidth() - (in.left + in.right);
        int height = alloc.getHeight() - (in.top + in.bottom);
        int childCount = target.getComponentCount();
        int[] yOffsets = new int[childCount];
        int[] ySpans = new int[childCount];
        int[] xSpans = new int[childCount];
        int[] xOffsets = new int[childCount];
        this.layout(target, width, height, xOffsets, yOffsets, xSpans, ySpans);
        for (int i = 0; i < childCount; ++i) {
            UiComponent child = target.getComponent(i);
            int x = BoxLayout.add(in.left, xOffsets[i]);
            int y = BoxLayout.add(in.top, yOffsets[i]);
            child.setBounds(x, y, xSpans[i], ySpans[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension maximumLayoutSize(UiContainer target) {
        int height;
        int width;
        BoxLayout boxLayout = this;
        synchronized (boxLayout) {
            BoxLayout.checkContainer();
            this.checkRequests(target);
            width = this.xTotal.maximum;
            height = this.yTotal.maximum;
        }
        Margin insets = target.getInsets();
        return Dimension.valueOf((int)BoxLayout.add(width, insets.left + insets.right), (int)BoxLayout.add(height, insets.top + insets.bottom));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension minimumLayoutSize(UiContainer target) {
        int height;
        int width;
        BoxLayout boxLayout = this;
        synchronized (boxLayout) {
            BoxLayout.checkContainer();
            this.checkRequests(target);
            width = this.xTotal.minimum;
            height = this.yTotal.minimum;
        }
        Margin insets = target.getInsets();
        return Dimension.valueOf((int)BoxLayout.add(width, insets.left + insets.right), (int)BoxLayout.add(height, insets.top + insets.bottom));
    }

    @Override
    public Dimension preferredLayoutSize(UiContainer target) {
        BoxLayout.checkContainer();
        this.checkRequests(target);
        int width = this.xTotal.preferred;
        int height = this.yTotal.preferred;
        Margin insets = target.getInsets();
        return Dimension.valueOf((int)BoxLayout.add(width, insets.left + insets.right), (int)BoxLayout.add(height, insets.top + insets.bottom));
    }

    @Override
    public void removeLayoutComponent(UiComponent comp) {
        --this.componentCount;
    }

    private static void checkContainer() {
    }

    private static int resolveAxis(int axis, ComponentOrientation o) {
        return axis == 2 ? (o.isHorizontal() ? 0 : 1) : (axis == 3 ? (o.isHorizontal() ? 1 : 0) : axis);
    }

    private static int add(int a, int b) {
        return (int)Math.min((long)a + (long)b, Integer.MAX_VALUE);
    }

    private synchronized void layout(UiContainer target, int width, int height, int[] xOffsets, int[] yOffsets, int[] xSpans, int[] ySpans) {
        boolean ltr;
        ComponentOrientation orientation = target.getComponentOrientation();
        int absoluteAxis = BoxLayout.resolveAxis(this.axis, orientation);
        boolean bl = ltr = absoluteAxis == this.axis || orientation.isLeftToRight();
        if (absoluteAxis == 0) {
            if (this.xChildren != null && this.xChildren.length != xOffsets.length) {
                this.resetChildren();
            }
        } else if (this.yChildren != null && this.yChildren.length != yOffsets.length) {
            this.resetChildren();
        }
        this.checkRequests(target);
        if (absoluteAxis == 0) {
            SizeRequirements.calculateTiledPositions(width, this.xChildren, xOffsets, xSpans, ltr);
            SizeRequirements.calculateAlignedPositions(height, this.yTotal, this.yChildren, yOffsets, ySpans);
        } else {
            SizeRequirements.calculateAlignedPositions(width, this.xTotal, this.xChildren, xOffsets, xSpans, ltr);
            SizeRequirements.calculateTiledPositions(height, this.yChildren, yOffsets, ySpans);
        }
    }

    private void checkRequests(UiContainer target) {
        if (this.xChildren == null || this.yChildren == null) {
            int n = target.getComponentCount();
            this.xChildren = new SizeRequirements[n];
            this.yChildren = new SizeRequirements[n];
            for (int i = 0; i < n; ++i) {
                this.setSizeRequirement(target.getComponent(i), i);
            }
            if (BoxLayout.resolveAxis(this.axis, target.getComponentOrientation()) == 0) {
                this.xTotal = SizeRequirements.getTiledSizeRequirements(this.xChildren);
                this.yTotal = SizeRequirements.getAlignedSizeRequirements(this.yChildren);
            } else {
                this.xTotal = SizeRequirements.getAlignedSizeRequirements(this.xChildren);
                this.yTotal = SizeRequirements.getTiledSizeRequirements(this.yChildren);
            }
        }
    }

    private void setSizeRequirement(UiComponent c, int i) {
        int xmin = 0;
        int xpref = 0;
        int xmax = 0;
        int ymin = 0;
        int ymax = 0;
        int ypref = 0;
        if (c.isVisible()) {
            Dimension min = c.getMinimumSize();
            xmin = min.getWidth();
            ymin = min.getHeight();
            Dimension max = c.getMaximumSize();
            xmax = max.getWidth();
            ymax = max.getHeight();
            Dimension pref = c.getPreferredSize();
            xpref = pref.getWidth();
            ypref = pref.getHeight();
        }
        this.xChildren[i] = new SizeRequirements(xmin, xpref, xmax, 0.0f);
        this.yChildren[i] = new SizeRequirements(ymin, ypref, ymax, 0.0f);
    }

    private void resetChildren() {
        this.xChildren = null;
        this.yChildren = null;
    }

    private static final class SizeRequirements {
        public final float alignment;
        public int maximum;
        public int minimum;
        public int preferred;

        public SizeRequirements() {
            this(0, 0, 0, 0.5f);
        }

        public SizeRequirements(int min, int pref, int max, float align) {
            this.minimum = min;
            this.preferred = pref;
            this.maximum = max;
            this.alignment = SizeRequirements.verifyBounds(align);
        }

        public static SizeRequirements getAlignedSizeRequirements(SizeRequirements[] children) {
            SizeRequirements ascent = new SizeRequirements();
            SizeRequirements descent = new SizeRequirements();
            for (SizeRequirements req : children) {
                SizeRequirements.processRequirement(req, ascent, descent);
            }
            int min = BoxLayout.add(ascent.minimum, descent.minimum);
            float alignment = min <= 0 ? 0.0f : SizeRequirements.verifyBounds((float)ascent.minimum / (float)min);
            return new SizeRequirements(min, BoxLayout.add(ascent.preferred, descent.preferred), BoxLayout.add(ascent.maximum, descent.maximum), alignment);
        }

        public static SizeRequirements getTiledSizeRequirements(SizeRequirements[] children) {
            SizeRequirements total = new SizeRequirements();
            for (SizeRequirements req : children) {
                total.minimum = BoxLayout.add(total.minimum, req.minimum);
                total.preferred = BoxLayout.add(total.preferred, req.preferred);
                total.maximum = BoxLayout.add(total.maximum, req.maximum);
            }
            return total;
        }

        public static void calculateAlignedPositions(int allocated, SizeRequirements total, SizeRequirements[] children, int[] offsets, int[] spans) {
            SizeRequirements.calculateAlignedPositions(allocated, total, children, offsets, spans, true);
        }

        public static void calculateTiledPositions(int allocated, SizeRequirements[] children, int[] offsets, int[] spans) {
            SizeRequirements.calculateTiledPositions(allocated, children, offsets, spans, true);
        }

        public static void calculateTiledPositions(int allocated, SizeRequirements[] children, int[] offsets, int[] spans, boolean forward) {
            long minimum = 0L;
            long maximum = 0L;
            long preferred = 0L;
            for (SizeRequirements req : children) {
                minimum += (long)req.minimum;
                maximum += (long)req.maximum;
                preferred += (long)req.preferred;
            }
            if ((long)allocated >= preferred) {
                SizeRequirements.tileExpanding(children, offsets, spans, allocated, preferred, maximum, forward);
            } else {
                SizeRequirements.tileCompressing(children, offsets, spans, allocated, minimum, preferred, forward);
            }
        }

        public String toString() {
            return "[" + this.minimum + "," + this.preferred + "," + this.maximum + "]@" + this.alignment;
        }

        private static float verifyBounds(float align) {
            return align > 1.0f ? 1.0f : (align < 0.0f ? 0.0f : align);
        }

        private static void calculateAlignedPositions(int allocated, SizeRequirements total, SizeRequirements[] children, int[] offsets, int[] spans, boolean normal) {
            int totalAscent = (int)((float)allocated * SizeRequirements.alignment(total, normal));
            int totalDescent = allocated - totalAscent;
            assert (children.length == offsets.length) : "Wrong children or offsets length: " + children.length + " <> " + offsets.length;
            if (children.length == offsets.length) {
                int i = 0;
                for (SizeRequirements req : children) {
                    int maxAscent = (int)((float)req.maximum * SizeRequirements.alignment(req, normal));
                    int ascent = Math.min(totalAscent, maxAscent);
                    offsets[i] = totalAscent - ascent;
                    spans[i] = BoxLayout.add(ascent, Math.min(totalDescent, req.maximum - maxAscent));
                    ++i;
                }
            }
        }

        private static float alignment(SizeRequirements req, boolean normal) {
            return normal ? req.alignment : 1.0f - req.alignment;
        }

        private static void processRequirement(SizeRequirements req, SizeRequirements ascent, SizeRequirements descent) {
            int a = (int)(req.alignment * (float)req.minimum);
            ascent.minimum = Math.max(a, ascent.minimum);
            descent.minimum = Math.max(req.minimum - a, descent.minimum);
            a = (int)(req.alignment * (float)req.preferred);
            ascent.preferred = Math.max(a, ascent.preferred);
            descent.preferred = Math.max(req.preferred - a, descent.preferred);
            a = (int)(req.alignment * (float)req.maximum);
            ascent.maximum = Math.max(a, ascent.maximum);
            descent.maximum = Math.max(req.maximum - a, descent.maximum);
        }

        private static void tileCompressing(SizeRequirements[] request, int[] offsets, int[] spans, int allocated, long min, long pref, boolean forwards) {
            float factor;
            long p = pref - min;
            float totalPlay = Math.min(pref - (long)allocated, p);
            float f = factor = p == 0L ? 0.0f : totalPlay / (float)p;
            if (forwards) {
                SizeRequirements.compressForwards(request, spans, offsets, factor);
            } else {
                SizeRequirements.compressBackwards(request, spans, offsets, factor, allocated);
            }
        }

        private static void compressBackwards(SizeRequirements[] request, int[] spans, int[] offsets, float factor, int allocated) {
            int offset = allocated;
            for (int i = 0; i < spans.length; ++i) {
                SizeRequirements req = request[i];
                int span = (int)((float)req.preferred - factor * (float)(req.preferred - req.minimum));
                offsets[i] = offset - span;
                spans[i] = span;
                offset = SizeRequirements.sub(offset, span);
            }
        }

        private static int sub(int v1, int v2) {
            return (int)Math.max((long)v1 - (long)v2, 0L);
        }

        private static void compressForwards(SizeRequirements[] request, int[] spans, int[] offsets, float factor) {
            int offset = 0;
            for (int i = 0; i < spans.length; ++i) {
                SizeRequirements req = request[i];
                int span = (int)((float)req.preferred - factor * (float)(req.preferred - req.minimum));
                offsets[i] = offset;
                spans[i] = span;
                offset = BoxLayout.add(offset, span);
            }
        }

        private static void tileExpanding(SizeRequirements[] request, int[] offsets, int[] spans, int allocated, long pref, long max, boolean forward) {
            float factor;
            long p = max - pref;
            float totalPlay = Math.min((long)allocated - pref, p);
            float f = factor = p == 0L ? 0.0f : totalPlay / (float)p;
            if (forward) {
                SizeRequirements.expandsFordwards(request, spans, offsets, factor);
            } else {
                SizeRequirements.expandBackwards(request, spans, offsets, factor, allocated);
            }
        }

        private static void expandBackwards(SizeRequirements[] request, int[] spans, int[] offsets, float factor, int allocated) {
            int totalOffset = allocated;
            for (int i = 0; i < spans.length; ++i) {
                int span;
                SizeRequirements req = request[i];
                spans[i] = span = BoxLayout.add(req.preferred, (int)(factor * (float)(req.maximum - req.preferred)));
                offsets[i] = totalOffset - span;
                totalOffset = SizeRequirements.sub(totalOffset, span);
            }
        }

        private static void expandsFordwards(SizeRequirements[] request, int[] spans, int[] offsets, float factor) {
            int totalOffset = 0;
            for (int i = 0; i < spans.length; ++i) {
                int span;
                SizeRequirements req = request[i];
                spans[i] = span = BoxLayout.add(req.preferred, (int)(factor * (float)(req.maximum - req.preferred)));
                offsets[i] = totalOffset;
                totalOffset = BoxLayout.add(totalOffset, span);
            }
        }
    }
}

