/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.layout;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import oracle.bpm.ui.layout.AttributeAxis;
import oracle.bpm.ui.layout.ComponentSpecifications;

public abstract class AttributeType {
    private final AttributeAxis axis;
    private final String name;
    public static final String VERSION = "$Id: AttributeType.java /main/2 2010/04/16 12:28:44 ferorodr Exp $";
    private static Set<AttributeType> allTypes = new HashSet<AttributeType>();
    private static Map<String, AttributeType> typeMap = new HashMap<String, AttributeType>();
    private static Map<AttributeAxis, Set<AttributeType>> axisTypes = new HashMap<AttributeAxis, Set<AttributeType>>();
    public static final AttributeType LEFT = new AttributeType("left", AttributeAxis.HORIZONTAL){

        @Override
        public int deriveValue(ComponentSpecifications specs, boolean minimumSize) {
            if (specs.hasConstraint(RIGHT)) {
                if (specs.hasConstraint(WIDTH)) {
                    return specs.getAttributeValue(RIGHT) - specs.getAttributeValue(WIDTH);
                }
                if (specs.hasConstraint(HORIZONTAL_CENTER)) {
                    return 2 * specs.getAttributeValue(HORIZONTAL_CENTER) - specs.getAttributeValue(RIGHT);
                }
                return specs.getAttributeValue(RIGHT) - specs.getComponentWidth(minimumSize);
            }
            if (specs.hasConstraint(HORIZONTAL_CENTER)) {
                if (specs.hasConstraint(WIDTH)) {
                    return specs.getAttributeValue(HORIZONTAL_CENTER) - specs.getAttributeValue(WIDTH) / 2;
                }
                return specs.getAttributeValue(HORIZONTAL_CENTER) - specs.getComponentWidth(minimumSize) / 2;
            }
            throw new IllegalStateException(specs.getComponentName() + ": Underconstrained attribute, " + this);
        }
    };
    public static final AttributeType RIGHT = new AttributeType("right", AttributeAxis.HORIZONTAL){

        @Override
        public int deriveValue(ComponentSpecifications specs, boolean minimumSize) {
            if (specs.hasConstraint(LEFT)) {
                if (specs.hasConstraint(WIDTH)) {
                    return specs.getAttributeValue(LEFT) + specs.getAttributeValue(WIDTH);
                }
                if (specs.hasConstraint(HORIZONTAL_CENTER)) {
                    return 2 * specs.getAttributeValue(HORIZONTAL_CENTER) - specs.getAttributeValue(LEFT);
                }
                return specs.getAttributeValue(LEFT) + specs.getComponentWidth(minimumSize);
            }
            if (specs.hasConstraint(HORIZONTAL_CENTER)) {
                if (specs.hasConstraint(WIDTH)) {
                    return specs.getAttributeValue(HORIZONTAL_CENTER) + specs.getAttributeValue(WIDTH) / 2;
                }
                return specs.getAttributeValue(HORIZONTAL_CENTER) + specs.getComponentWidth(minimumSize) / 2;
            }
            throw new IllegalStateException(specs.getComponentName() + ": Underconstrained attribute, " + this);
        }
    };
    public static final AttributeType HORIZONTAL_CENTER = new AttributeType("horizontalCenter", AttributeAxis.HORIZONTAL){

        @Override
        public int deriveValue(ComponentSpecifications specs, boolean minimumSize) {
            if (specs.hasConstraint(LEFT)) {
                if (specs.hasConstraint(WIDTH)) {
                    return specs.getAttributeValue(LEFT) + specs.getAttributeValue(WIDTH) / 2;
                }
                if (specs.hasConstraint(RIGHT)) {
                    return (specs.getAttributeValue(LEFT) + specs.getAttributeValue(RIGHT)) / 2;
                }
                return specs.getAttributeValue(LEFT) + specs.getComponentWidth(minimumSize) / 2;
            }
            if (specs.hasConstraint(RIGHT)) {
                if (specs.hasConstraint(WIDTH)) {
                    return specs.getAttributeValue(RIGHT) - specs.getAttributeValue(WIDTH) / 2;
                }
                return specs.getAttributeValue(RIGHT) - specs.getComponentWidth(minimumSize) / 2;
            }
            throw new IllegalStateException(specs.getComponentName() + ": Underconstrained attribute, " + this);
        }
    };
    public static final AttributeType WIDTH = new AttributeType("width", AttributeAxis.HORIZONTAL){

        @Override
        public int deriveValue(ComponentSpecifications specs, boolean minimumSize) {
            if (specs.hasConstraint(LEFT)) {
                if (specs.hasConstraint(RIGHT)) {
                    return specs.getAttributeValue(RIGHT) - specs.getAttributeValue(LEFT);
                }
                if (specs.hasConstraint(HORIZONTAL_CENTER)) {
                    return 2 * (specs.getAttributeValue(HORIZONTAL_CENTER) - specs.getAttributeValue(LEFT));
                }
            }
            if (specs.hasConstraint(RIGHT) && specs.hasConstraint(HORIZONTAL_CENTER)) {
                return 2 * (specs.getAttributeValue(RIGHT) - specs.getAttributeValue(HORIZONTAL_CENTER));
            }
            return specs.getComponentWidth(minimumSize);
        }
    };
    public static final AttributeType TOP = new AttributeType("top", AttributeAxis.VERTICAL){

        @Override
        public int deriveValue(ComponentSpecifications specs, boolean minimumSize) {
            if (specs.hasConstraint(BOTTOM)) {
                if (specs.hasConstraint(HEIGHT)) {
                    return specs.getAttributeValue(BOTTOM) - specs.getAttributeValue(HEIGHT);
                }
                if (specs.hasConstraint(VERTICAL_CENTER)) {
                    return 2 * specs.getAttributeValue(VERTICAL_CENTER) - specs.getAttributeValue(BOTTOM);
                }
                return specs.getAttributeValue(BOTTOM) - specs.getComponentHeight(minimumSize);
            }
            if (specs.hasConstraint(VERTICAL_CENTER)) {
                if (specs.hasConstraint(HEIGHT)) {
                    return specs.getAttributeValue(VERTICAL_CENTER) - specs.getAttributeValue(HEIGHT) / 2;
                }
                return specs.getAttributeValue(VERTICAL_CENTER) - specs.getComponentHeight(minimumSize) / 2;
            }
            throw new IllegalStateException(specs.getComponentName() + ": Underconstrained attribute, " + this);
        }
    };
    public static final AttributeType BOTTOM = new AttributeType("bottom", AttributeAxis.VERTICAL){

        @Override
        public int deriveValue(ComponentSpecifications specs, boolean minimumSize) {
            if (specs.hasConstraint(TOP)) {
                if (specs.hasConstraint(HEIGHT)) {
                    return specs.getAttributeValue(TOP) + specs.getAttributeValue(HEIGHT);
                }
                if (specs.hasConstraint(VERTICAL_CENTER)) {
                    return 2 * specs.getAttributeValue(VERTICAL_CENTER) - specs.getAttributeValue(TOP);
                }
                return specs.getAttributeValue(TOP) + specs.getComponentHeight(minimumSize);
            }
            if (specs.hasConstraint(VERTICAL_CENTER)) {
                if (specs.hasConstraint(HEIGHT)) {
                    return specs.getAttributeValue(VERTICAL_CENTER) + specs.getAttributeValue(HEIGHT) / 2;
                }
                return specs.getAttributeValue(VERTICAL_CENTER) + specs.getComponentHeight(minimumSize) / 2;
            }
            throw new IllegalStateException(specs.getComponentName() + ": Underconstrained attribute, " + this);
        }
    };
    public static final AttributeType VERTICAL_CENTER = new AttributeType("verticalCenter", AttributeAxis.VERTICAL){

        @Override
        public int deriveValue(ComponentSpecifications specs, boolean minimumSize) {
            if (specs.hasConstraint(TOP)) {
                if (specs.hasConstraint(HEIGHT)) {
                    return specs.getAttributeValue(TOP) + specs.getAttributeValue(HEIGHT) / 2;
                }
                if (specs.hasConstraint(BOTTOM)) {
                    return (specs.getAttributeValue(TOP) + specs.getAttributeValue(BOTTOM)) / 2;
                }
                return specs.getAttributeValue(TOP) + specs.getComponentHeight(minimumSize) / 2;
            }
            if (specs.hasConstraint(BOTTOM)) {
                if (specs.hasConstraint(HEIGHT)) {
                    return specs.getAttributeValue(BOTTOM) - specs.getAttributeValue(HEIGHT) / 2;
                }
                return specs.getAttributeValue(BOTTOM) - specs.getComponentHeight(minimumSize) / 2;
            }
            throw new IllegalStateException(specs.getComponentName() + ": Underconstrained attribute, " + this);
        }
    };
    public static final AttributeType HEIGHT = new AttributeType("height", AttributeAxis.VERTICAL){

        @Override
        public int deriveValue(ComponentSpecifications specs, boolean minimumSize) {
            if (specs.hasConstraint(TOP)) {
                if (specs.hasConstraint(BOTTOM)) {
                    return specs.getAttributeValue(BOTTOM) - specs.getAttributeValue(TOP);
                }
                if (specs.hasConstraint(VERTICAL_CENTER)) {
                    return 2 * (specs.getAttributeValue(VERTICAL_CENTER) - specs.getAttributeValue(TOP));
                }
            }
            if (specs.hasConstraint(BOTTOM) && specs.hasConstraint(VERTICAL_CENTER)) {
                return 2 * (specs.getAttributeValue(BOTTOM) - specs.getAttributeValue(VERTICAL_CENTER));
            }
            return specs.getComponentHeight(minimumSize);
        }
    };

    protected AttributeType(String name, AttributeAxis axis) {
        if (name == null) {
            throw new NullPointerException("name must not be null");
        }
        if (axis == null) {
            throw new NullPointerException("axis must not be null");
        }
        this.name = name;
        this.axis = axis;
        allTypes.add(this);
        typeMap.put(name, this);
        Set<AttributeType> axisSet = axisTypes.get(axis);
        if (axisSet == null) {
            axisSet = new HashSet<AttributeType>();
            axisTypes.put(axis, axisSet);
        }
        axisSet.add(this);
    }

    public abstract int deriveValue(ComponentSpecifications var1, boolean var2);

    public static AttributeType getInstance(String name) {
        AttributeType result = typeMap.get(name);
        if (result == null) {
            throw new NoSuchElementException(name);
        }
        return result;
    }

    public static Set<AttributeType> getAllTypes() {
        return Collections.unmodifiableSet(allTypes);
    }

    public static Set getAxisTypes(AttributeAxis axis) {
        Set<AttributeType> axisSet = axisTypes.get(axis);
        if (axisSet == null) {
            return Collections.EMPTY_SET;
        }
        return Collections.unmodifiableSet(axisSet);
    }

    public AttributeAxis getAxis() {
        return this.axis;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return "AttributeType: " + this.name + " (" + this.axis + ')';
    }
}

