/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.filechooser;

import java.io.File;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiPeer;
import oracle.bpm.ui.peer.AbstractChooserPeer;
import oracle.bpm.ui.peer.PeerFactory;

abstract class AbstractChooser
extends UiPeer {
    private boolean directoryWasSet;
    private File lastDirectory;
    private String name;
    private static final String CURRENT_DIRECTORY = "CURRENT_DIRECTORY";
    public static final int APPROVE_OPTION = 0;
    public static final int CANCEL_OPTION = 1;

    AbstractChooser() {
    }

    public final void setCurrentDirectory(File directory) {
        this.getChooserPeer().setCurrentDirectory(directory);
        this.directoryWasSet = true;
    }

    public final File getCurrentDirectory() {
        return this.getChooserPeer().getCurrentDirectory();
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    protected PeerFactory getUiFactory() {
        return Ui.getUiFactory();
    }

    protected void afterShowing(UiComponent parent, int result, String key) {
        File currentDirectory = this.getCurrentDirectory();
        if (currentDirectory != null) {
            parent.setProperty(this.getKey(key), currentDirectory.getAbsolutePath());
            this.lastDirectory = currentDirectory;
        }
    }

    protected void beforeShowing(UiComponent parent, String key) {
        if (!this.directoryWasSet) {
            File dir;
            String currentDirectory = parent.getStringProperty(this.getKey(key));
            if (currentDirectory == null && this.lastDirectory != null) {
                currentDirectory = this.lastDirectory.getAbsolutePath();
            }
            if (currentDirectory == null) {
                currentDirectory = System.getProperty("user.dir");
            }
            if (currentDirectory != null && (dir = new File(currentDirectory)).exists() && dir.isDirectory()) {
                this.setCurrentDirectory(dir);
            }
        }
    }

    private String getKey(String key) {
        String result = this.getName() == null ? "" : this.getName() + ".";
        result = result + key + "." + CURRENT_DIRECTORY;
        return result;
    }

    private AbstractChooserPeer getChooserPeer() {
        return (AbstractChooserPeer)this.getPeer();
    }
}

