/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.browser;

import oracle.bpm.ui.Button;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.filechooser.FileChooser;
import oracle.bpm.ui.layout.AttributeType;
import oracle.bpm.ui.layout.RelativeLayout;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.text.TextField;
import oracle.bpm.ui.utils.Layout;

public class BrowserLauncherPanel
extends Panel {
    Button browseButton = new Button((UiContainer)this, UIMsg.BROWSE);
    TextField browserTextField;

    public BrowserLauncherPanel(UiContainer parent) {
        super(parent);
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileChooser fileChooser = new FileChooser();
                int returnValue = fileChooser.showOpenDialog(BrowserLauncherPanel.this);
                if (returnValue == 0) {
                    BrowserLauncherPanel.this.browserTextField.setText(fileChooser.getSelectedFile().getAbsolutePath());
                }
            }
        });
        this.browserTextField = new TextField(this);
        RelativeLayout layout = new RelativeLayout();
        this.setLayout(layout);
        this.add(this.browserTextField, "browserTextField");
        this.add(this.browseButton, "browserButton");
        Layout.fixToRoot(layout, "browserTextField", AttributeType.LEFT, 0);
        Layout.fixToRoot(layout, "browserTextField", AttributeType.TOP, 0);
        Layout.fixToRoot(layout, "browserButton", AttributeType.RIGHT, 0);
        Layout.fixToRoot(layout, "browserButton", AttributeType.TOP, 0);
        Layout.fixToComp(layout, "browserTextField", AttributeType.RIGHT, "browserButton", AttributeType.LEFT, -10);
        Layout.fixToComp(layout, "browserButton", AttributeType.VERTICAL_CENTER, "browserTextField");
        this.validate();
    }

    public void setCommand(String cmd) {
        if (cmd == null) {
            cmd = "";
        }
        this.browserTextField.setText(cmd);
    }

    public String getCommand() {
        return this.browserTextField.getText();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.browseButton.setEnabled(enabled);
        this.browserTextField.setEnabled(enabled);
    }
}

