/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui.action;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.event.SwingPropertyChangeSupport;
import oracle.bpm.execution.listener.VetoExecutionException;
import oracle.bpm.lang.exception.ReadOnlyException;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.ActionOrder;
import oracle.bpm.ui.ActionStyle;
import oracle.bpm.ui.CompositeMenu;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.KeyStroke;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.selection.DefaultSelection;
import oracle.bpm.ui.selection.Selection;

public abstract class BaseAction
implements ActionListener,
Action,
Cloneable {
    private Map<String, Object> arrayTable;
    private SwingPropertyChangeSupport changeSupport;
    private boolean enabled = true;
    private boolean iconNullSeted = false;
    private Msg msg;
    private ActionOrder order = ActionOrder.ANY;
    private List<Class> requiredClass;
    private boolean selected;
    private Selection selection = DefaultSelection.EMPTY;
    private boolean showOnDisabled = true;
    private ActionStyle style;
    public static final String MSG_PROPERTY_KEY = "oracle.bpm.ui.msg.key";
    public static final String MSG = "oracle.bpm.action.msg";
    public static final String DISABLED_ICON = "oracle.bpm.icon.disabled";
    public static final String DROP_MENU = "oracle.bpm.drop.menu";
    public static final String TOGGLE = "oracle.bpm.button.toggle";
    public static final BaseAction SEPARATOR = new BaseAction("---"){};
    public static final String RADIO = "oracle.bpm.button.radio";

    public BaseAction() {
    }

    public BaseAction(String id) {
        this(UIMsg.TO_MSG(id), id);
    }

    public BaseAction(Msg msg) {
        this.setMsg(msg);
    }

    public BaseAction(Msg msg, Class requiredClass) {
        this.setMsg(msg);
        this.requires(requiredClass);
    }

    public BaseAction(Msg msg, String id) {
        this.putValue("Name", id);
        this.setMsg(msg);
    }

    public static BaseAction fromAwt(Action action) {
        Msg key = (Msg)action.getValue(MSG_PROPERTY_KEY);
        return key == null ? new FromAwt((String)action.getValue("Name"), action) : new FromAwt(key, action);
    }

    public static BaseAction valueOf(Action action, Msg msg) {
        assert (action != null);
        return new ActionFuegoAction(action, msg);
    }

    @Override
    public Object getValue(String key) {
        return this.arrayTable == null ? null : this.arrayTable.get(key);
    }

    @Override
    public void putValue(String key, Object newValue) {
        if (this.arrayTable == null) {
            this.arrayTable = new HashMap<String, Object>();
        }
        Object oldValue = null;
        if (this.arrayTable.containsKey(key)) {
            oldValue = this.arrayTable.get(key);
        }
        if (newValue == null) {
            this.arrayTable.remove(key);
        } else {
            this.arrayTable.put(key, newValue);
        }
        this.firePropertyChange(key, oldValue, newValue);
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean newValue) {
        boolean oldValue = this.enabled;
        if (oldValue != newValue) {
            this.enabled = newValue;
            this.firePropertyChange("enabled", oldValue, newValue);
        }
    }

    @Override
    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.changeSupport == null) {
            this.changeSupport = new SwingPropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.changeSupport == null) {
            return;
        }
        this.changeSupport.removePropertyChangeListener(listener);
    }

    public ActionOrder getOrder() {
        return this.order;
    }

    public void setOrder(ActionOrder order) {
        this.order = order;
    }

    @Override
    public final void actionPerformed(ActionEvent e) {
        oracle.bpm.ui.event.ActionEvent action = null;
        if (e != null) {
            Object source = e.getSource();
            action = new oracle.bpm.ui.event.ActionEvent(source);
        }
        this.actionPerformed(action);
    }

    @Override
    public void actionPerformed(oracle.bpm.ui.event.ActionEvent event) {
        try {
            this.run();
        }
        catch (VetoExecutionException e) {
            MessageDialog.showError(UIMsg.TO_MSG(e.getMessage()));
        }
        catch (ReadOnlyException e) {
            MessageDialog.showError(e.getMsg());
        }
    }

    public void addToMenu(CompositeMenu menu) {
        if (this.isEnabled() || this.isShowOnDisabled()) {
            this.fillMenu(menu);
        }
    }

    public KeyStroke getAccelatorKey() {
        return KeyStroke.valueOf((javax.swing.KeyStroke)this.getValue("AcceleratorKey"));
    }

    public Msg getMsg() {
        return this.msg;
    }

    public String getName() {
        return (String)this.getValue("Name");
    }

    public Selection getSelection() {
        return this.selection;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public final Image getSmallIcon() {
        Image img = null;
        Object smallIcon = this.getValue("SmallIcon");
        if (smallIcon != null) {
            img = smallIcon instanceof Icon ? Image.create((Icon)smallIcon) : (Image)smallIcon;
        } else if (!this.iconNullSeted && this.msg != null && this.msg.hasImage()) {
            img = Image.create(this.msg);
        }
        return img;
    }

    public boolean isShowOnDisabled() {
        return this.showOnDisabled;
    }

    public void run() {
    }

    public void runWithSelection(Object sel) {
        this.runWithSelection(DefaultSelection.createSingle(sel));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runWithSelection(Selection sel) {
        try {
            this.setSelection(sel);
            this.run();
        }
        finally {
            this.setSelection(DefaultSelection.EMPTY);
        }
    }

    public final void setAcceleratorKey(KeyStroke key) {
        this.putValue("AcceleratorKey", key.asSwing());
    }

    public void setMsg(Msg msg) {
        this.msg = msg;
        this.putValue(MSG, msg);
    }

    public final void setName(String name) {
        this.putValue("Name", name);
    }

    public void setSelection(Selection selection) {
        assert (selection != null) : "Selection cannot be null";
        if (this.requiredClass == null) {
            throw new IllegalStateException("There must be at least one required class for action: " + this.getClass().getName());
        }
        this.selection = selection;
        if (this.requiredClass.contains(Void.class)) {
            this.setEnabled(true);
        } else if (selection.isEmpty()) {
            this.setEnabled(this.requiredClass.contains(Void.class));
        } else {
            Class required;
            boolean accepted = false;
            Iterator<Class> i$ = this.requiredClass.iterator();
            while (i$.hasNext() && !(accepted = selection.as(required = i$.next()) != null)) {
            }
            this.setEnabled(accepted);
        }
        if (this.isEnabled()) {
            try {
                this.updateEnableStatus(selection);
            }
            catch (Exception unexpected) {
                unexpected.printStackTrace();
                this.setEnabled(false);
            }
        }
    }

    public void setShowOnDisabled(boolean showOnDisabled) {
        this.showOnDisabled = showOnDisabled;
    }

    public final void setSmallIcon(Image icon) {
        this.putValue("SmallIcon", icon != null ? icon.asSwingIcon() : null);
        if (icon == null) {
            this.iconNullSeted = true;
        }
    }

    public void setStyle(ActionStyle style) {
        this.style = style;
    }

    public ActionStyle getStyle() {
        return this.style;
    }

    public boolean showsDialog() {
        return false;
    }

    public List<Class> getRequiredClasses() {
        return Collections.unmodifiableList(this.requiredClass);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (this.changeSupport == null || oldValue != null && newValue != null && oldValue.equals(newValue)) {
            return;
        }
        this.changeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BaseAction clone() throws CloneNotSupportedException {
        BaseAction newAction = (BaseAction)super.clone();
        BaseAction baseAction = this;
        synchronized (baseAction) {
            if (this.arrayTable != null) {
                newAction.arrayTable = new HashMap<String, Object>(this.arrayTable);
            }
        }
        return newAction;
    }

    protected void fillMenu(CompositeMenu menu) {
        if (this.isEnabled() || this.isShowOnDisabled()) {
            menu.add(this);
        }
    }

    protected void requires(Class cl) {
        if (this.requiredClass == null) {
            this.requiredClass = new ArrayList<Class>();
        }
        this.requiredClass.add(cl);
        this.setSelection(this.getSelection());
    }

    protected boolean isRequired(Class clazz) {
        return this.getRequiredClasses().contains(clazz);
    }

    protected void updateEnableStatus(Selection s) {
    }

    private static class FromAwt
    extends BaseAction {
        private final Action action;

        public FromAwt(Msg key, Action action) {
            super(key);
            this.action = action;
        }

        public FromAwt(String id, Action action) {
            super(id);
            this.action = action;
        }

        @Override
        public void actionPerformed(oracle.bpm.ui.event.ActionEvent e) {
            this.action.actionPerformed(e.asSwing());
        }
    }

    private static class ActionFuegoAction
    extends BaseAction {
        Action action;

        public ActionFuegoAction(Action action, Msg msg) {
            this.action = action;
            this.setMsg(msg);
        }

        @Override
        public void actionPerformed(oracle.bpm.ui.event.ActionEvent e) {
            this.action.actionPerformed(e.asSwing());
        }

        @Override
        public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
            this.action.addPropertyChangeListener(listener);
        }

        @Override
        public Object getValue(String key) {
            return this.action.getValue(key);
        }

        @Override
        public void putValue(String key, Object newValue) {
            this.action.putValue(key, newValue);
        }

        @Override
        public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
            this.action.removePropertyChangeListener(listener);
        }

        @Override
        public void setEnabled(boolean newValue) {
            this.action.setEnabled(newValue);
            super.setEnabled(newValue);
        }

        @Override
        public boolean isEnabled() {
            return this.action.isEnabled();
        }
    }
}

