/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui;

import java.awt.GraphicsEnvironment;
import java.util.List;
import oracle.bpm.extension.Extension;
import oracle.bpm.extension.ExtensionService;
import oracle.bpm.extensionpoint.metadata.UiFactoryMetadata;
import oracle.bpm.lang.Platform;
import oracle.bpm.ui.UiType;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.help.DefaultHelpService;
import oracle.bpm.ui.help.HelpService;
import oracle.bpm.ui.peer.PeerFactory;
import oracle.bpm.ui.peer.ToolkitPeer;
import oracle.bpm.ui.peer.swing.SwingFactory;

public final class Ui {
    private static boolean SUPPORTS_SVG = false;
    private static boolean SUPPORTS_SVG_RESIZE = false;
    private static PeerFactory peerFactory;
    private static ToolkitPeer toolkit;
    private static UiType type;
    private static HelpService helpService;

    private Ui() {
    }

    public static String[] getAvailableFontFamilyNames() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
    }

    public static boolean isHeadless() {
        return GraphicsEnvironment.isHeadless();
    }

    public static UiWindow getRoot() {
        return Ui.getUiFactory().getRoot();
    }

    public static void setRoot(UiWindow root) {
        Ui.getUiFactory().setRoot(root);
    }

    public static boolean isSwing() {
        return Ui.getType() == UiType.SWING;
    }

    public static boolean isFusion() {
        return Ui.isSwing() && !"true".equals(System.getProperty("nofusion"));
    }

    public static boolean isDebug() {
        return System.getProperty("fuego.studio.debug") != null;
    }

    public static boolean isHelpDebug() {
        return Ui.isDebug();
    }

    public static boolean isSwt() {
        return Ui.getType() == UiType.SWT;
    }

    public static ToolkitPeer getToolkit() {
        if (toolkit == null) {
            toolkit = Ui.getUiFactory().createToolkit();
        }
        return toolkit;
    }

    public static UiType getType() {
        return type;
    }

    public static PeerFactory getUiFactory() {
        if (peerFactory == null) {
            UiType uiType = Ui.getType();
            if (Ui.isSwing(uiType)) {
                peerFactory = new SwingFactory();
            } else {
                try {
                    peerFactory = (PeerFactory)Class.forName("oracle.bpm.ui.peer.swt.SwtFactory").newInstance();
                }
                catch (Exception e) {
                    throw new IllegalStateException("Can not initialize " + uiType.name() + " peer");
                }
            }
        }
        return peerFactory;
    }

    public static void initialize(UiType uiType) {
        if (peerFactory != null && uiType.equals((Object)type)) {
            return;
        }
        assert (peerFactory == null) : "Factory already set to " + peerFactory;
        Ui.setType(uiType);
        Ui.getUiFactory().createUi().init();
    }

    public static void reInitialize(UiType uiType) {
        peerFactory = null;
        Ui.initialize(uiType);
    }

    public static void setHelpService(HelpService helpService) {
        Ui.helpService = helpService;
    }

    public static HelpService getHelpService() {
        if (helpService == null) {
            helpService = new DefaultHelpService();
        }
        return helpService;
    }

    public static boolean supportsSVG() {
        return SUPPORTS_SVG;
    }

    public static boolean supportsSVGResize() {
        return SUPPORTS_SVG_RESIZE;
    }

    public static void enableSVG() {
        SUPPORTS_SVG = true;
    }

    private static PeerFactory createUiFactory(String type) {
        PeerFactory result = null;
        ExtensionService service = Platform.getExtensionService();
        List extensions = service.getExtensionsByPoint(UiFactoryMetadata.class);
        for (Extension extension : extensions) {
            String factoryType = ((UiFactoryMetadata)extension.getMetadata()).type();
            if (!factoryType.equals(type)) continue;
            try {
                result = (PeerFactory)extension.instantiateAs(PeerFactory.class);
                break;
            }
            catch (InstantiationException e) {
                IllegalStateException ie = new IllegalStateException("Could not create UiFactory with type " + type + " because:\n" + e);
                ie.initCause(e);
                throw ie;
            }
        }
        return result;
    }

    private static boolean isSwing(UiType uiType) {
        return uiType.equals((Object)UiType.SWING);
    }

    private static void setType(UiType type) {
        Ui.type = type;
    }

    static {
        type = UiType.SWING;
    }
}

