/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JPopupMenu;
import oracle.bpm.draw.Color;
import oracle.bpm.draw.Graphics;
import oracle.bpm.geom.Dimension;
import oracle.bpm.geom.Point;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.PaintCanvas;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.event.MouseAdapter;
import oracle.bpm.ui.event.MouseEvent;
import oracle.bpm.ui.event.MouseMotionListener;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.msg.UIMsg;

public class TablePopup
extends Panel {
    private Label label;
    private List<ActionListener> listeners;
    private TableGrid tableGrid;
    public static final String DONE_ACTION = "DONE";

    public TablePopup(UiContainer parent) {
        this(parent, true);
    }

    public TablePopup(UiContainer parent, boolean includeRows) {
        super(parent);
        this.tableGrid = new TableGrid(this, includeRows);
        this.label = Label.create((UiContainer)this, UIMsg.CANCEL);
        this.setLayout(new BorderLayout());
        this.add(this.tableGrid, "Center");
        this.add(this.label, "South");
        this.tableGrid.addGridListener(new GridListener(){

            @Override
            public void done(int hCellCount, int vCellCount) {
                TablePopup.this.doDone();
            }

            @Override
            public void update(int hCellCount, int vCellCount) {
                TablePopup.this.updateLabel();
            }
        });
        this.listeners = new ArrayList<ActionListener>();
    }

    public int getColumnCount() {
        return this.tableGrid.getSelectedHorizontalCellCount();
    }

    public int getRowCount() {
        return this.tableGrid.getSelectedVerticalCellCount();
    }

    public void addActionListener(ActionListener al) {
        this.listeners.add(al);
    }

    public void addGridListener(GridListener g) {
        this.tableGrid.addGridListener(g);
    }

    private void doDone() {
        for (ActionListener listener : this.listeners) {
            listener.actionPerformed(new ActionEvent(this, DONE_ACTION));
        }
    }

    private void updateLabel() {
        int x = this.tableGrid.getSelectedHorizontalCellCount();
        int y = this.tableGrid.getSelectedVerticalCellCount();
        if (this.tableGrid.includesRows() && x != 0 && y != 0) {
            this.label.setText(x + "x" + y + " Table");
        } else if (!this.tableGrid.includesRows() && x != 0) {
            this.label.setText(x + " Row");
        } else {
            this.label.setText("Cancel");
        }
        UiContainer c = this.getParent();
        do {
            if (!Ui.isSwing() || !(c.asSwing() instanceof JPopupMenu)) continue;
            ((JPopupMenu)c.asSwing()).pack();
            break;
        } while ((c = c.getParent()) != null);
    }

    private static class TableGrid
    extends PaintCanvas {
        List<GridListener> listeners;
        private int cellSize;
        private int horizontalCellCount;
        private boolean includeRows;
        private int selectedX = 0;
        private int selectedY = 0;
        private int spacing;
        private int verticalCellCount;

        public TableGrid(UiContainer parent, boolean includeRows) {
            this(parent, 5, 4, 25, 5, includeRows);
        }

        public TableGrid(UiContainer parent, int initialHorizontalCellCount, int initialVerticalCellCount, int cellSize, int spacing, boolean includeRows) {
            super(parent);
            this.horizontalCellCount = initialHorizontalCellCount;
            this.verticalCellCount = includeRows ? initialVerticalCellCount : 1;
            this.cellSize = cellSize;
            this.spacing = spacing;
            this.includeRows = includeRows;
            this.initListener();
        }

        @Override
        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getPreferredSize() {
            int width = this.cellSize * this.horizontalCellCount + (this.horizontalCellCount + 1) * this.spacing;
            int height = this.cellSize * this.verticalCellCount + (this.verticalCellCount + 1) * this.spacing;
            return Dimension.valueOf((int)width, (int)height);
        }

        public int getSelectedHorizontalCellCount() {
            return this.selectedX;
        }

        public int getSelectedVerticalCellCount() {
            return this.selectedY;
        }

        public void addGridListener(GridListener g) {
            this.listeners.add(g);
        }

        public void eventDone() {
            for (GridListener listener : this.listeners) {
                listener.done(this.selectedX, this.selectedY);
            }
        }

        public void eventUpdate() {
            this.repaint();
            for (GridListener listener : this.listeners) {
                listener.update(this.selectedX, this.selectedY);
            }
        }

        public boolean includesRows() {
            return this.includeRows;
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
        }

        @Override
        public void paintCanvas(Graphics g) {
            int currentY = this.spacing;
            for (int i = 0; i < this.verticalCellCount; ++i) {
                int currentX = this.spacing;
                for (int j = 0; j < this.horizontalCellCount; ++j) {
                    if (j < this.selectedX && i < this.selectedY) {
                        Color color = g.getForeground();
                        g.setForeground(Color.BLUE);
                        g.fillRect(currentX, currentY, this.cellSize, this.cellSize);
                        g.setForeground(color);
                    } else {
                        g.drawRect(currentX, currentY, this.cellSize, this.cellSize);
                    }
                    currentX += this.cellSize + this.spacing;
                }
                currentY += this.cellSize + this.spacing;
            }
        }

        private void initListener() {
            this.listeners = new ArrayList<GridListener>();
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseExited(MouseEvent e) {
                    TableGrid.this.selectedX = 0;
                    TableGrid.this.selectedY = 0;
                    TableGrid.this.eventUpdate();
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    TableGrid.this.markSelected(e.getPoint());
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    TableGrid.this.eventDone();
                }
            });
            this.addMouseMotionListener(new MouseMotionListener(){

                @Override
                public void mouseDragged(MouseEvent e) {
                    Point p = e.getPoint();
                    int maxX = (TableGrid.this.cellSize + TableGrid.this.spacing) * TableGrid.this.horizontalCellCount;
                    int maxY = (TableGrid.this.cellSize + TableGrid.this.spacing) * TableGrid.this.verticalCellCount;
                    if (p.getX() >= maxX) {
                        TableGrid.this.horizontalCellCount++;
                    }
                    if (TableGrid.this.includeRows && p.getY() >= maxY) {
                        TableGrid.this.verticalCellCount++;
                    }
                    TableGrid.this.markSelected(p);
                }

                @Override
                public void mouseMoved(MouseEvent e) {
                    if (e.isButton1Down()) {
                        this.mouseDragged(e);
                    } else {
                        Point p = e.getPoint();
                        TableGrid.this.markSelected(p);
                    }
                }
            });
        }

        private void markSelected(Point p) {
            int x = p.getX();
            int y = p.getY();
            this.selectedX = (x - this.spacing) / (this.cellSize + this.spacing) + 1;
            this.selectedY = (y - this.spacing) / (this.cellSize + this.spacing) + 1;
            this.eventUpdate();
        }
    }

    private static interface GridListener {
        public void done(int var1, int var2);

        public void update(int var1, int var2);
    }
}

