/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui;

import oracle.bpm.draw.Color;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Dialog;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiType;
import oracle.bpm.ui.UiUtilities;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.Utilities;
import oracle.bpm.ui.event.ChangeListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.peer.Peer;
import oracle.bpm.ui.peer.TabbedPanePeer;
import oracle.bpm.ui.text.TextArea;

public class TabbedPane
extends UiContainer {
    private int options = 255;
    private static final String TAB_MSG = "fuego.ui.tab.msg";

    public TabbedPane(UiContainer parent) {
        this(parent, 1);
    }

    public TabbedPane(UiContainer parent, int tabPlacement) {
        super(parent);
        this.setTabPlacement(tabPlacement);
        this.setBackgroundByInheritance();
    }

    public static void main(String[] args) {
        Ui.initialize(UiType.SWING);
        Dialog dialog = new Dialog((UiWindow)null);
        dialog.setSize(500, 400);
        dialog.centerOnScreen();
        final UiContainer contentPane = dialog.getContentPane();
        TabbedPane tabbedPane = new TabbedPane(contentPane, 1);
        Panel panel = new Panel(tabbedPane);
        panel.setBackground(Color.BLUE);
        tabbedPane.addTab("Testing.LongName.FirstLongName", (UiComponent)panel);
        TextArea textArea = new TextArea(tabbedPane);
        textArea.setText("Testing second ...");
        tabbedPane.addTab("Testing.LongName.SecondLongName", (UiComponent)textArea);
        tabbedPane.addTab("Testing.LongName.ThirdLongName", (UiComponent)new TextArea(tabbedPane));
        tabbedPane.addTab("Testing.LongName.FourthLongName", (UiComponent)new TextArea(tabbedPane));
        contentPane.add(tabbedPane, "Center");
        UiUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                contentPane.revalidate();
            }
        });
        Layout layout = tabbedPane.getLayout();
        System.out.println("TabbedPane.main() layout = " + layout);
        dialog.setVisible(true);
    }

    public String getDefaultHelpId() {
        return this.getOwnerWindow().getDefaultWindowHelpId() + "." + this.getTabHelpId();
    }

    public UiComponent getComponentAt(int index) {
        UiComponent result = null;
        if (index >= 0 && index < this.getComponentCount()) {
            result = this.getTabbedPanePeer().getComponentAt(index);
        }
        return result;
    }

    public void setEnabledAt(int index, boolean enabled) {
        this.getTabbedPanePeer().setEnabledAt(index, enabled);
    }

    public void setHideOneTab(boolean hideOnTab) {
        this.getTabbedPanePeer().setHideOnTab(hideOnTab);
    }

    public Msg getMsgAt(int i) {
        UiComponent component = this.getComponentAt(i);
        return TabbedPane.getMsg(component);
    }

    public UiComponent getSelectedComponent() {
        return this.getTabbedPanePeer().getSelectedComponent();
    }

    public void setSelectedIndex(int index) {
        this.getTabbedPanePeer().setSelectedIndex(index);
    }

    public int getSelectedIndex() {
        return this.getTabbedPanePeer().getSelectedIndex();
    }

    public int getTabCount() {
        return this.getTabbedPanePeer().getTabCount();
    }

    public void setTabPlacement(int placement) {
        this.getTabbedPanePeer().setTabPlacement(placement);
    }

    public void setTitleAt(int index, String title) {
        this.getTabbedPanePeer().setTitleAt(index, title);
    }

    public String getTitleAt(int index) {
        return this.getTabbedPanePeer().getTitleAt(index);
    }

    public void setToolTipTextAt(int index, String tooltip) {
        this.getTabbedPanePeer().setToolTipTextAt(index, tooltip);
    }

    public void addTab(String title, UiComponent component) {
        this.addTab(Msg.QUOTE((String)title), component);
    }

    public void addTab(Msg msg, UiComponent component) {
        Image image = null;
        if ((this.options & 2) != 0 && msg.hasImage()) {
            image = Image.create(msg);
        }
        this.addTab(msg, image, component);
    }

    public void addTab(String title, Image icon, UiComponent component) {
        this.addTab(Msg.QUOTE((String)title), icon, component);
    }

    public void addTab(Msg msg, Image icon, UiComponent component) {
        String tooltip = null;
        if ((this.options & 8) != 0) {
            tooltip = msg.getDetail();
        }
        this.addTab(msg, icon, component, tooltip);
    }

    public void addTab(Msg msg, Image icon, UiComponent component, String tooltip) {
        component.makeRecyclable();
        this.getTabbedPanePeer().addTab(msg.getString(), icon, component, tooltip);
        component.putClientProperty(TAB_MSG, msg);
    }

    public int indexOfComponent(UiComponent component) {
        return this.getTabbedPanePeer().indexOfComponent(component);
    }

    public int indexOfTab(Msg msg) {
        return this.getTabbedPanePeer().indexOfTab(msg.getString());
    }

    public int indexOfTab(String title) {
        return this.getTabbedPanePeer().indexOfTab(title);
    }

    public void setIconAt(int index, Image icon) {
        this.getTabbedPanePeer().setIconAt(index, icon);
    }

    public void setBackgroundAt(int index, Color color) {
        this.getTabbedPanePeer().setBackgroundAt(index, color);
    }

    public void setForegroundAt(int index, Color color) {
        this.getTabbedPanePeer().setForegroundAt(index, color);
    }

    public void setSelectedComponent(UiComponent component) {
        this.getTabbedPanePeer().setSelectedComponent(component);
    }

    public void addChangeListener(ChangeListener listener) {
        this.getTabbedPanePeer().addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.getTabbedPanePeer().removeChangeListener(listener);
    }

    @Override
    public void translate() {
        Utilities.translateChildComponentTree(this);
        this.update();
    }

    public void setOptions(int options) {
        this.options = options;
    }

    @Override
    protected Peer createPeer() {
        return this.getUiFactory().createTabbedPane(this.getParentPeer());
    }

    protected String getTabHelpId() {
        Msg msg;
        int index = this.getSelectedIndex();
        UiComponent component = this.getComponentAt(index);
        Msg msg2 = msg = component != null ? TabbedPane.getMsg(component) : null;
        String result = msg != null ? msg.getCode() : "Tab" + (index > 0 ? Integer.valueOf(index) : "");
        return result;
    }

    private static Msg getMsg(UiComponent component) {
        return (Msg)component.getClientProperty(TAB_MSG);
    }

    private TabbedPanePeer getTabbedPanePeer() {
        return (TabbedPanePeer)this.getPeer();
    }

    private void update() {
        for (int i = 0; i < this.getTabCount(); ++i) {
            UiComponent component = this.getComponentAt(i);
            Msg msg = TabbedPane.getMsg(component);
            this.applyMsg(i, msg);
        }
    }

    private void applyMsg(int index, Msg msg) {
        if (msg != null) {
            Image icon;
            if ((this.options & 1) != 0) {
                this.setTitleAt(index, msg.getString());
            }
            if ((this.options & 8) != 0) {
                this.setToolTipTextAt(index, msg.getDetail());
            }
            if ((this.options & 2) != 0 && (icon = Image.create(msg)) != null) {
                this.setIconAt(index, icon);
            }
        }
    }
}

