/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui;

import oracle.bpm.draw.Color;
import oracle.bpm.execution.Executable;
import oracle.bpm.execution.ExecutionException;
import oracle.bpm.ui.GradientPanel;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.RibbonItem;
import oracle.bpm.ui.RibbonSection;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.MouseEvent;
import oracle.bpm.ui.event.MouseListener;
import oracle.bpm.ui.layout.MigLayout;

public abstract class RibbonSectionSingle
extends RibbonSection {
    private Panel mainComponent;

    public RibbonSectionSingle(UiContainer parent) {
        super(parent);
    }

    @Override
    public UiComponent createMainComponent() {
        Panel mainComponent = new Panel(this);
        mainComponent.setLayout(new MigLayout("insets 0 0 0 0, gapx 1, fill"));
        mainComponent.setOpaque(false);
        mainComponent.setBackground(Color.valueOf(161, 190, 208));
        this.mainComponent = mainComponent;
        return mainComponent;
    }

    public void loadSection() {
        RibbonItem itemDefault = this.getDefault();
        final GradientPanel imagePanel = new GradientPanel(this.mainComponent, Color.valueOf(196, 217, 246), Color.WHITE);
        imagePanel.setLayout(new MigLayout("fill, insets 3 3 3 3, gap 0"));
        imagePanel.setOpaque(false);
        Label defaultImage = Label.create(imagePanel);
        if (itemDefault.getIcon() != null) {
            defaultImage.setIcon(itemDefault.getIcon());
        }
        defaultImage.setToolTipText(itemDefault.getTitle());
        imagePanel.add(defaultImage, "growy, center");
        this.mainComponent.add(imagePanel, "growy, growx, center");
        Executable finishExecution = new Executable(){

            public Object execute() throws ExecutionException {
                RibbonSectionSingle.this.onMouseExit(imagePanel);
                RibbonSectionSingle.this.mainComponent.setOpaque(false);
                RibbonSectionSingle.this.mainComponent.repaint();
                return null;
            }
        };
        this.mainComponent.addMouseListener(new MouseListener(){

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseDoubleClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                RibbonSectionSingle.this.mainComponent.setOpaque(true);
                RibbonSectionSingle.this.mainComponent.repaint();
                RibbonSectionSingle.this.onMouseOver(imagePanel, Color.WHITE);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                RibbonSectionSingle.this.mainComponent.setOpaque(false);
                RibbonSectionSingle.this.mainComponent.repaint();
                RibbonSectionSingle.this.onMouseExit(imagePanel);
            }
        });
        imagePanel.addMouseListener(new MouseListenerImage(imagePanel, finishExecution));
        defaultImage.addMouseListener(new MouseListenerImage(imagePanel, finishExecution));
    }

    private void onMouseOver(GradientPanel panel, Color color2) {
        panel.setGradient(Color.valueOf(196, 217, 246), color2, true);
    }

    private void onMouseExit(GradientPanel panel) {
        panel.setGradient(Color.valueOf(196, 217, 246), Color.WHITE, false);
    }

    private class MouseListenerImage
    extends MouseListenerRibbon {
        private Executable executable;

        public MouseListenerImage(GradientPanel imagePanel, Executable executable) {
            super(imagePanel);
            this.executable = executable;
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            RibbonSectionSingle.this.mainComponent.setOpaque(true);
            RibbonSectionSingle.this.mainComponent.repaint();
            RibbonSectionSingle.this.onMouseOver(((MouseListenerRibbon)this).imagePanel, Color.WHITE);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            RibbonSectionSingle.this.mainComponent.setOpaque(false);
            RibbonSectionSingle.this.mainComponent.repaint();
            RibbonSectionSingle.this.onMouseExit(((MouseListenerRibbon)this).imagePanel);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseDoubleClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            RibbonSectionSingle.this.getDefault().execute(this.executable, e);
            RibbonSectionSingle.this.mainComponent.setOpaque(false);
            RibbonSectionSingle.this.mainComponent.repaint();
            RibbonSectionSingle.this.onMouseExit(((MouseListenerRibbon)this).imagePanel);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }
    }

    private abstract class MouseListenerRibbon
    implements MouseListener {
        private GradientPanel imagePanel;

        public MouseListenerRibbon(GradientPanel imagePanel) {
            this.imagePanel = imagePanel;
        }
    }
}

