/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui;

import oracle.bpm.ui.Button;
import oracle.bpm.ui.Dialog;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.peer.Peer;
import oracle.bpm.ui.peer.RegexpTextFieldPeer;
import oracle.bpm.ui.text.TextField;

public class RegexpTextField
extends TextField {
    private boolean allowsInvalid = true;
    private static String DEFAULT_PATTERN = ".*";

    public RegexpTextField(UiContainer parent) {
        this(parent, DEFAULT_PATTERN, true);
    }

    public RegexpTextField(UiContainer parent, String pattern, boolean allowsInvalid) {
        this(parent, pattern, DEFAULT_PATTERN);
        this.allowsInvalid = allowsInvalid;
    }

    private RegexpTextField(UiContainer parent, String pattern, String value) {
        super(parent);
        this.setPattern(pattern);
        this.setText(value);
    }

    public static void main(String[] args) {
        Dialog dialog = new Dialog((UiWindow)null);
        dialog.setSize(500, 400);
        dialog.centerOnScreen();
        RegexpTextField textField = new RegexpTextField((UiContainer)dialog, "\\p{Alpha}{1}\\p{Alnum}{0,}", "instance0");
        UiContainer contentPane = dialog.getContentPane();
        contentPane.add(UiComponent.get(textField), "North");
        contentPane.add(new Button(contentPane, UIMsg.CLOSE), "South");
        dialog.setVisible(true);
    }

    public void setPattern(String pattern) {
        this.getRegexpTextFieldPeer().setPattern(pattern == null ? DEFAULT_PATTERN : pattern);
    }

    @Override
    protected Peer createPeer() {
        return this.getUiFactory().createRegexpTextField(this.getParentPeer(), this.allowsInvalid);
    }

    private RegexpTextFieldPeer getRegexpTextFieldPeer() {
        return (RegexpTextFieldPeer)this.getPeer();
    }
}

