/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import oracle.bpm.draw.Graphics;
import oracle.bpm.ui.UiComponent;

public class Overriding {
    private Class javaClass;
    private boolean overridesMaximumSize;
    private boolean overridesMinimumSize;
    private boolean overridesPaint;
    private boolean overridesPaintComponent;
    private boolean overridesPreferredSize;
    private static Map<Class, Overriding> cache = Collections.synchronizedMap(new HashMap());

    private Overriding(Class cl) {
        this.javaClass = cl;
        this.overridesPreferredSize = this.overridesMethod("getPreferredSize");
        this.overridesMaximumSize = this.overridesMethod("getMaximumSize");
        this.overridesMinimumSize = this.overridesMethod("getMinimumSize");
        this.overridesPaint = this.overridesMethod("paint", new Class[]{Graphics.class});
        this.overridesPaintComponent = this.overridesMethod("paintComponent", new Class[]{Graphics.class});
    }

    public static Overriding get(Class cl) {
        Overriding overriding = cache.get(cl);
        if (overriding == null) {
            overriding = new Overriding(cl);
            cache.put(cl, overriding);
        }
        return overriding;
    }

    public boolean isOverridesMaximumSize() {
        return this.overridesMaximumSize;
    }

    public boolean isOverridesMinimumSize() {
        return this.overridesMinimumSize;
    }

    public boolean isOverridesPaint() {
        return this.overridesPaint;
    }

    public boolean isOverridesPaintComponent() {
        return this.overridesPaintComponent;
    }

    public boolean isOverridesPreferredSize() {
        return this.overridesPreferredSize;
    }

    private boolean overridesMethod(String method) {
        return this.overridesMethod(method, null);
    }

    private boolean overridesMethod(String method, Class[] args) {
        boolean overrides = false;
        for (Class cl = this.javaClass; cl != null && cl != UiComponent.class; cl = cl.getSuperclass()) {
            try {
                cl.getDeclaredMethod(method, args);
                overrides = true;
                break;
            }
            catch (Exception e) {
                continue;
            }
        }
        return overrides;
    }
}

