/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui;

import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import oracle.bpm.ui.event.FocusEvent;
import oracle.bpm.ui.event.FocusListener;
import oracle.bpm.ui.text.TextComponent;

public class MirrorTextComponent {
    private boolean alwaysMirror = true;
    private TextComponent component;
    private boolean firstTime = true;
    private TextComponent mirror;
    private boolean mirrorOn = false;

    public MirrorTextComponent(TextComponent component, TextComponent mirror) {
        this.component = component;
        this.mirror = mirror;
        this.init();
    }

    public void setAlwaysMirror(boolean alwaysMirror) {
        this.alwaysMirror = alwaysMirror;
    }

    private void init() {
        this.component.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                if (MirrorTextComponent.this.mirror.getText().equals(MirrorTextComponent.this.component.getText())) {
                    MirrorTextComponent.this.mirrorOn = true;
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                MirrorTextComponent.this.mirrorOn = false;
                if (MirrorTextComponent.this.firstTime && MirrorTextComponent.this.mirror.getText() != null && !MirrorTextComponent.this.mirror.getText().equals("")) {
                    MirrorTextComponent.this.firstTime = false;
                }
            }
        });
        this.component.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                if (MirrorTextComponent.this.mirrorOn && (MirrorTextComponent.this.alwaysMirror || MirrorTextComponent.this.firstTime)) {
                    MirrorTextComponent.this.mirror.setText(MirrorTextComponent.this.component.getText());
                }
            }
        });
    }
}

