/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui;

import java.util.Arrays;
import java.util.List;
import oracle.bpm.resources.BoolMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Box;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.ComponentBuilder;
import oracle.bpm.ui.Frame;
import oracle.bpm.ui.InputDialog;
import oracle.bpm.ui.InputValidator;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.OkCancelDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiFactory;
import oracle.bpm.ui.UiUtilities;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.ui.layout.form.PanelBuilder;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.peer.ComponentPeer;
import oracle.bpm.ui.peer.MessageDialogPeer;
import oracle.bpm.util.ExceptionFormatter;

public class MessageDialog {
    private static UiComponent frame;
    private static final int YES_BIT = 1;
    private static final int NO_BIT = 2;
    private static final int CANCEL_BIT = 3;
    private static final int ABORT_BIT = 4;
    private static final int RETRY_BIT = 5;
    private static final int IGNORE_BIT = 6;
    private static final int CLOSE_BIT = 7;
    public static final int OK = 1;
    public static final int YES = 2;
    public static final int NO = 4;
    public static final int CANCEL = 8;
    public static final int ABORT = 16;
    public static final int RETRY = 32;
    public static final int IGNORE = 64;
    public static final int CLOSE = 128;
    public static final int QUESTION_ICON = 0x1000000;
    public static final int INFO_ICON = 0x2000000;
    public static final int WARNING_ICON = 0x4000000;
    public static final int ERROR_ICON = 0x8000000;
    public static final int FATAL_ICON = 0x10000000;
    public static final int YES_NO = 6;
    public static final int OK_CANCEL = 9;
    public static final int YES_NO_QUESTION = 0x1000006;
    public static final int YES_NO_CANCEL = 14;

    public static void setFrame(UiComponent f) {
        frame = f;
    }

    public static void showError(Msg title, Msg message) {
        MessageDialog.showError(title, message, null, null);
    }

    public static void showError(UiContainer parent, Msg title, Msg message) {
        MessageDialog.showError(parent, title, message, null, null);
    }

    public static void showError(Throwable e) {
        MessageDialog.showError(e, true);
    }

    public static void showError(UiContainer parent, Throwable e) {
        MessageDialog.showError(parent, e, true);
    }

    public static void showError(Msg msg, Throwable e) {
        MessageDialog.showError(UIMsg.ERROR, msg, null, e);
    }

    public static void showError(final Msg title, final Msg msg, final Msg details, final Throwable e) {
        if (!UiUtilities.isEventDispatchThread()) {
            UiUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.showError(title, msg, details, e);
                }
            });
        } else {
            MessageDialog.getDialogPeer().showError(title, msg, details, e);
        }
    }

    public static void showError(Msg msg) {
        MessageDialog.showError(UIMsg.ERROR, msg);
    }

    public static void showError(UiContainer parent, Msg msg) {
        MessageDialog.showError(parent, UIMsg.ERROR, msg);
    }

    public static void showError(Msg title, Msg msg, Throwable e) {
        MessageDialog.showError(title, msg, null, e);
    }

    public static void showError(Msg title, Msg msg, Msg details) {
        MessageDialog.showError(title, msg, details, null);
    }

    public static String showInput(UiWindow parent, Msg title, Msg msg) {
        return MessageDialog.showInput(parent, title, msg, "");
    }

    public static String showInput(UiWindow parent, Msg title, Msg msg, String defaultValue) {
        return InputDialog.createInputDialog(parent, title, msg, null, defaultValue).show();
    }

    public static String showInputModule(UiWindow parent, Msg title, Msg label, InputValidator validator, String suggestedName) {
        InputDialog dialog = InputDialog.createModuleDialog(parent, title, label, validator, suggestedName);
        return dialog.show();
    }

    public static String showInputDialog(UiWindow parent, Msg title, Msg label, InputValidator validator, String suggestedName, int textLimit) {
        InputDialog dialog = InputDialog.createLimitedInputDialog(parent, title, label, validator, suggestedName, textLimit);
        return dialog.show();
    }

    public static String showInputDialog(UiWindow parent, Msg title, Msg label, InputValidator validator, String suggestedName) {
        InputDialog dialog = InputDialog.createLimitedInputDialog(parent, title, label, validator, suggestedName);
        return dialog.show();
    }

    public static String showInputDialog(UiWindow parent, Msg title, Msg label, InputValidator validator, String suggestedName, boolean allowFirstUppercase) {
        return MessageDialog.showInputDialog(parent, title, label, validator, suggestedName, allowFirstUppercase, false);
    }

    public static boolean showInput(UiWindow instance, ComponentBuilder componentBuilder, Msg labelMsg) {
        OkCancelDialog dialog = new OkCancelDialog(instance){

            @Override
            public void ok() {
                this.setUserAccepted(true);
                this.close();
            }
        };
        UiComponent inputPanel = MessageDialog.createPanel(dialog.getContentPane(), componentBuilder, labelMsg.getString());
        return OkCancelDialog.doShowDialog(dialog, inputPanel);
    }

    public static void showNotice(Msg msg) {
        MessageDialog.showNotice(UIMsg.INFO, msg);
    }

    public static void showNotice(Msg title, Msg msg) {
        MessageDialog.showNotice(title, msg, null);
    }

    public static void showNotice(Msg title, Msg msg, Throwable e) {
        MessageDialog.getDialogPeer().showNotice(title, msg, e);
    }

    public static int showQuestion(UiContainer parent, Msg title, Msg msg, Msg details, int options, BoolMsg boolMsg) {
        return MessageDialog.getDialogPeer().showQuestion(parent, title, msg, details, options, boolMsg);
    }

    public static int showQuestion(Msg title, Msg msg, Msg details, Msg[] buttons, int defaultButton, BoolMsg boolMsg) {
        return MessageDialog.getDialogPeer().showQuestion(title, msg, details, buttons, defaultButton, boolMsg);
    }

    public static int showQuestion(UiContainer parent, Msg title, Msg msg, Msg details, Msg[] buttons, int defaultButton, BoolMsg boolMsg) {
        return MessageDialog.getDialogPeer().showQuestion(parent, title, msg, details, buttons, defaultButton, boolMsg);
    }

    public static int showQuestion(Msg title, Msg msg, Msg[] buttons, int defaultButton) {
        return MessageDialog.getDialogPeer().showQuestion(title, msg, null, buttons, defaultButton, null);
    }

    public static int showQuestion(Msg title, Msg msg, int options) {
        return MessageDialog.showQuestion((UiContainer)null, title, msg, null, options, null);
    }

    public static void showWarning(Msg msg) {
        MessageDialog.showWarning(UIMsg.WARNING, msg, null, null);
    }

    public static void showWarning(Msg msg, BoolMsg bMsg) {
        MessageDialog.showWarning(UIMsg.WARNING, msg, null, bMsg);
    }

    public static void showWarning(Msg msg, Msg details, BoolMsg bMsg) {
        MessageDialog.showWarning(UIMsg.WARNING, msg, details, bMsg);
    }

    public static void showWarning(Throwable e) {
        MessageDialog.showWarning(UIMsg.WARNING, UIMsg.TO_MSG(e.getMessage()), UIMsg.TO_MSG(ExceptionFormatter.fullTechLevel((Throwable)e)), null);
    }

    public static Object showOptions(UiWindow parent, Msg title, Msg msg, Object[] selectionValues, Object defaultValue) {
        return OptionsDialog.showOptions(parent, title, msg, Arrays.asList(selectionValues), defaultValue);
    }

    public static String showInput(UiWindow parent, Msg title, Msg fieldLabel, String initialValue, InputValidator validator) {
        return MessageDialog.showInputDialog(parent, title, fieldLabel, validator, initialValue);
    }

    public static String showInputDialog(UiWindow parent, Msg title, Msg label, InputValidator validator, String suggestedName, boolean allowFirstUppercase, boolean requiresFirstUpper) {
        InputDialog dialog = InputDialog.createLimitedInputDialog(parent, title, label, validator, suggestedName, allowFirstUppercase, requiresFirstUpper);
        return dialog.show();
    }

    public static String showInput(UiWindow parent, Msg title, Msg label, String suggestedName, InputValidator validator, boolean identifier) {
        InputDialog dialog = null;
        dialog = identifier ? InputDialog.createLimitedInputDialog(parent, title, label, validator, suggestedName) : InputDialog.createInputDialog(parent, title, label, validator, suggestedName);
        return dialog.show();
    }

    private static void showWarning(Msg title, Msg msg, Msg details, BoolMsg bMsg) {
        MessageDialog.getDialogPeer().showWarning(title, msg, details, bMsg);
    }

    private static void showError(Throwable e, boolean showStackTrace) {
        String text = e.getMessage() != null ? e.getMessage() : e.getClass().getSimpleName();
        MessageDialog.getDialogPeer().showError(UIMsg.ERROR, UIMsg.TO_MSG(text), showStackTrace ? UIMsg.TO_MSG(ExceptionFormatter.fullTechLevel((Throwable)e)) : null, showStackTrace ? e : null);
    }

    private static void showError(UiContainer parent, Throwable e, boolean showStackTrace) {
        MessageDialog.showError(parent, UIMsg.ERROR, UIMsg.TO_MSG(e.getMessage()), showStackTrace ? UIMsg.TO_MSG(ExceptionFormatter.fullTechLevel((Throwable)e)) : null, showStackTrace ? e : null);
    }

    private static void showError(UiContainer parent, Msg title, Msg msg, Msg details, Throwable e) {
        MessageDialog.getDialogPeer().showError(parent, title, msg, details, e);
    }

    private static MessageDialogPeer getDialogPeer() {
        UiContainer parent;
        if (frame != null && !frame.isDisposed()) {
            parent = (UiContainer)frame;
        } else {
            frame = null;
            parent = Ui.getRoot();
        }
        if (parent == null) {
            parent = new Frame();
        }
        ComponentPeer parentPeer = parent.getComponentPeer();
        return Ui.getUiFactory().createMessageDialog(parentPeer);
    }

    private static UiComponent createPanel(UiContainer parent, ComponentBuilder nameComponent, String nameMessage) {
        Panel container = new Panel(parent);
        container.setName("container");
        MessageDialog.layoutPanel(container, nameMessage, nameComponent.buildComponent(container));
        return container;
    }

    private static void layoutPanel(Panel container, String nameMessage, UiComponent nameComponent) {
        FormLayout layout = new FormLayout("5dlu, fill:pref:grow, 5dlu", "5dlu, pref, 5dlu, fill:pref:grow, 5dlu");
        PanelBuilder builder = layout.createBuilder(container);
        CellConstraints cc = layout.createCellConstraints();
        builder.addSeparator(nameMessage != null ? nameMessage : UIMsg.NAME.getString(), cc.xy(2, 2));
        builder.add(nameComponent, cc.xy(2, 4));
    }

    private static class OptionsDialog<E>
    extends OkCancelDialog {
        private E selectedOption;
        private ComboBox<E> types;

        public OptionsDialog(UiWindow parent, Msg title, Msg msg, List<E> selectionValues, E defaultValue) {
            super(parent, title);
            this.buildContent(msg, selectionValues, defaultValue);
        }

        public static <E> E showOptions(UiWindow parent, Msg title, Msg msg, List<E> selectionValues, E defaultValue) {
            OptionsDialog<E> dialog = new OptionsDialog<E>(parent, title, msg, selectionValues, defaultValue);
            dialog.setVisible(true);
            return dialog.getSelectedOption();
        }

        @Override
        public void ok() {
            this.selectedOption = this.types.getSelectedItem();
            this.close();
        }

        public E getSelectedOption() {
            return this.selectedOption;
        }

        private void buildContent(Msg msg, List<E> selectionValues, E defaultValue) {
            Panel panel = new Panel(this.getContentPane());
            panel.setLayout(new BorderLayout(10, 10));
            Panel centerPanel = new Panel(panel);
            Label label = Label.create((UiContainer)centerPanel, msg);
            this.types = UiFactory.createComboBox((UiContainer)centerPanel, selectionValues);
            this.types.setSelectedItem(defaultValue);
            panel.add(Box.createHorizontalStrut(panel, 5), "West");
            panel.add(Box.createVerticalStrut(panel, 5), "North");
            centerPanel.setLayout(new BorderLayout(10, 10));
            centerPanel.add(label, "North");
            centerPanel.add(this.types, "Center");
            panel.add(centerPanel, "Center");
            panel.add(Box.createVerticalStrut(panel, 5), "South");
            panel.add(Box.createHorizontalStrut(panel, 5), "East");
            this.getContentPane().add(panel, "Center");
            this.pack();
            this.setResizable(false);
            this.setLocationRelativeTo(this.getParent());
        }
    }
}

