/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui;

import oracle.bpm.resources.Msg;
import oracle.bpm.ui.AbstractButton;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.KeyStroke;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.peer.AbstractButtonPeer;
import oracle.bpm.ui.peer.MenuItemPeer;
import oracle.bpm.ui.peer.Peer;
import oracle.bpm.util.SystemInfo;

public class MenuItem
extends AbstractButton {
    private boolean showDialog;
    public static int OPTIONS = 23;
    private static final String DOTS = "...";

    public MenuItem(UiContainer parent) {
        super(parent, OPTIONS);
    }

    public MenuItem(UiContainer parent, String text) {
        super(parent, OPTIONS);
        this.setText(text);
    }

    public MenuItem(UiContainer parent, BaseAction a) {
        super(parent, OPTIONS);
        this.setAction(a);
        if (this.getText() == null) {
            this.setText((String)a.getValue("ShortDescription"));
        }
    }

    public MenuItem(UiContainer parent, Image icon) {
        super(parent, OPTIONS);
        this.setIcon(icon);
    }

    public MenuItem(UiContainer parent, Msg msg) {
        super(parent, OPTIONS);
        this.setMsg(msg);
    }

    public MenuItem(UiContainer parent, BaseAction a, String text) {
        super(parent, OPTIONS);
        this.setAction(a);
        this.setText(text);
    }

    public MenuItem(UiContainer parent, String text, Image icon) {
        super(parent, OPTIONS);
        this.setText(text);
        this.setIcon(icon);
    }

    public MenuItem(UiContainer parent, Msg msg, int options) {
        this(parent, msg, options, false);
    }

    public MenuItem(UiContainer parent, BaseAction a, boolean showDialog) {
        super(parent, OPTIONS);
        this.setAction(a);
        this.showDialog = showDialog;
    }

    public MenuItem(UiContainer parent, Msg msg, int options, boolean showsDialog) {
        super(parent, OPTIONS);
        this.showDialog = showsDialog;
        this.setMsg(msg, options);
    }

    protected MenuItem(UiContainer parent, int options) {
        super(parent, options);
    }

    public void setAccelerator(KeyStroke accelerator) {
    }

    public void setShowDialog(boolean showedDialog) {
        this.showDialog = showedDialog;
        this.update();
    }

    public boolean isShowDialog() {
        return this.showDialog;
    }

    @Override
    public void setVisible(boolean bool) {
        if (SystemInfo.isAnyMac()) {
            super.setEnabled(bool);
        } else {
            super.setVisible(bool);
        }
    }

    public MenuItemPeer getMenuItemPeer() {
        return (MenuItemPeer)super.getPeer();
    }

    @Override
    protected AbstractButtonPeer getAbstractPeer() {
        return (AbstractButtonPeer)this.getPeer();
    }

    @Override
    protected Peer createPeer() {
        return Ui.getUiFactory().createMenuItem(this.getParentPeer());
    }

    @Override
    protected void update() {
        Msg msg = this.getMsg();
        if (msg == null) {
            return;
        }
        int options = this.getOptions();
        if ((options & 1) != 0) {
            String s = msg.getString();
            if (this.isShowDialog()) {
                s = s + DOTS;
            }
            super.setText(s);
        }
        if ((options & 4) != 0 && msg.getMnemonic() != '\u0000') {
            super.setMnemonic(msg.getMnemonic());
        }
        if ((options & 2) != 0) {
            Image image;
            Image image2 = image = this.getAction() != null ? this.getAction().getSmallIcon() : null;
            Image image3 = image != null ? image : (image = msg.hasImage() ? Image.create(msg) : null);
            if (image != null) {
                super.setIcon(image);
            }
        }
    }
}

