/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui;

import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import oracle.bpm.collections.lists.MsgList;
import oracle.bpm.collections.maps.LocaleStringMap;
import oracle.bpm.lang.Str;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.BorderPanel;
import oracle.bpm.ui.Box;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.ListSelectionMode;
import oracle.bpm.ui.OkCancelDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.table.ProviderTableModel;
import oracle.bpm.ui.table.Table;
import oracle.bpm.ui.table.TableColumn;
import oracle.bpm.ui.table.editors.BaseTextFieldEditor;
import oracle.bpm.ui.table.editors.TextAreaCellEditor;
import oracle.bpm.ui.table.editors.TextFieldCellEditor;

public class LocalizedMessage
extends Panel {
    private Table table = null;

    public LocalizedMessage(UiContainer parent, LocaleStringMap messages, List<Locale> availableLocales, boolean multilineAllowed) {
        super(parent);
        this.setLayout(new BorderLayout());
        this.init(messages, availableLocales, multilineAllowed);
    }

    public static LocalizedDialog createDialog(UiWindow parent, LocaleStringMap messages, List<Locale> availableLocales, boolean multilineAllowed) {
        return new LocalizedDialog(parent, messages, availableLocales, multilineAllowed);
    }

    public LocaleStringMap getMessages() {
        this.stopEditting();
        return this.getModel().getMessages();
    }

    private LocalizedModel getModel() {
        return (LocalizedModel)this.table.getModel();
    }

    private void init(LocaleStringMap messages, List<Locale> availableLocales, boolean multilineAllowed) {
        BaseTextFieldEditor editor;
        LocalizedModel dataModel = new LocalizedModel(messages, availableLocales);
        this.table = new Table(this, dataModel, ListSelectionMode.SINGLE_SELECTION);
        this.table.setReorderingAllowed(false);
        this.table.setShowHorizontalLines(true);
        this.table.setDefaultLabelProvider(String.class, new LabelProvider<String>(){

            @Override
            public String getText(String value) {
                return Str.splitLines((String)value).length > 1 ? Str.splitLines((String)value)[0] + "..." : value;
            }

            @Override
            public Image getIcon(String element) {
                return null;
            }
        });
        this.table.getColumn(0).setWidth(60);
        TableColumn column = this.table.getColumn(1);
        column.setWidth(350);
        BaseTextFieldEditor baseTextFieldEditor = editor = multilineAllowed ? new TextAreaCellEditor() : new TextFieldCellEditor();
        if (multilineAllowed) {
            int h = this.table.getFontMetrics(this.table.getFont()).getHeight();
            this.table.setRowHeight(h * 3);
        }
        column.setCellEditor(editor);
        this.add(this.table, "Center");
    }

    private void stopEditting() {
        if (this.table.getCellEditor() != null) {
            this.table.getCellEditor().stopCellEditing();
        }
    }

    private static class LocalizedModel
    extends ProviderTableModel<Entry> {
        private static final MsgList titles = MsgList.create((Msg[])new Msg[]{CoreMsg.LANGUAGE, CoreMsg.MESSAGE});
        private static final int COLUMN_LANGUAGE = 0;
        private static final int COLUMN_MESSAGE = 1;

        LocalizedModel(LocaleStringMap messages, List<Locale> availableLocales) {
            super(titles);
            this.populate(messages, availableLocales);
        }

        @Override
        public boolean isCellEditable(int r, int col) {
            return col == 1;
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
            if (column == 1) {
                ((Entry)this.getRow(row)).setText(value.toString());
            }
        }

        @Override
        public Object getValueAt(int row, int column) {
            String result;
            if (column == 0) {
                Locale locale = ((Entry)this.getRow(row)).getLocale();
                result = locale.getDisplayName(locale);
            } else {
                result = ((Entry)this.getRow(row)).getText();
            }
            return result;
        }

        private LocaleStringMap getMessages() {
            LocaleStringMap message = LocaleStringMap.create();
            for (int i = 0; i < this.getRowCount(); ++i) {
                Entry entry = (Entry)this.getRow(i);
                String text = entry.getText().trim();
                if (text.length() <= 0) continue;
                message.put(entry.getLocale(), text);
            }
            return message;
        }

        private void insertRow(Locale locale, String text) {
            this.addRow(new Entry(locale, text));
        }

        private void populate(LocaleStringMap messages, List<Locale> availableLocales) {
            Iterator<Locale> i$ = availableLocales.iterator();
            while (i$.hasNext()) {
                Locale locale;
                String text = (String)messages.get((Object)(locale = i$.next()));
                this.insertRow(locale, text == null ? "" : text);
            }
        }
    }

    private static class Entry {
        private Locale locale;
        private String text;

        Entry(Locale locale, String text) {
            this.locale = locale;
            this.text = text;
        }

        public Locale getLocale() {
            return this.locale;
        }

        public void setText(String text) {
            this.text = text;
        }

        public String getText() {
            return this.text;
        }
    }

    public static class LocalizedDialog
    extends OkCancelDialog {
        private LocalizedMessage messagePanel;
        private LocaleStringMap messages;

        private LocalizedDialog(UiWindow parent, LocaleStringMap messages, List<Locale> availableLocales, boolean multilineAllowed) {
            super(parent, CoreMsg.MESSAGES_BY_LOCALE, true);
            this.init(messages, availableLocales, multilineAllowed);
        }

        public LocaleStringMap getMessages() {
            return this.messages;
        }

        @Override
        public void ok() {
            this.messages = this.messagePanel.getMessages();
            this.setUserAccepted(true);
            this.close();
        }

        private void init(LocaleStringMap messages, List<Locale> availableLocales, boolean multilineAllowed) {
            BorderPanel panel = new BorderPanel(this.getContentPane());
            this.messagePanel = new LocalizedMessage(panel, messages, availableLocales, multilineAllowed);
            panel.setLayout(new BorderLayout());
            panel.add(Box.createHorizontalStrut(panel, 10), "East");
            panel.add(Box.createHorizontalStrut(panel, 10), "West");
            panel.add(Box.createVerticalStrut(panel, 10), "North");
            panel.add(Box.createVerticalStrut(panel, 10), "South");
            panel.add(this.messagePanel, "Center");
            this.getContentPane().add(panel, "Center");
            this.pack();
            this.setLocationRelativeTo(this.getParent());
        }
    }
}

