/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui;

import java.util.ArrayList;
import javax.swing.DefaultListModel;
import oracle.bpm.draw.Color;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.ColorProvider;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.List;
import oracle.bpm.ui.ListPickerListener;
import oracle.bpm.ui.ListSelectionMode;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.ToolBar;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.event.MouseAdapter;
import oracle.bpm.ui.event.MouseEvent;
import oracle.bpm.ui.layout.MigLayout;
import oracle.bpm.ui.msg.UIMsg;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ListPicker<T>
extends Panel {
    private List<T> availableItemsList;
    private DefaultListModel availableItemsModel = new DefaultListModel();
    private java.util.List<T> items = new ArrayList<T>();
    private ArrayList<ListPickerListener> listeners = new ArrayList();
    private List<T> selectedItemsList;
    private DefaultListModel selectedItemsModel = new DefaultListModel();
    private ToolBar toolbar;

    public ListPicker(@NotNull UiContainer parent, @Nullable Msg label) {
        super(parent);
        this.init(label);
    }

    public void addCustomAction(@NotNull BaseAction action) {
        this.toolbar.add(action);
    }

    public void setItems(@NotNull java.util.List<T> items) {
        this.items.clear();
        this.items.addAll(items);
        this.availableItemsModel.clear();
        for (T item : items) {
            this.availableItemsModel.addElement(item);
        }
        this.setSelectedItems(this.getSelectedItems());
    }

    public void setSelectedItems(@NotNull java.util.List<T> items) {
        this.selectedItemsModel.clear();
        for (T item : items) {
            this.selectedItemsModel.addElement(item);
            if (!this.availableItemsModel.contains(item)) continue;
            this.availableItemsModel.removeElement(item);
        }
        this.fireSelectedItemsChanged();
    }

    public void setAvailableItemSelected(T availableSelectedItem) {
        this.availableItemsList.setSelectedValue(availableSelectedItem, true);
    }

    public java.util.List<T> getItems() {
        return this.items;
    }

    public java.util.List<T> getSelectedItems() {
        return this.createListFromModel(this.selectedItemsModel);
    }

    public void setLabelProvider(LabelProvider<T> labelProvider) {
        this.availableItemsList.setLabelProvider(labelProvider);
        this.selectedItemsList.setLabelProvider(labelProvider);
    }

    public boolean hasInvalidSelection() {
        for (Object o : this.selectedItemsModel.toArray()) {
            if (this.isValidItem(o)) continue;
            return true;
        }
        return false;
    }

    public void addListener(@NotNull ListPickerListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(@NotNull ListPickerListener listener) {
        this.listeners.remove(listener);
    }

    private void init(@Nullable Msg label) {
        this.setLayout(new MigLayout("ins 0, gap 5, fill"));
        Label availableLabel = Label.create((UiContainer)this, label != null ? label : UIMsg.AVAILABLE);
        Label selectedLabel = Label.create((UiContainer)this, UIMsg.SELECTED);
        this.availableItemsList = new List((UiContainer)this, this.availableItemsModel, ListSelectionMode.SINGLE_SELECTION);
        this.availableItemsList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseDoubleClicked(MouseEvent e) {
                ListPicker.this.selectOne();
            }
        });
        this.selectedItemsList = new List((UiContainer)this, this.selectedItemsModel, ListSelectionMode.SINGLE_SELECTION);
        this.selectedItemsList.setColorProvider(new ColorProvider<T>(){

            @Override
            public Color getBackground(T item) {
                return Color.WHITE;
            }

            @Override
            public Color getForeground(T item) {
                return ListPicker.this.getItems().contains(item) ? Color.BLACK : Color.RED;
            }
        });
        this.selectedItemsList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseDoubleClicked(MouseEvent e) {
                ListPicker.this.deselectOne();
            }
        });
        this.toolbar = new ToolBar(this, ToolBar.Orientation.HORIZONTAL, ToolBar.Alignment.RIGHT);
        this.add(availableLabel, "aligny bottom");
        this.add(this.toolbar, "alignx right");
        this.add(selectedLabel, "aligny bottom, skip 1, wrap");
        this.add(this.availableItemsList, "growy, spanx 2, width 50%");
        this.add(this.createButtonsPanel(this), "aligny center");
        this.add(this.selectedItemsList, "growy, width 50%");
    }

    private java.util.List<T> createListFromModel(@NotNull DefaultListModel model) {
        ArrayList<Object> result = new ArrayList<Object>();
        Object[] arr$ = model.toArray();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Object o;
            Object item = o = arr$[i$];
            result.add(item);
        }
        return result;
    }

    private Panel createButtonsPanel(@NotNull UiContainer parent) {
        Panel result = new Panel(parent);
        result.setLayout(new MigLayout("ins 0, gap 5, wrap"));
        Button selectOne = Button.createIconic(result, UIMsg.SHUTTLE_RIGHT);
        selectOne.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListPicker.this.selectOne();
            }
        });
        Button selectAll = Button.createIconic(result, UIMsg.SHUTTLE_RIGHT_ALL);
        selectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListPicker.this.selectAll();
            }
        });
        Button deselectOne = Button.createIconic(result, UIMsg.SHUTTLE_LEFT);
        deselectOne.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListPicker.this.deselectOne();
            }
        });
        Button deselectAll = Button.createIconic(result, UIMsg.SHUTTLE_LEFT_ALL);
        deselectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListPicker.this.deselectAll();
            }
        });
        result.add(selectOne);
        result.add(selectAll);
        result.add(deselectOne);
        result.add(deselectAll);
        return result;
    }

    private void deselectAll() {
        for (Object item : this.selectedItemsModel.toArray()) {
            this.selectedItemsModel.removeElement(item);
            if (!this.isValidItem(item)) continue;
            this.availableItemsModel.addElement(item);
        }
        this.fireSelectedItemsChanged();
    }

    private void deselectOne() {
        T selectedValue = this.selectedItemsList.getSelectedValue();
        if (selectedValue != null) {
            this.selectedItemsModel.removeElement(selectedValue);
            if (this.items.contains(selectedValue)) {
                this.availableItemsModel.addElement(selectedValue);
            }
            this.fireSelectedItemsChanged();
        }
    }

    private void selectAll() {
        for (Object item : this.availableItemsModel.toArray()) {
            this.selectedItemsModel.addElement(item);
            this.availableItemsModel.removeElement(item);
        }
        this.fireSelectedItemsChanged();
    }

    private void selectOne() {
        T selectedValue = this.availableItemsList.getSelectedValue();
        if (selectedValue != null) {
            this.selectedItemsModel.addElement(selectedValue);
            this.availableItemsModel.removeElement(selectedValue);
            this.fireSelectedItemsChanged();
        }
    }

    private boolean isValidItem(@NotNull Object item) {
        return this.items.contains(item);
    }

    private void fireSelectedItemsChanged() {
        for (ListPickerListener listener : this.listeners) {
            listener.selectedItemsChanged();
        }
    }
}

