/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui;

import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiUtilities;
import oracle.bpm.ui.text.FilteredTextField;
import oracle.bpm.ui.text.TextFilter;
import oracle.bpm.util.Identifier;

public class IdentifierTextField
extends FilteredTextField {
    private boolean allowsFirstInUpperCase = false;
    private boolean requiresFirstInUpperCase = false;
    private int textLimit = -1;
    public static final boolean DEFAULT_ALLOW_FIRST_IN_UPPER_CASE = false;
    private static final boolean DEFAULT_REQUIRES_FIRST_IN_UPPER_CASE = false;
    public static final int DEFAULT_COLUMNS = 0;
    private static final int DEFAULT_TEXT_LIMIT = -1;

    public IdentifierTextField(UiContainer parent) {
        this(parent, false);
    }

    public IdentifierTextField(UiContainer parent, boolean allowsFirstInUpperCase) {
        this(parent, "", allowsFirstInUpperCase);
    }

    public IdentifierTextField(UiContainer parent, String text) {
        this(parent, text, false);
    }

    public IdentifierTextField(UiContainer parent, int columns) {
        this(parent, "", columns, false, false);
    }

    public IdentifierTextField(UiContainer parent, String text, boolean allowsFirstInUpperCase) {
        this(parent, text, allowsFirstInUpperCase, false);
    }

    public IdentifierTextField(UiContainer parent, String text, int columns) {
        this(parent, text, columns, false);
    }

    public IdentifierTextField(UiContainer parent, int columns, boolean allowsFirstInUpperCase) {
        this(parent, "", columns, allowsFirstInUpperCase, false);
    }

    public IdentifierTextField(UiContainer parent, String text, boolean allowsFirstInUpperCase, boolean requiresFirstInUpperCase) {
        this(parent, text, 0, allowsFirstInUpperCase, requiresFirstInUpperCase);
    }

    public IdentifierTextField(UiContainer parent, String text, int columns, boolean allowsFirstInUpperCase) {
        this(parent, text, columns, allowsFirstInUpperCase, false);
    }

    public IdentifierTextField(UiContainer parent, String text, int columns, boolean allowsFirstInUpperCase, boolean requiresFirstInUpperCase) {
        super(parent);
        this.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.truncate();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.truncate();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.truncate();
            }

            private void truncate() {
                UiUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        String text;
                        if (IdentifierTextField.this.textLimit > 0 && (text = IdentifierTextField.this.getText()).length() > IdentifierTextField.this.textLimit) {
                            IdentifierTextField.this.setText(text.substring(0, IdentifierTextField.this.textLimit));
                        }
                    }
                }, true);
            }
        });
        this.setText(text);
        this.setColumns(columns);
        this.setFilter(this.createFilter());
        this.setAllowsFirstInUpperCase(allowsFirstInUpperCase);
        this.setRequiresFirstInUpperCase(requiresFirstInUpperCase);
    }

    public void setAllowsFirstInUpperCase(boolean allows) {
        this.allowsFirstInUpperCase = allows;
    }

    public void setTextLimit(int number) {
        this.textLimit = number;
    }

    protected TextFilter createFilter() {
        return new TextFilter(){

            @Override
            public boolean accepts(String text, int offs) {
                char ch;
                if (text == null) {
                    return true;
                }
                if (IdentifierTextField.this.textLimit != -1 && offs >= IdentifierTextField.this.textLimit) {
                    return false;
                }
                if (text.length() > 0 && offs == 0 && !Identifier.isValidStart((int)(ch = text.charAt(0)))) {
                    return false;
                }
                for (int i = 0; i < text.length(); ++i) {
                    char ch2 = text.charAt(i);
                    if (Identifier.isValidPart((int)ch2)) continue;
                    return false;
                }
                return true;
            }

            @Override
            public String filter(String text, int offs) {
                if (!IdentifierTextField.this.allowsFirstInUpperCase && text != null && offs == 0 && text.length() > 0) {
                    char ch = text.charAt(0);
                    return "" + Character.toLowerCase(ch) + text.substring(1, text.length());
                }
                if (IdentifierTextField.this.requiresFirstInUpperCase && text != null && offs == 0 && text.length() > 0) {
                    char ch = text.charAt(0);
                    return "" + Character.toUpperCase(ch) + text.substring(1, text.length());
                }
                return text;
            }
        };
    }

    private void setRequiresFirstInUpperCase(boolean requires) {
        this.requiresFirstInUpperCase = requires;
    }
}

