/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui;

import oracle.bpm.draw.Color;
import oracle.bpm.draw.GradientPattern;
import oracle.bpm.draw.Graphics;
import oracle.bpm.geom.Point;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.border.Border;
import org.jetbrains.annotations.NotNull;

public class GradientPanel
extends Panel {
    private Color color1;
    private Color color2;

    public GradientPanel(@NotNull UiContainer parent, @NotNull Color color1, @NotNull Color color2) {
        super(parent);
        this.color1 = color1;
        this.color2 = color2;
    }

    public void setGradient(@NotNull Color color1, @NotNull Color color2) {
        this.color1 = color1;
        this.color2 = color2;
        this.repaint();
    }

    public void setGradient(@NotNull Color color1, @NotNull Color color2, boolean state) {
        this.setOpaque(state);
        this.setGradient(color1, color2);
    }

    public void inverseColors() {
        Color aux = this.color2;
        this.color2 = this.color1;
        this.color1 = aux;
        this.setOpaque(true);
        this.repaint();
    }

    @Override
    public void paint(Graphics g) {
        if (this.isOpaque()) {
            GradientPattern gradientPattern = new GradientPattern(new Point(0, 0), new Point(0, this.getHeight()), this.color1, this.color2);
            Rectangle rectangle = new Rectangle(0, 0, this.getWidth(), this.getHeight());
            g.setPattern(gradientPattern);
            g.fill(rectangle);
            this.paintComponents(g);
            Border border = this.getBorder();
            if (border != null) {
                border.paintBorder(this, g, 0, 0, this.getWidth(), this.getHeight());
            }
        } else {
            super.paint(g);
        }
    }
}

