/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui;

import oracle.bpm.draw.Color;
import oracle.bpm.draw.Font;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.CheckBox;
import oracle.bpm.ui.FontStyle;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.NumberSearchList;
import oracle.bpm.ui.OkCancelDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.SearchList;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.event.ListSelectionEvent;
import oracle.bpm.ui.event.ListSelectionListener;
import oracle.bpm.ui.layout.AttributeAxis;
import oracle.bpm.ui.layout.AttributeConstraint;
import oracle.bpm.ui.layout.AttributeType;
import oracle.bpm.ui.layout.AxisConstraint;
import oracle.bpm.ui.layout.RelativeLayout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.utils.FontUtils;

public class FontChooser
extends OkCancelDialog {
    private Font currentFont;
    private SearchList fontNameList;
    private NumberSearchList fontSizeList;
    private SearchList fontStyleList;
    private Label previewLabel;

    private FontChooser(UiWindow parent, Font current, String[] fontNames, String[] fontSizes) {
        super(parent, UIMsg.FONT_PROPERTIES);
        this.setCurrentFont(current);
        RelativeLayout contentLayout = new RelativeLayout();
        UiContainer contentPane = this.getContentPane();
        contentPane.setLayout(contentLayout);
        RelativeLayout fontPanelLayout = new RelativeLayout();
        Panel fontPanel = new Panel(contentPane);
        fontPanel.setLayout(fontPanelLayout);
        this.fontNameList = new SearchList((UiContainer)fontPanel, fontNames);
        fontPanel.add(Label.create((UiContainer)fontPanel, UIMsg.FONT_TITLE), "fontNameLabel");
        fontPanel.add(this.fontNameList, "fontNameList");
        this.fontStyleList = new SearchList((UiContainer)fontPanel, FontStyle.values());
        this.fontStyleList.setLabelProvider(new FontStyleLabelProvider());
        fontPanel.add(Label.create((UiContainer)fontPanel, UIMsg.FONT_STYLE_TITLE), "fontStyleLabel");
        fontPanel.add(this.fontStyleList, "fontStyleList");
        this.fontSizeList = new NumberSearchList((UiContainer)fontPanel, fontSizes);
        fontPanel.add(Label.create((UiContainer)fontPanel, UIMsg.SIZE_TITLE), "fontSizeLabel");
        fontPanel.add(this.fontSizeList, "fontSizeList");
        this.layoutFontPanel(fontPanelLayout);
        RelativeLayout stylePanelLayout = new RelativeLayout();
        Panel stylePanel = new Panel(contentPane, UIMsg.STYLE);
        stylePanel.setLayout(stylePanelLayout);
        CheckBox underlineCheckBox = CheckBox.create((UiContainer)stylePanel, UIMsg.UNDERLINE);
        stylePanel.add(underlineCheckBox, "underline");
        CheckBox strikeoutCheckBox = CheckBox.create((UiContainer)stylePanel, UIMsg.STRIKEOUT);
        stylePanel.add(strikeoutCheckBox, "strikeout");
        this.layoutStylePanel(stylePanelLayout);
        Panel previewPanel = new Panel(contentPane, UIMsg.PREVIEW);
        previewPanel.setLayout(new BorderLayout());
        this.previewLabel = Label.create((UiContainer)previewPanel, Msg.QUOTE((String)"The quick brown fox jumps over the lazy dog."));
        this.previewLabel.setHorizontalAlignment(0);
        this.previewLabel.setBackground(Color.WHITE);
        this.previewLabel.setForeground(Color.BLACK);
        this.previewLabel.setOpaque(true);
        previewPanel.add(this.previewLabel, "Center");
        contentPane.add(fontPanel, "fontPanel");
        contentPane.add(stylePanel, "stylePanel");
        contentPane.add(previewPanel, "previewPanel");
        this.layoutContent(contentLayout);
        ListSelectionListener listSelListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent ev) {
                FontChooser.this.updatePreview();
            }
        };
        this.fontNameList.addListSelectionListener(listSelListener);
        this.fontStyleList.addListSelectionListener(listSelListener);
        this.fontSizeList.addListSelectionListener(listSelListener);
        strikeoutCheckBox.setEnabled(false);
        underlineCheckBox.setEnabled(false);
        this.setCurrentValues();
        this.setSize(450, 400);
        this.setLocationRelativeTo(this.getParent());
    }

    public static Font showDialog(UiWindow parent, Font currentFont) {
        FontChooser fontChooser = new FontChooser(parent, currentFont, FontUtils.getAvailableFontFamilyNames(), FontUtils.getDefaultFontSizes());
        fontChooser.setVisible(true);
        if (!fontChooser.userAccepted()) {
            return null;
        }
        return fontChooser.getCurrentFont();
    }

    public Font getCurrentFont() {
        return this.currentFont;
    }

    @Override
    public void ok() {
        this.close();
    }

    private void setCurrentFont(Font current) {
        this.currentFont = current;
    }

    private void setCurrentValues() {
        Font font = this.getCurrentFont();
        if (font == null) {
            font = this.getFont();
        }
        String name = font.getName();
        int size = font.getSize();
        this.fontNameList.setSelected(name);
        this.fontStyleList.getList().setSelectedValue(FontStyle.valueOf((boolean)font.isBold(), (boolean)font.isItalic()), true);
        this.fontSizeList.setSelected(String.valueOf(size));
        this.previewLabel.setFont(font);
        this.previewLabel.repaint();
    }

    private void layoutContent(RelativeLayout layout) {
        layout.addConstraint("fontPanel", AttributeType.TOP, new AttributeConstraint("_container", AttributeType.TOP, 2));
        layout.addConstraint("fontPanel", AttributeType.LEFT, new AttributeConstraint("_container", AttributeType.LEFT, 2));
        layout.addConstraint("fontPanel", AttributeType.RIGHT, new AttributeConstraint("buttonPanel", AttributeType.LEFT, -2));
        layout.addConstraint("fontPanel", AttributeType.BOTTOM, new AttributeConstraint("stylePanel", AttributeType.TOP, -2));
        layout.addConstraint("stylePanel", AttributeType.LEFT, new AttributeConstraint("fontPanel", AttributeType.LEFT));
        layout.addConstraint("stylePanel", AttributeType.BOTTOM, new AttributeConstraint("_container", AttributeType.BOTTOM));
        layout.addConstraint("previewPanel", AttributeType.TOP, new AttributeConstraint("stylePanel", AttributeType.TOP));
        layout.addConstraint("previewPanel", AttributeType.LEFT, new AttributeConstraint("stylePanel", AttributeType.RIGHT));
        layout.addConstraint("previewPanel", AttributeType.RIGHT, new AttributeConstraint("fontPanel", AttributeType.RIGHT));
        layout.addConstraint("previewPanel", AttributeType.BOTTOM, new AttributeConstraint("stylePanel", AttributeType.BOTTOM));
        layout.addConstraint("buttonPanel", AttributeType.TOP, new AttributeConstraint("fontPanel", AttributeType.TOP));
        layout.addConstraint("buttonPanel", AttributeType.RIGHT, new AttributeConstraint("_container", AttributeType.RIGHT, -2));
    }

    private void layoutFontPanel(RelativeLayout layout) {
        layout.addConstraint("fontNameLabel", AttributeType.TOP, new AttributeConstraint("_container", AttributeType.TOP, 2));
        layout.addConstraint("fontNameLabel", AttributeType.LEFT, new AttributeConstraint("_container", AttributeType.LEFT, 2));
        layout.addConstraint("fontNameList", AttributeType.TOP, new AttributeConstraint("fontNameLabel", AttributeType.BOTTOM, 2));
        layout.addConstraint("fontNameList", AttributeType.LEFT, new AttributeConstraint("fontNameLabel", AttributeType.LEFT));
        layout.addConstraint("fontNameList", AttributeType.RIGHT, new AxisConstraint("_container", AttributeAxis.HORIZONTAL, 0.5));
        layout.addConstraint("fontNameList", AttributeType.BOTTOM, new AttributeConstraint("_container", AttributeType.BOTTOM, -2));
        layout.addConstraint("fontStyleLabel", AttributeType.TOP, new AttributeConstraint("fontNameLabel", AttributeType.TOP));
        layout.addConstraint("fontStyleLabel", AttributeType.LEFT, new AttributeConstraint("fontNameList", AttributeType.RIGHT, 2));
        layout.addConstraint("fontStyleList", AttributeType.TOP, new AttributeConstraint("fontNameList", AttributeType.TOP));
        layout.addConstraint("fontStyleList", AttributeType.LEFT, new AttributeConstraint("fontNameList", AttributeType.RIGHT, 2));
        layout.addConstraint("fontStyleList", AttributeType.RIGHT, new AxisConstraint("_container", AttributeAxis.HORIZONTAL, 0.8));
        layout.addConstraint("fontStyleList", AttributeType.BOTTOM, new AttributeConstraint("fontNameList", AttributeType.BOTTOM));
        layout.addConstraint("fontSizeLabel", AttributeType.TOP, new AttributeConstraint("fontStyleLabel", AttributeType.TOP));
        layout.addConstraint("fontSizeLabel", AttributeType.LEFT, new AttributeConstraint("fontStyleList", AttributeType.RIGHT, 2));
        layout.addConstraint("fontSizeList", AttributeType.TOP, new AttributeConstraint("fontStyleList", AttributeType.TOP));
        layout.addConstraint("fontSizeList", AttributeType.LEFT, new AttributeConstraint("fontStyleList", AttributeType.RIGHT, 2));
        layout.addConstraint("fontSizeList", AttributeType.RIGHT, new AttributeConstraint("_container", AttributeType.RIGHT, -2));
        layout.addConstraint("fontSizeList", AttributeType.BOTTOM, new AttributeConstraint("fontStyleList", AttributeType.BOTTOM));
    }

    private void layoutStylePanel(RelativeLayout layout) {
        layout.addConstraint("underline", AttributeType.TOP, new AttributeConstraint("_container", AttributeType.TOP));
        layout.addConstraint("underline", AttributeType.LEFT, new AttributeConstraint("_container", AttributeType.LEFT));
        layout.addConstraint("strikeout", AttributeType.TOP, new AttributeConstraint("underline", AttributeType.BOTTOM, 2));
        layout.addConstraint("strikeout", AttributeType.LEFT, new AttributeConstraint("_container", AttributeType.LEFT));
    }

    private void updatePreview() {
        String fontName = this.fontNameList.getSelected();
        String selectedFontSize = this.fontSizeList.getSelected();
        int fontSize = Integer.parseInt(selectedFontSize.equals("") ? "0" : selectedFontSize);
        if (fontSize <= 0) {
            return;
        }
        FontStyle style = (FontStyle)this.fontStyleList.getList().getSelectedValue();
        this.setCurrentFont(Font.valueOf(fontName, style, fontSize));
        this.previewLabel.setFont(this.getCurrentFont());
        this.previewLabel.repaint();
    }

    private static class FontStyleLabelProvider
    extends LabelProvider.Default<FontStyle> {
        private FontStyleLabelProvider() {
        }

        @Override
        public String getText(FontStyle element) {
            return element.getMsg().toString();
        }
    }
}

