/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui;

import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.SwingConstants;
import oracle.bpm.ui.Image;

public final class CompositeIcon
implements Icon,
SwingConstants {
    private final Image icon1;
    private final Image icon2;
    private final int position;

    public CompositeIcon(Image icon1, Image icon2, int position) {
        this.icon1 = icon1;
        this.icon2 = icon2;
        this.position = position;
    }

    @Override
    public int getIconHeight() {
        int icon1Height = this.icon1.getIconHeight();
        int icon2Height = this.icon2.getIconHeight();
        return this.position == 1 || this.position == 3 ? icon1Height + icon2Height : Math.max(icon1Height, icon2Height);
    }

    @Override
    public int getIconWidth() {
        int icon1Width = this.icon1.getIconWidth();
        int icon2Width = this.icon2.getIconWidth();
        return this.position == 2 || this.position == 4 ? icon1Width + icon2Width : Math.max(icon1Width, icon2Width);
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        int w = this.getIconWidth();
        int h = this.getIconHeight();
        switch (this.position) {
            case 2: {
                this.paint(c, g, this.icon1, x, y, w, h, 2, 0);
                this.paint(c, g, this.icon2, x + this.icon1.getIconWidth(), y, w, h, 2, 0);
                break;
            }
            case 4: {
                this.paint(c, g, this.icon2, x, y, w, h, 2, 0);
                this.paint(c, g, this.icon1, x + this.icon2.getIconWidth(), y, w, h, 2, 0);
                break;
            }
            case 1: {
                this.paint(c, g, this.icon1, x, y, w, h, 0, 1);
                this.paint(c, g, this.icon2, x, y + this.icon1.getIconHeight(), w, h, 0, 1);
                break;
            }
            case 3: {
                this.paint(c, g, this.icon1, x, y + this.icon2.getIconHeight(), w, h, 0, 1);
                this.paint(c, g, this.icon2, x, y, w, h, 0, 1);
                break;
            }
            default: {
                this.paint(c, g, this.icon1, x, y, w, h, 0, 0);
                this.paint(c, g, this.icon2, x, y, w, h, 0, 0);
            }
        }
    }

    private void paint(Component c, Graphics g, Image icon, int x, int y, int width, int height, int h, int v) {
        icon.asSwingIcon().paintIcon(c, g, h == 2 ? x : (h == 4 ? x + width - icon.getIconWidth() : x + (width - icon.getIconWidth()) / 2), v == 1 ? y : (v == 3 ? y + height - icon.getIconHeight() : y + (height - icon.getIconHeight()) / 2));
    }
}

