/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui;

import java.util.HashMap;
import java.util.Map;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.ReferenceComboBox;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.layout.CardLayout;
import oracle.bpm.ui.layout.MigLayout;
import oracle.bpm.ui.msg.UIMsg;

public class ComboBoxTabbedPane<T>
extends Panel {
    private Panel contentPanel;
    private ItemListener itemStateChangeListener;
    private Map<T, String> tabs = new HashMap<T, String>();
    private ReferenceComboBox<T> typeComboBox;

    public ComboBoxTabbedPane(UiContainer parent) {
        super(parent);
        this.init();
    }

    public UiContainer getAddPoint() {
        return this.contentPanel;
    }

    public T getSelectedItem() {
        return (T)this.typeComboBox.getSelectedItem();
    }

    public void setValue(T value) {
        this.typeComboBox.setValue(value);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.typeComboBox.setEnabled(enabled);
    }

    public void addTab(T type, Msg msg, UiComponent c) {
        this.typeComboBox.removeItemListener(this.itemStateChangeListener);
        this.typeComboBox.addItem(type);
        this.contentPanel.add(c, msg.getCode());
        this.tabs.put(type, msg.getCode());
        this.typeComboBox.addItemListener(this.itemStateChangeListener);
    }

    public void setLabelProvider(LabelProvider<T> labelProvider) {
        this.typeComboBox.setLabelProvider(labelProvider);
    }

    public void addItemListener(ItemListener itemListener) {
        this.typeComboBox.addItemListener(itemListener);
    }

    public void removeItemListener(ItemListener itemListener) {
        this.typeComboBox.removeItemListener(itemListener);
    }

    private void init() {
        this.setLayout(new MigLayout("ins 0, gap 5, fill"));
        this.typeComboBox = new ReferenceComboBox(this);
        Label label = Label.create((UiContainer)this, UIMsg.TYPE);
        this.contentPanel = new Panel(this);
        final CardLayout cardLayout = new CardLayout();
        this.contentPanel.setLayout(cardLayout);
        this.add(label);
        this.add(this.typeComboBox, "pushx, wrap");
        this.add(this.contentPanel, "grow, pushy, spanx");
        this.itemStateChangeListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                cardLayout.show(ComboBoxTabbedPane.this.contentPanel, (String)ComboBoxTabbedPane.this.tabs.get(ComboBoxTabbedPane.this.typeComboBox.getSelectedItem()));
            }
        };
        this.typeComboBox.addItemListener(this.itemStateChangeListener);
    }
}

