/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import oracle.bpm.event.ModificationEvent;
import oracle.bpm.event.ModificationListener;
import oracle.bpm.lang.Any;
import oracle.bpm.resources.I18nProvider;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.ColorProvider;
import oracle.bpm.ui.FontProvider;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.ListListModel;
import oracle.bpm.ui.ListModelComboBoxModel;
import oracle.bpm.ui.MutableListListModel;
import oracle.bpm.ui.MutableListModelComboBoxModel;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiUtilities;
import oracle.bpm.ui.Utilities;
import oracle.bpm.ui.event.Editable;
import oracle.bpm.ui.event.InputVerifier;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.event.ModifyListener;
import oracle.bpm.ui.peer.ComboBoxPeer;
import oracle.bpm.ui.peer.Peer;
import oracle.bpm.ui.text.TextHolder;
import org.jetbrains.annotations.Nullable;

public class ComboBox<E>
extends UiContainer
implements Editable,
TextHolder {
    protected ListListModel listListModel;
    private E defaultValue;
    private boolean editable;
    private ItemListener itemListener;
    private LabelProvider<E> labelProvider;
    private ArrayList<ModificationListener> modificationListeners = new ArrayList();
    private Msg msg;
    private boolean mutable;
    private Object oldValue;
    private Comparator<E> transformedOrder;

    protected ComboBox(UiContainer parent, boolean editable) {
        this(parent, editable, true, null, new ArrayList());
    }

    protected ComboBox(UiContainer parent, boolean editable, boolean mutable, @Nullable E defaultValue, List<E> list) {
        super(parent);
        this.editable = editable;
        this.mutable = mutable;
        this.defaultValue = defaultValue;
        UiUtilities.addToEditableContainer(this, parent);
        this.setModelList(list);
        this.setSelectedItem(!list.isEmpty() ? list.iterator().next() : null);
        this.setLabelProvider(new LabelProvider.Default<E>(){

            @Override
            public String getText(E element) {
                String result = null;
                if (element instanceof I18nProvider) {
                    I18nProvider i18n = (I18nProvider)element;
                    result = i18n.getString();
                } else if (element != null) {
                    result = element.toString();
                }
                return result;
            }
        });
    }

    public void setModelList(List<E> list) {
        MutableListListModel<E> listModel;
        this.listListModel = listModel = new MutableListListModel<E>(list);
        this.setModel(this.isMutable() ? new MutableListModelComboBoxModel(listModel) : new ListModelComboBoxModel(listModel));
    }

    @Override
    public void addModificationListener(ModificationListener listener) {
        this.modificationListeners.add(listener);
        if (this.itemListener == null) {
            this.itemListener = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    ComboBox.this.fireChanged(e);
                }
            };
            this.addItemListener(this.itemListener);
        }
    }

    @Override
    public void removeModificationListener(ModificationListener listener) {
        this.modificationListeners.remove(listener);
        if (this.modificationListeners.isEmpty()) {
            this.removeItemListener(this.itemListener);
            this.itemListener = null;
        }
    }

    public void setInputVerifier(InputVerifier verifier) {
        this.getComboBoxPeer().setInputVerifier(verifier);
    }

    public void addModifyListener(ModifyListener listener) {
        this.getComboBoxPeer().addModifyListener(listener);
    }

    public LabelProvider<E> getLabelProvider() {
        return this.labelProvider;
    }

    public void addItem(E item) {
        this.getComboBoxPeer().addItem(item);
    }

    public void addItemListener(ItemListener listener) {
        if (listener != null) {
            this.getComboBoxPeer().addItemListener(listener);
        }
    }

    public void addItems(Iterable<? extends E> items) {
        for (E item : items) {
            this.addItem(item);
        }
    }

    public E getItemAt(int index) {
        return (E)this.getComboBoxPeer().getItemAt(index);
    }

    public int getItemCount() {
        return this.getComboBoxPeer().getItemCount();
    }

    public boolean containsItem(Object item) {
        int itemCount = this.getItemCount();
        for (int i = 0; i < itemCount; ++i) {
            E anItem = this.getItemAt(i);
            if (!Any.equals((Object)item, anItem)) continue;
            return true;
        }
        return false;
    }

    public ComboBoxModel getModel() {
        return this.getComboBoxPeer().getModel();
    }

    public int getSelectedIndex() {
        return this.getComboBoxPeer().getSelectedIndex();
    }

    public E getSelectedItem() {
        Object item = this.getComboBoxPeer().getSelectedItem();
        return (E)(item == this.defaultValue ? null : item);
    }

    public Object[] getSelectedObjects() {
        return this.getComboBoxPeer().getSelectedObjects();
    }

    public Comparator<E> getTransformedOrder() {
        if (this.transformedOrder == null) {
            this.transformedOrder = new ElementComparator();
        }
        return this.transformedOrder;
    }

    @Deprecated
    public void hidePopup() {
        if (this.isSwing()) {
            this.getJComboBox().hidePopup();
        }
    }

    public int indexOf(Object item) {
        int result = -1;
        if (item != null) {
            int count = this.getItemCount();
            for (int i = 0; i < count; ++i) {
                if (!this.getItemAt(i).equals(item)) continue;
                result = i;
                break;
            }
        }
        return result;
    }

    public void insertItemAt(Object value, int index) {
        this.getComboBoxPeer().insertItemAt(value, index);
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void removeAllItems() {
        this.getComboBoxPeer().removeAllItems();
    }

    public void removeItem(Object item) {
        this.getComboBoxPeer().removeItem(item);
    }

    public void removeItemAt(int index) {
        this.getComboBoxPeer().removeItemAt(index);
    }

    public void removeModifyListener(ModifyListener listener) {
        if (listener != null) {
            this.getComboBoxPeer().removeModifyListener(listener);
        }
    }

    public void removeItemListener(ItemListener listener) {
        if (listener != null) {
            this.getComboBoxPeer().removeItemListener(listener);
        }
    }

    public void setColorProvider(ColorProvider provider) {
        this.getComboBoxPeer().setColorProvider(provider);
    }

    public void setDelegate(List list) {
        if (this.listListModel == null) {
            throw new UnsupportedOperationException("Only for Combos created with Lists");
        }
        this.listListModel.setDelegate(list);
    }

    public void setFontProvider(FontProvider<E> provider) {
        this.getComboBoxPeer().setFontProvider(provider);
    }

    public void setLabelProvider(LabelProvider<E> provider) {
        this.labelProvider = provider;
        this.getComboBoxPeer().setLabelProvider(provider);
    }

    public void setMaximumRowCount(int count) {
        this.getComboBoxPeer().setMaximumRowCount(count);
    }

    public void setModel(ComboBoxModel model) {
        this.getComboBoxPeer().setModel(model);
    }

    public void setPrototypeDisplayValue(String value) {
        this.getComboBoxPeer().setPrototypeDisplayValue(value);
    }

    public void setSelectedIndex(int index) {
        this.getComboBoxPeer().setSelectedIndex(index);
    }

    public void setSelectedItem(Object item) {
        this.getComboBoxPeer().setSelectedItem(item);
    }

    public void setToolTipMsg(Msg msg) {
        this.msg = msg;
        this.setToolTipText(msg.getString());
    }

    @Deprecated
    public void showPopup() {
        if (this.isSwing()) {
            this.getJComboBox().showPopup();
        }
    }

    public void sortList(List<E> list) {
        Collections.sort(list, this.getTransformedOrder());
    }

    @Override
    public void translate() {
        Utilities.translateChildComponentTree(this);
        this.updateUI();
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.msg != null) {
            this.setToolTipText(this.msg.getString());
        }
    }

    @Override
    public void setText(String text) {
        if (this.isEditable()) {
            this.getComboBoxPeer().setText(text);
        }
    }

    @Override
    public String getText() {
        return this.getComboBoxPeer().getText();
    }

    @Override
    public boolean isModified() {
        return !Any.equals((Object)this.oldValue, this.getSelectedItem());
    }

    @Override
    public void resetModified() {
        this.oldValue = this.getSelectedItem();
    }

    @Override
    protected Peer createPeer() {
        return this.getUiFactory().createComboBox(this.getParentPeer(), this.isEditable());
    }

    static int indexOf(ComboBoxModel model, Object obj) {
        for (int i = 0; i < model.getSize(); ++i) {
            Object element = model.getElementAt(i);
            if (obj != element && (obj == null || !obj.equals(element))) continue;
            return i;
        }
        return -1;
    }

    private boolean isMutable() {
        return this.mutable;
    }

    private void fireChanged(ItemEvent e) {
        for (ModificationListener modificationListener : this.modificationListeners) {
            modificationListener.objectModified(new ModificationEvent((Object)this, null, e.getItem()));
        }
    }

    private ComboBoxPeer getComboBoxPeer() {
        return (ComboBoxPeer)this.getPeer();
    }

    private JComboBox getJComboBox() {
        return (JComboBox)this.asSwing();
    }

    private class ElementComparator
    implements Comparator<E> {
        private ElementComparator() {
        }

        @Override
        public int compare(E o1, E o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            LabelProvider labelProvider = ComboBox.this.getLabelProvider();
            return labelProvider == null ? o1.toString().compareTo(o2.toString()) : labelProvider.getText(o1).compareTo(labelProvider.getText(o2));
        }
    }
}

