/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui;

import oracle.bpm.resources.Msg;
import oracle.bpm.ui.CollapsableContainer;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.ToolBar;
import oracle.bpm.ui.ToolBarItem;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.border.BevelBorder;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.MouseAdapter;
import oracle.bpm.ui.event.MouseEvent;
import oracle.bpm.ui.layout.MigLayout;
import oracle.bpm.ui.msg.UIMsg;
import org.jetbrains.annotations.NotNull;

public class CollapsableItem {
    private ToolBar actionsToolBar;
    private CollapsableContainer container;
    private Panel contentPanel;
    private ToolBarItem expandedToolBarItem;
    private boolean isExpanded;
    private Panel titlePanel;
    protected static final Image COLLAPSED = Image.create(UIMsg.ARROW);
    protected static final Image EXPANDED = Image.create(UIMsg.DOWN_ARROW);

    public CollapsableItem(@NotNull CollapsableContainer container, @NotNull String title, Image icon, boolean isExpanded) {
        this.container = container;
        this.isExpanded = isExpanded;
        this.initTitlePanel(container, title, icon);
        this.initContentPanel(container);
    }

    public void initTitlePanel(@NotNull UiContainer container, @NotNull String title, Image icon) {
        this.titlePanel = new Panel(container);
        this.titlePanel.setLayout(new MigLayout("ins 0, gap 0, fill"));
        this.titlePanel.setBorder(new BevelBorder(0));
        ToolBar expandToolbar = new ToolBar(container);
        BaseAction expandAction = new BaseAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CollapsableItem.this.expandCollapse();
            }
        };
        expandAction.setSmallIcon(this.getImage(this.isExpanded));
        this.expandedToolBarItem = expandToolbar.add(expandAction);
        if (icon != null) {
            Label iconLabel = Label.create((UiContainer)expandToolbar, icon);
            iconLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    CollapsableItem.this.expandCollapse();
                }
            });
            expandToolbar.add(iconLabel);
            expandToolbar.addSeparator();
        }
        Label label = Label.create((UiContainer)expandToolbar, Msg.QUOTE((String)title));
        label.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                CollapsableItem.this.expandCollapse();
            }
        });
        expandToolbar.add(label);
        this.titlePanel.add(expandToolbar, "center, alignx left");
    }

    public CollapsableContainer getContainer() {
        return this.container;
    }

    public void addAction(@NotNull BaseAction action) {
        if (this.actionsToolBar == null) {
            this.actionsToolBar = new ToolBar(this.titlePanel);
            this.actionsToolBar.setVisible(this.isExpanded);
            this.titlePanel.add(this.actionsToolBar, "east");
        }
        this.actionsToolBar.add(action);
        this.titlePanel.revalidate();
    }

    protected Panel getTitlePanel() {
        return this.titlePanel;
    }

    protected Panel getContentPanel() {
        return this.contentPanel;
    }

    private void initContentPanel(@NotNull UiContainer container) {
        this.contentPanel = new Panel(container);
        this.contentPanel.setLayout(new MigLayout("ins 0, gap 0, fill"));
        this.contentPanel.makeRecyclable();
        this.contentPanel.setVisible(this.isExpanded);
    }

    private void expandCollapse() {
        this.isExpanded = !this.isExpanded;
        this.expandedToolBarItem.setIcon(this.getImage(this.isExpanded));
        if (this.actionsToolBar != null) {
            this.actionsToolBar.setVisible(this.isExpanded);
        }
        this.contentPanel.setVisible(this.isExpanded);
    }

    private Image getImage(boolean isExpanded) {
        return isExpanded ? EXPANDED : COLLAPSED;
    }
}

