/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.draw;

import java.text.AttributedCharacterIterator;
import java.util.HashMap;
import java.util.Map;
import oracle.bpm.log.Log;
import oracle.bpm.ui.FontInfo;
import oracle.bpm.ui.FontStyle;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.peer.FontPeer;

public final class Font {
    private int hash;
    private FontInfo info;
    private FontPeer peer;
    private static Map<Font, Font> fontCache = new HashMap<Font, Font>();
    private static final Font KEY = new Font();
    private static final String N_SERIF = "Serif";
    private static final String N_SANS_SERIF = "SansSerif";
    private static final String N_MONOSPACED = "Monospaced";
    private static final String N_DIALOG = "Dialog";
    private static final String N_DIALOG_INPUT = "Monospaced";
    public static final Font SERIF = Font.valueOf("Serif", FontStyle.PLAIN, 12);
    public static final Font SANS_SERIF = Font.valueOf("SansSerif", FontStyle.PLAIN, 12);
    public static final Font MONOSPACED = Font.valueOf("Monospaced", FontStyle.PLAIN, 12);
    public static final Font DIALOG = Font.valueOf("Dialog", FontStyle.PLAIN, 12);
    public static final Font DIALOG_INPUT = Font.valueOf("Monospaced", FontStyle.PLAIN, 12);

    private Font() {
    }

    private Font(String name, FontStyle style, int size) {
        this.info = new FontInfo(name, style.ordinal(), size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Font valueOf(String name, FontStyle style, int size) {
        Font f;
        int fixedSize = Font.fixSize(size);
        Font font = KEY;
        synchronized (font) {
            Font.KEY.info = new FontInfo(name, style.ordinal(), size);
            Font.KEY.hash = 0;
            f = fontCache.get(KEY);
            if (f == null) {
                f = new Font(name, style, fixedSize);
                fontCache.put(f, f);
                if (fontCache.size() >= 100) {
                    Log.logDebug((String)("Too many fonts? (" + fontCache.size() + ")"));
                }
            }
        }
        return f;
    }

    public static Font valueOf(FontInfo info) {
        return Font.valueOf(info.getName(), FontStyle.valueOf((int)info.getStyle()), info.getSize());
    }

    public static Font valueOf(Object nativeFont) {
        Font result;
        if (nativeFont instanceof Font) {
            result = (Font)nativeFont;
        } else {
            FontPeer p = Font.createPeer(nativeFont);
            result = Font.valueOf(p.getName(), p.getStyle(), p.getSize());
            result.setPeer(p);
        }
        return result;
    }

    public static Font decode(String fontSpec) {
        return fontSpec != null ? Font.parse(fontSpec) : Font.valueOf("dialog", FontStyle.PLAIN, 12);
    }

    public Map getAttributes() {
        return this.getPeer().getAttributes();
    }

    public AttributedCharacterIterator.Attribute[] getAvailableAttributes() {
        return this.getPeer().getAvailableAttributes();
    }

    public boolean isBold() {
        return this.getStyle().isBold();
    }

    public boolean isItalic() {
        return this.getStyle().isItalic();
    }

    public String getName() {
        return this.info.getName();
    }

    public FontPeer getPeer() {
        if (this.peer == null) {
            this.setPeer(Font.createPeer(this.getName(), this.getStyle(), this.getSize()));
            assert (this.peer != null) : "Could not create peer for component " + this.getClass().getName();
        }
        return this.peer;
    }

    public int getSize() {
        return this.info.getSize();
    }

    public FontStyle getStyle() {
        return FontStyle.valueOf((FontInfo)this.info);
    }

    public Font applyStyle(FontStyle newStyle) {
        return this.deriveFont(newStyle);
    }

    public String getFamily() {
        return this.getPeer().getFamily();
    }

    public Font bold() {
        return this.isBold() ? this : this.deriveFont(FontStyle.BOLD);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Font font = (Font)o;
        return this.info.equals((Object)font.info);
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = this.info.hashCode();
        }
        return this.hash;
    }

    public Font italic() {
        return this.isItalic() ? this : this.deriveFont(FontStyle.ITALIC);
    }

    public Font larger(int delta) {
        return this.deriveFont(this.getSize() + delta);
    }

    public Font plain() {
        return this.isPlain() ? this : this.deriveFont(FontStyle.PLAIN);
    }

    public Font resize(int newSize) {
        return this.deriveFont(newSize);
    }

    public Font scale(float scale) {
        return this.deriveFont((float)this.getSize() * scale);
    }

    public Font smaller(int delta) {
        return delta == 0 ? this : this.deriveFont(this.getSize() - delta);
    }

    public String toString() {
        return "Font(" + this.getName() + ", " + this.getSize() + ", " + this.getStyle() + ")";
    }

    public FontInfo getInfo() {
        return this.info;
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    private static Font parse(String fontSpec) {
        FontStyle fontStyle;
        char sep;
        String fontName = fontSpec;
        int i = fontSpec.indexOf(45);
        char c = sep = i == -1 ? (char)' ' : '-';
        if (sep == '-') {
            fontName = fontSpec.substring(0, i);
            fontSpec = fontSpec.substring(i + 1).toLowerCase();
            fontStyle = Font.decodeStyle(fontSpec);
        } else {
            int index = (fontSpec = fontSpec.toLowerCase()).indexOf("bolditalic");
            if (index != -1) {
                fontStyle = FontStyle.BOLD_ITALIC;
            } else {
                index = fontSpec.indexOf("bold italic");
                if (index != -1) {
                    fontStyle = FontStyle.BOLD_ITALIC;
                } else {
                    index = fontSpec.indexOf("bold");
                    if (index != -1) {
                        fontStyle = FontStyle.BOLD;
                    } else {
                        index = fontSpec.indexOf("italic");
                        FontStyle fontStyle2 = fontStyle = index != -1 ? FontStyle.ITALIC : FontStyle.PLAIN;
                    }
                }
            }
            if (index != -1) {
                fontName = fontName.substring(0, index).trim();
            }
        }
        return Font.valueOf(fontName, fontStyle, Font.decodeSize(fontSpec, sep));
    }

    private static int decodeSize(String fontSpec, char sep) {
        int index = fontSpec.lastIndexOf(sep);
        if (index != -1) {
            fontSpec = fontSpec.substring(index + 1);
        }
        int result = 12;
        try {
            result = Integer.valueOf(fontSpec.trim());
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        return result;
    }

    private static FontStyle decodeStyle(String fontSpec) {
        FontStyle result = fontSpec.indexOf("bold-italic") != -1 ? FontStyle.BOLD_ITALIC : (fontSpec.indexOf("bolditalic") != -1 ? FontStyle.BOLD_ITALIC : (fontSpec.indexOf("bold") != -1 ? FontStyle.BOLD : (fontSpec.indexOf("italic") != -1 ? FontStyle.ITALIC : FontStyle.PLAIN)));
        return result;
    }

    private static FontPeer createPeer(String name, FontStyle style, int size) {
        return Ui.getUiFactory().createFont(name, style, size);
    }

    private static int fixSize(int size) {
        return size > 0 && size < 100 ? size : 12;
    }

    private static FontPeer createPeer(Object peer) {
        return Ui.getUiFactory().createFont(peer);
    }

    private void setPeer(FontPeer p) {
        this.peer = p;
    }

    private Font deriveFont(FontStyle style) {
        return this.getPeer().deriveFont(style);
    }

    private Font deriveFont(float size) {
        return this.getPeer().deriveFont(size);
    }

    private boolean isPlain() {
        return this.getStyle() == FontStyle.PLAIN;
    }
}

