/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.io.fs.protocol;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.regex.Pattern;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.io.fs.protocol.VFileURLConnection;
import oracle.bpm.io.fs.protocol.vfile.Handler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class URLHelper {
    private static final int URL_CONNECTION_CONNECT_TIMEOUT = Integer.getInteger("oracle.bpmn.remote.connection.timeout", 10000);
    private static final int URL_CONNECTION_READ_TIMEOUT = Integer.getInteger("oracle.bpmn.remote.read.timeout", 10000);

    private URLHelper() {
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static URL toUrl(@NotNull URI uri) throws MalformedURLException {
        if (uri == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/protocol/URLHelper.toUrl must not be null");
        }
        String scheme = uri.getScheme();
        if (scheme == null) {
            throw new IllegalArgumentException("URI is not absolute");
        }
        Handler handler = "vfile".equals(scheme) ? Handler.getInstance() : null;
        URL uRL = new URL(null, uri.toString(), handler);
        if (uRL == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/io/fs/protocol/URLHelper.toUrl must not return null");
        }
        return uRL;
    }

    @Nullable
    public static VFile getFromURI(@NotNull URI uri) {
        if (uri == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/protocol/URLHelper.getFromURI must not be null");
        }
        if ("vfile".equals(uri.getScheme())) {
            return VFileURLConnection.get(uri);
        }
        return null;
    }

    public static String getResourceLocation(@NotNull URL url) {
        if (url == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/protocol/URLHelper.getResourceLocation must not be null");
        }
        if ("vfile".equals(url.getProtocol())) {
            return url.getPath();
        }
        return url.toString();
    }

    public static String getResourceLocation(@NotNull URI uri) {
        if (uri == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/protocol/URLHelper.getResourceLocation must not be null");
        }
        if ("vfile".equals(uri.getScheme())) {
            return uri.getRawPath();
        }
        return uri.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static String buildRelativeLocation(@NotNull String importer, @NotNull String imported) {
        int i;
        String string;
        if (importer == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/protocol/URLHelper.buildRelativeLocation must not be null");
        }
        if (imported == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/io/fs/protocol/URLHelper.buildRelativeLocation must not be null");
        }
        if (Pattern.matches("(?i)[a-z](?:[a-z0-9+-.]*):.*", imported)) {
            string = imported;
            if (string == null) throw new IllegalArgumentException("@NotNull method oracle/bpm/io/fs/protocol/URLHelper.buildRelativeLocation must not return null");
            return string;
        }
        String sep = "/";
        if (!imported.startsWith("/")) {
            string = imported;
            if (string == null) throw new IllegalArgumentException("@NotNull method oracle/bpm/io/fs/protocol/URLHelper.buildRelativeLocation must not return null");
            return string;
        }
        imported = imported.substring(1);
        if (importer.startsWith("/")) {
            importer = importer.substring(1);
        }
        int upLevelCount = 0;
        Pattern sepPattern = Pattern.compile("/+");
        String[] split1 = sepPattern.split(importer);
        String[] split2 = sepPattern.split(imported);
        for (int c = 0; c < split1.length - 1; ++c) {
            String s1 = split1[c];
            String s2 = null;
            if (split2.length - 1 > c) {
                s2 = split2[c];
            }
            if (s2 != null && s1.equals(s2)) continue;
            upLevelCount = split1.length - c - 1;
            break;
        }
        StringBuilder builder = new StringBuilder();
        for (i = 0; i < upLevelCount; ++i) {
            builder.append("..");
            builder.append("/");
        }
        for (i = c; i < split2.length; ++i) {
            String s = split2[i];
            builder.append(s);
            if (i == split2.length - 1) continue;
            builder.append("/");
        }
        string = builder.toString();
        if (string != null) return string;
        throw new IllegalArgumentException("@NotNull method oracle/bpm/io/fs/protocol/URLHelper.buildRelativeLocation must not return null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public static URL createURL(@NotNull URI uri) throws MalformedURLException {
        URL url;
        URL uRL;
        if (uri == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/protocol/URLHelper.createURL must not be null");
        }
        if (!"oramds".equals(uri.getScheme())) {
            URL uRL2 = URLHelper.toUrl(uri);
            uRL = uRL2;
            if (uRL2 == null) throw new IllegalArgumentException("@NotNull method oracle/bpm/io/fs/protocol/URLHelper.createURL must not return null");
            return uRL;
        }
        try {
            url = uri.toURL();
        }
        catch (MalformedURLException e) {
            Class<URLHelper> clazz = URLHelper.class;
            // MONITORENTER : oracle.bpm.io.fs.protocol.URLHelper.class
            try {
                URL.setURLStreamHandlerFactory(new OraMdsURLStreamHandler(null));
            }
            catch (Error e1) {
                try {
                    Field lockField = URL.class.getDeclaredField("streamHandlerLock");
                    lockField.setAccessible(true);
                    Object lock = lockField.get(null);
                    Field factoryField = URL.class.getDeclaredField("factory");
                    factoryField.setAccessible(true);
                    Object object = lock;
                    // MONITORENTER : object
                    URLStreamHandlerFactory oldFactory = (URLStreamHandlerFactory)factoryField.get(null);
                    OraMdsURLStreamHandler handler = new OraMdsURLStreamHandler(oldFactory);
                    factoryField.set(null, handler);
                    // MONITOREXIT : object
                }
                catch (NoSuchFieldException e2) {
                    e2.printStackTrace();
                }
                catch (IllegalAccessException e2) {
                    e2.printStackTrace();
                }
            }
            // MONITOREXIT : clazz
            url = new URL(uri.toString());
        }
        URL uRL3 = url;
        uRL = uRL3;
        if (uRL3 == null) throw new IllegalArgumentException("@NotNull method oracle/bpm/io/fs/protocol/URLHelper.createURL must not return null");
        return uRL;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static InputStream openStream(@NotNull URI uri) throws IOException {
        if (uri == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/protocol/URLHelper.openStream must not be null");
        }
        InputStream inputStream = URLHelper.openStream(URLHelper.toUrl(uri));
        if (inputStream == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/io/fs/protocol/URLHelper.openStream must not return null");
        }
        return inputStream;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static InputStream openStream(@NotNull URL url) throws IOException {
        if (url == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/protocol/URLHelper.openStream must not be null");
        }
        URLConnection urlConnection = url.openConnection();
        urlConnection.setConnectTimeout(URL_CONNECTION_CONNECT_TIMEOUT);
        urlConnection.setReadTimeout(URL_CONNECTION_READ_TIMEOUT);
        InputStream inputStream = urlConnection.getInputStream();
        if (inputStream == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/io/fs/protocol/URLHelper.openStream must not return null");
        }
        return inputStream;
    }

    private static class OraMdsURLStreamHandler
    extends URLStreamHandler
    implements URLStreamHandlerFactory {
        private final URLStreamHandlerFactory oldFactory;

        OraMdsURLStreamHandler(URLStreamHandlerFactory oldFactory) {
            this.oldFactory = oldFactory;
        }

        @Override
        public URLStreamHandler createURLStreamHandler(String protocol) {
            URLStreamHandler handler;
            if ("oramds".equals(protocol)) {
                handler = this;
            } else if (this.oldFactory != null) {
                handler = this.oldFactory.createURLStreamHandler(protocol);
                if (handler == null && "vfile".equals(protocol)) {
                    handler = Handler.getInstance();
                }
            } else {
                handler = null;
            }
            return handler;
        }

        @Override
        protected URLConnection openConnection(URL u) throws IOException {
            return new URLConnection(u){

                @Override
                public void connect() {
                }
            };
        }
    }
}

