/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.io.fs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArraySet;
import oracle.bpm.io.fs.VEventType;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.io.fs.VFileEvent;
import oracle.bpm.io.fs.VFileEventListener;
import oracle.bpm.io.fs.VFileFilter;
import oracle.bpm.io.fs.protocol.VFileURLConnection;
import oracle.bpm.io.fs.protocol.vfile.Handler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class VFileSystem {
    private final List<VFileEvent> delayedEvents = new ArrayList<VFileEvent>();
    @NotNull
    private volatile DispatchEventStrategy dispatchEventStrategy = new DispatchEventImmediate();
    private final Set<VFileEventListener> listeners = new CopyOnWriteArraySet<VFileEventListener>();
    private final String uuid = UUID.randomUUID().toString();

    protected VFileSystem() {
        this.registerFileSystem();
    }

    public abstract void flush() throws IOException;

    public abstract VFile[] list(@NotNull VFile var1, @Nullable VFileFilter var2);

    public VFile getRoot() {
        return this.createFile("/");
    }

    public VFile createFile(@NotNull String location) {
        if (location == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/VFileSystem.createFile must not be null");
        }
        return new VFile(this, location);
    }

    public VFile createFile(@NotNull VFile parent, @NotNull String child) {
        if (parent == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/VFileSystem.createFile must not be null");
        }
        if (child == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/io/fs/VFileSystem.createFile must not be null");
        }
        return new VFile(this, parent, child);
    }

    public final void addListener(@NotNull VFileEventListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/VFileSystem.addListener must not be null");
        }
        this.listeners.add(listener);
    }

    public final void removeListener(@NotNull VFileEventListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/VFileSystem.removeListener must not be null");
        }
        this.listeners.remove(listener);
    }

    public final void clearListeners() {
        this.listeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runWithEventsDelayed(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/VFileSystem.runWithEventsDelayed must not be null");
        }
        this.pauseEventDispatch();
        try {
            runnable.run();
        }
        finally {
            this.resumeEventDispatch();
        }
    }

    public void closeOutputStream(@NotNull VFile vFile, @NotNull OutputStream out) throws IOException {
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/VFileSystem.closeOutputStream must not be null");
        }
        if (out == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/io/fs/VFileSystem.closeOutputStream must not be null");
        }
        VEventType eventType = vFile.isCreated() ? VEventType.ADD : VEventType.CHANGE;
        this.fireEvent(new VFileEvent(eventType, vFile));
    }

    public final void fireEvent(@NotNull VFileEvent event) {
        if (event == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/VFileSystem.fireEvent must not be null");
        }
        if (this.fireEventInternal(event)) {
            this.dispatchEvent(event);
        }
    }

    public void copyTo(@NotNull VFileSystem targetVFileSystem) throws IOException {
        if (targetVFileSystem == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/VFileSystem.copyTo must not be null");
        }
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopEventDispatch() {
        String string = this.uuid;
        synchronized (string) {
            this.dispatchEventStrategy = new DispatchEventNoDispatch(this.dispatchEventStrategy);
        }
    }

    @NotNull
    protected abstract String getUniqueID();

    protected abstract long lastModified(@NotNull VFile var1);

    protected abstract boolean isZeroLength(@NotNull VFile var1);

    protected abstract boolean delete(@NotNull VFile var1);

    protected abstract boolean mkdirs(@NotNull VFile var1);

    protected abstract boolean exists(@NotNull VFile var1);

    protected abstract boolean isDirectory(@NotNull VFile var1);

    protected abstract boolean canWrite(@NotNull VFile var1);

    protected abstract InputStream openInputStream(@NotNull VFile var1) throws IOException;

    protected abstract OutputStream openOutputStream(@NotNull VFile var1) throws IOException;

    protected abstract boolean isHidden(@NotNull VFile var1);

    protected abstract boolean isFile(@NotNull VFile var1);

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    protected URL createUrl(@NotNull VFile vFile) throws IOException {
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/VFileSystem.createUrl must not be null");
        }
        URI uri = this.createURI(vFile);
        assert (uri.isAbsolute());
        URL uRL = new URL(null, uri.toString(), Handler.getInstance());
        if (uRL == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/io/fs/VFileSystem.createUrl must not return null");
        }
        return uRL;
    }

    protected boolean fireEventInternal(@NotNull VFileEvent event) {
        if (event == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/VFileSystem.fireEventInternal must not be null");
        }
        return true;
    }

    protected final void dispatchEvent(@NotNull VFileEvent event) {
        if (event == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/VFileSystem.dispatchEvent must not be null");
        }
        this.dispatchEventStrategy.dispatch(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resumeEventDispatch() {
        String string = this.uuid;
        synchronized (string) {
            this.dispatchEventStrategy = this.dispatchEventStrategy.previousStrategy();
        }
        this.dispatchEventStrategy.flushEvents();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pauseEventDispatch() {
        String string = this.uuid;
        synchronized (string) {
            this.dispatchEventStrategy = new DispatchEventDelayed(this.dispatchEventStrategy);
        }
    }

    private URI createURI(VFile vFile) throws MalformedURLException {
        try {
            return new URI("vfile", this.uuid, vFile.getCanonicalPath(), null);
        }
        catch (URISyntaxException e) {
            MalformedURLException me = new MalformedURLException(e.getMessage());
            me.initCause(e);
            throw me;
        }
    }

    private void registerFileSystem() {
        VFileURLConnection.register(this.uuid, this);
    }

    private final class DispatchEventNoDispatch
    extends DispatchEventDelayed {
        public DispatchEventNoDispatch(DispatchEventStrategy dispatchEventStrategy) {
            super(dispatchEventStrategy);
        }

        @Override
        public void dispatch(@NotNull VFileEvent event) {
            if (event == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/VFileSystem$DispatchEventNoDispatch.dispatch must not be null");
            }
        }
    }

    private class DispatchEventImmediate
    implements DispatchEventStrategy {
        private DispatchEventImmediate() {
        }

        @Override
        public DispatchEventStrategy previousStrategy() {
            assert (false) : "Events already resumed";
            return this;
        }

        @Override
        public void dispatch(@NotNull VFileEvent event) {
            if (event == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/VFileSystem$DispatchEventImmediate.dispatch must not be null");
            }
            for (VFileEventListener listener : VFileSystem.this.listeners) {
                listener.onFileEvent(event);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void flushEvents() {
            Object[] events;
            List list = VFileSystem.this.delayedEvents;
            synchronized (list) {
                List pending = VFileSystem.this.delayedEvents;
                events = pending.toArray();
                pending.clear();
            }
            for (Object event : events) {
                this.dispatch((VFileEvent)event);
            }
        }
    }

    private class DispatchEventDelayed
    implements DispatchEventStrategy {
        private final DispatchEventStrategy previous;

        private DispatchEventDelayed(DispatchEventStrategy previous) {
            this.previous = previous;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dispatch(@NotNull VFileEvent event) {
            if (event == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/VFileSystem$DispatchEventDelayed.dispatch must not be null");
            }
            List list = VFileSystem.this.delayedEvents;
            synchronized (list) {
                VFileSystem.this.delayedEvents.add(event);
            }
        }

        @Override
        public DispatchEventStrategy previousStrategy() {
            return this.previous;
        }

        @Override
        public void flushEvents() {
        }
    }

    private static interface DispatchEventStrategy {
        public void dispatch(@NotNull VFileEvent var1);

        public DispatchEventStrategy previousStrategy();

        public void flushEvents();
    }
}

