/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.compositeutil;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import org.jetbrains.annotations.NotNull;

public class CaseFileReaderUtil {
    public String getFileData(@NotNull String fullFilePath) {
        InputStream is = this.getFileInputStream(fullFilePath);
        return this.getFileData(is, fullFilePath);
    }

    public InputStream getFileInputStream(@NotNull String fullFilePath) {
        ClassLoader loader = this.getClassLoader();
        return loader.getResourceAsStream(fullFilePath);
    }

    public String getFileData(@NotNull InputStream is, @NotNull String fullFilePath) {
        int read;
        InputStreamReader in;
        if (is == null) {
            throw new RuntimeException("File Not found" + fullFilePath);
        }
        char[] buffer = new char[65536];
        StringBuilder out = new StringBuilder();
        try {
            in = new InputStreamReader(is, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new RuntimeException("Cannot read " + fullFilePath + " from jar file.");
        }
        do {
            try {
                read = ((Reader)in).read(buffer, 0, buffer.length);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new RuntimeException("Cannot read " + fullFilePath + " from jar file.");
            }
            if (read <= 0) continue;
            out.append(buffer, 0, read);
        } while (read >= 0);
        return out.toString();
    }

    private ClassLoader getClassLoader() {
        return this.getClass().getClassLoader();
    }
}

