/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpm.casemgmt.CaseServiceException;
import oracle.bpm.casemgmt.ICaseMetadataService;
import oracle.bpm.casemgmt.common.logger.CaseLogger;
import oracle.bpm.casemgmt.fabric.CaseSEException;
import oracle.bpm.casemgmt.fabric.ICaseSEWrapper;
import oracle.bpm.casemgmt.factory.ServicesLocator;
import oracle.bpm.casemgmt.metadata.Case.model.CaseMetadata;
import oracle.bpm.casemgmt.metadata.Case.model.TCaseData;
import oracle.bpm.casemgmt.metadata.Case.model.TCaseMetadata;
import oracle.bpm.casemgmt.metadata.Case.model.TData;
import oracle.bpm.casemgmt.metadata.casedisplay.model.TCaseDisplayInfo;
import oracle.bpm.casemgmt.persistence.model.Case;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;
import oracle.fabric.composite.model.ComponentModel;

public class CaseUtil {
    static DatatypeFactory datatypeFactory = null;
    private static final int DEFAULT_BUFFER_SIZE = 4096;

    public static XMLGregorianCalendar getXMLGregorianCalendar(Calendar cal) throws Exception {
        if (cal instanceof GregorianCalendar) {
            return datatypeFactory.newXMLGregorianCalendar((GregorianCalendar)cal);
        }
        return datatypeFactory.newXMLGregorianCalendar(cal.get(1), cal.get(2) + 1, cal.get(5), cal.get(11), cal.get(12), cal.get(13), cal.get(14), cal.getTimeZone().getOffset(cal.getTimeInMillis()) / 60000);
    }

    public static Timestamp convertToTimestamp(XMLGregorianCalendar calendar) {
        Timestamp timestamp = null;
        if (calendar != null) {
            timestamp = new Timestamp(calendar.toGregorianCalendar().getTimeInMillis());
        }
        return timestamp;
    }

    public static XMLGregorianCalendar convertToCalendar(Timestamp timestamp) {
        XMLGregorianCalendar xmlGregorianCalendar = null;
        if (timestamp != null) {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTimeInMillis(timestamp.getTime());
            xmlGregorianCalendar = datatypeFactory.newXMLGregorianCalendar(calendar);
        }
        return xmlGregorianCalendar;
    }

    public static byte[] convertInputStreamToByteArray(InputStream input) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            bos.write(buffer, 0, n);
        }
        return bos.toByteArray();
    }

    public static TCaseDisplayInfo getCaseFormURI(IBPMContext ctx, Case caseInstance, ICaseMetadataService.FORM_TYPE formType, String caseArtifactName) throws CaseServiceException {
        ICaseSEWrapper engineWrapper = ServicesLocator.getCaseSE();
        CaseMetadata caseMetaData = ServicesLocator.getCaseMetadataService().getCaseMetadata(ctx, caseInstance.getCaseHeader().getCaseDefinitionId());
        ComponentModel compModel = engineWrapper.getCaseComponentModel(caseInstance.getCaseHeader().getCaseDefinitionId());
        String compositeVersion = compModel.getComposite().getRevision();
        String partitionName = caseInstance.getCaseHeader().getApplicationName();
        String caseDefinitionNamespace = ((TCaseMetadata)caseMetaData.getValue()).getTargetNamespace();
        ICaseMetadataService metaService = ServicesLocator.getCaseMetadataService();
        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_COMMON, (Severity)Severity.DEBUG, (String)("getCaseFormURI for Case Id :" + caseInstance.getCaseId() + "compositeVersion = " + compositeVersion + "partitionName = " + partitionName + "caseDefinitionNamespace = " + caseDefinitionNamespace + "formType = " + formType.name() + "caseArtifactName = " + caseArtifactName));
        List urls = metaService.getCaseDisplayForm(ctx, caseDefinitionNamespace, caseArtifactName, compositeVersion, partitionName, null, null, formType);
        if (urls != null && !urls.isEmpty()) {
            return (TCaseDisplayInfo)urls.get(0);
        }
        return null;
    }

    public static List<TData> getMetaDataOfCaseData(CaseMetadata caseMetadata) throws CaseSEException {
        TCaseMetadata tcaseMetadata = null;
        ArrayList<TData> metaData = new ArrayList<TData>();
        List tcaseData = new ArrayList();
        if (caseMetadata != null && (tcaseMetadata = (TCaseMetadata)caseMetadata.getValue()) != null && (tcaseData = tcaseMetadata.getCaseData()) != null && !tcaseData.isEmpty()) {
            for (TCaseData tc : tcaseData) {
                metaData.addAll(tc.getData());
            }
        }
        return metaData;
    }

    static {
        try {
            datatypeFactory = DatatypeFactory.newInstance();
        }
        catch (Exception e) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_COMMON, (Severity)Severity.ERRORS, (String)CaseUtil.class.getName(), (String)"static initialization", (Throwable)e);
        }
    }
}

