/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpm.casemgmt.ICaseMetadataService;
import oracle.bpm.casemgmt.casedisplay.model.CaseDisplay;
import oracle.bpm.casemgmt.casemetadata.model.CaseDefinition;
import oracle.bpm.casemgmt.common.logger.CaseLogger;
import oracle.bpm.casemgmt.fabric.CaseManagementServiceEngine;
import oracle.bpm.casemgmt.factory.ServicesLocator;
import oracle.bpm.casemgmt.impl.CaseServiceUtil;
import oracle.bpm.casemgmt.metadata.casedisplay.model.ObjectFactory;
import oracle.bpm.casemgmt.metadata.casedisplay.model.TCaseDisplayInfo;
import oracle.bpm.casemgmt.persistence.CasePersistenceException;
import oracle.bpm.casemgmt.persistence.ICasePersistence;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;

public class CaseDisplayUtil {
    public static final String WORKLIST_CASE_DISPLAY_APP = "worklist";
    public static final String DEFAULT_CASE_DISPLAY_FORM_NAME = "default";

    public static List<CaseDefinition> getCaseMetadataByTemplateNamespace(IBPMContext ctx, String templateNamespace, String compositeVersion, String partionName) {
        return null;
    }

    public static List<CaseDefinition> getCaseMetadataByNamespace(IBPMContext ctx, String namespace, String compositeVersion, String partitionName) throws CasePersistenceException {
        ICasePersistence persistence = ServicesLocator.getCasePersistence();
        ArrayList<CaseDefinition> result = new ArrayList<CaseDefinition>();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        StringBuilder query = new StringBuilder();
        query.append("select o from CaseDefinition o where o.namespace = :namespace");
        parameters.put("namespace", namespace);
        if (compositeVersion != null) {
            query.append(" and o.compositeVersion = :compositeVersion");
            parameters.put("compositeVersion", compositeVersion);
        }
        if (partitionName != null) {
            query.append(" and o.applicationName = :applicationName");
            parameters.put("applicationName", partitionName);
        }
        result.addAll(persistence.findWithQuery(query.toString(), parameters));
        return result;
    }

    public static Set<String> getActualNamespacesFromTemplateNS(IBPMContext ctx, String caseDefinitionNamespace, String caseArtifactName, String partitionName) {
        HashSet<String> result = new HashSet<String>();
        List<CaseDefinition> caseMetadata = CaseDisplayUtil.getCaseMetadataByTemplateNamespace(ctx, caseDefinitionNamespace, null, partitionName);
        if (caseMetadata != null && !caseMetadata.isEmpty()) {
            for (CaseDefinition thisMetadata : caseMetadata) {
                result.add(thisMetadata.getNamespace());
            }
        }
        return result;
    }

    public static Map<String, String> createPartitionCaseMetadataMap(IBPMContext ctx, String caseDefinitionNamespace, String partitionName, String compositeVersion) throws CasePersistenceException {
        String METHOD_NAME = "createPartitionCaseMetadataMap";
        HashMap<String, String> result = new HashMap<String, String>();
        if (partitionName != null && compositeVersion != null) {
            result.put(partitionName, compositeVersion);
        } else {
            List<CaseDefinition> caseMetadataList = CaseDisplayUtil.getCaseMetadataByNamespace(ctx, caseDefinitionNamespace, null, partitionName);
            for (CaseDefinition caseMetadata : caseMetadataList) {
                String thisPartition = caseMetadata.getApplicationName();
                if (result.get(thisPartition) != null) continue;
                String thisVersion = null;
                if (compositeVersion == null) {
                    thisVersion = CaseManagementServiceEngine.getInstance().getActiveCompositeVersion(caseMetadata.getApplicationName(), caseMetadata.getCompositeName());
                    if (thisVersion == null) {
                        thisVersion = caseMetadata.getCompositeVersion();
                    }
                } else {
                    thisVersion = compositeVersion;
                }
                result.put(thisPartition, thisVersion);
                if (partitionName == null) continue;
                break;
            }
            if (partitionName != null && result.size() == 0) {
                result.put(partitionName, null);
            }
        }
        return result;
    }

    public static int deleteCaseDisplayInfo(String namespace, String caseArtificatName, String compositeVersion, String partitionName, ICaseMetadataService.FORM_TYPE formType) throws CasePersistenceException {
        ICasePersistence persistence = ServicesLocator.getCasePersistence();
        StringBuilder deleteQuery = new StringBuilder();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        deleteQuery.append("delete from CaseDisplay c where ");
        deleteQuery.append("c.compositeNamespace = :compositeNamespace ");
        parameters.put("compositeNamespace", namespace);
        deleteQuery.append("and c.cmNamespace = :cmNamespace ");
        parameters.put("cmNamespace", caseArtificatName);
        deleteQuery.append("and c.formType = :formType ");
        parameters.put("formType", formType.toString());
        if (compositeVersion == null) {
            deleteQuery.append("and c.compositeVersion IS NULL");
        } else {
            deleteQuery.append("and c.compositeVersion = :compositeVersion");
            parameters.put("compositeVersion", compositeVersion);
        }
        if (partitionName == null) {
            deleteQuery.append(" and c.partitionname IS NULL");
        } else {
            deleteQuery.append(" and c.partitionname = :partitionname");
            parameters.put("partitionname", partitionName);
        }
        CaseDisplayUtil.debugLog("deleteCaseDisplayInfo", "Delete Query Formed for deleting CaseDisplay :" + deleteQuery.toString());
        return persistence.executeUpdateWithQuery(deleteQuery.toString(), parameters);
    }

    public static int deleteCaseDisplayInfo(TCaseDisplayInfo displayInfo) throws CasePersistenceException {
        ICasePersistence persistence = ServicesLocator.getCasePersistence();
        StringBuilder deleteQuery = new StringBuilder();
        StringBuilder predicate = null;
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        String applicationName = displayInfo.getApplicationName();
        String formName = displayInfo.getFormName();
        String uri = displayInfo.getUri();
        String hostname = displayInfo.getHostname();
        String httpPort = displayInfo.getHttpPort();
        String httpsPort = displayInfo.getHttpsPort();
        CaseDisplayUtil.debugLog("deleteCaseDisplayInfo", "inserting: \n applicationName = " + applicationName + "\nformName = " + formName + "\nuri = " + uri + "\nhostname = " + hostname + "\nhttpPort = " + httpPort + "\nhttpsPort = " + httpsPort);
        deleteQuery.append("delete from CaseDisplay c where ");
        if (applicationName != null && applicationName.trim().length() > 0) {
            predicate = CaseDisplayUtil.addPredicate(predicate, "c.applicationname", "=", ":applicationname");
            parameters.put("applicationname", applicationName);
        }
        if (formName != null && formName.trim().length() > 0) {
            predicate = CaseDisplayUtil.addPredicate(predicate, "c.formName", "=", ":formName");
            parameters.put("formName", formName);
        }
        if (uri != null && uri.trim().length() > 0) {
            predicate = CaseDisplayUtil.addPredicate(predicate, "c.cmUri", "=", ":cmUri");
            parameters.put("cmUri", uri);
        }
        if (hostname != null && hostname.trim().length() > 0) {
            predicate = CaseDisplayUtil.addPredicate(predicate, "c.hostName", "=", ":hostName");
            parameters.put("hostName", hostname);
        }
        if (httpPort != null && httpPort.trim().length() > 0) {
            predicate = CaseDisplayUtil.addPredicate(predicate, "c.httpPort", "=", ":httpPort");
            parameters.put("httpPort", httpPort);
        }
        if (httpsPort != null && httpsPort.trim().length() > 0) {
            predicate = CaseDisplayUtil.addPredicate(predicate, "c.httpsPort", "=", ":httpsPort");
            parameters.put("httpsPort", httpsPort);
        }
        deleteQuery.append((CharSequence)predicate);
        CaseDisplayUtil.debugLog("deleteCaseDisplayInfo", "Delete Query Formed for deleting CaseDisplay :" + deleteQuery.toString());
        return persistence.executeUpdateWithQuery(deleteQuery.toString(), parameters);
    }

    public static void insertCaseDisplayInfo(String namespace, String caseArtificatName, String compositeVersion, String partitionName, ICaseMetadataService.FORM_TYPE formType, Collection<TCaseDisplayInfo> caseDisplays) throws CasePersistenceException {
        ICasePersistence persistence = ServicesLocator.getCasePersistence();
        CaseDisplay caseDisplay = null;
        CaseDisplayUtil.debugLog("insertCaseDisplayInfo", "Inserting case display info with\n Case Namespace: " + namespace + "\n Case Artifact: " + caseArtificatName + "\n CompositeVersion: " + compositeVersion + "\n PartitionName: " + partitionName + "\n caseDisplays: " + caseDisplays.size());
        if (caseDisplays == null || caseDisplays.size() == 0) {
            CaseDisplayUtil.debugLog("insertCaseDisplayInfo", "No caseDisplays passed. Nothing to do, returning");
            return;
        }
        for (TCaseDisplayInfo displayInfo : caseDisplays) {
            String applicationName = displayInfo.getApplicationName();
            String formName = displayInfo.getFormName();
            String uri = displayInfo.getUri();
            String hostname = displayInfo.getHostname();
            String httpPort = displayInfo.getHttpPort();
            String httpsPort = displayInfo.getHttpsPort();
            CaseDisplayUtil.debugLog("insertCaseDisplayInfo", "inserting: \n applicationName = " + applicationName + "\nformName = " + formName + "\nuri = " + uri + "\nhostname = " + hostname + "\nhttpPort = " + httpPort + "\nhttpsPort = " + httpsPort);
            caseDisplay = CaseDisplayUtil.transformCaseDisplayInfoToCaseDisplay(displayInfo, namespace, caseArtificatName, compositeVersion, partitionName, formType);
            persistence.persist(caseDisplay);
        }
        CaseDisplayUtil.debugLog("insertCaseDisplayInfo", "Completed.");
    }

    public static int deleteCaseDisplayInfoAcrossPartitions(String namespace, String caseArtifactName, String compositeVersion, ICaseMetadataService.FORM_TYPE formType) throws CasePersistenceException {
        ICasePersistence persistence = ServicesLocator.getCasePersistence();
        StringBuilder deleteQuery = new StringBuilder();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        deleteQuery.append("delete from CaseDisplay c where ");
        deleteQuery.append("c.compositeNamespace = :compositeNamespace ");
        parameters.put("compositeNamespace", namespace);
        deleteQuery.append("and c.cmNamespace = :cmNamespace ");
        parameters.put("cmNamespace", caseArtifactName);
        deleteQuery.append("and c.formType = :formType ");
        parameters.put("formType", formType.toString());
        if (compositeVersion == null) {
            deleteQuery.append("and c.compositeVersion IS NULL");
        } else {
            deleteQuery.append("and c.compositeVersion = :compositeVersion");
            parameters.put("compositeVersion", compositeVersion);
        }
        CaseDisplayUtil.debugLog("deleteCaseDisplayInfoAcrossPartitions", "Delete Query Formed for deleting CaseDisplay across partitions:" + deleteQuery.toString());
        return persistence.executeUpdateWithQuery(deleteQuery.toString(), parameters);
    }

    public static List<TCaseDisplayInfo> getCaseDisplayInfo(String caseDefinitionNamespace, String caseArtifactName, ICaseMetadataService.FORM_TYPE formType, String compositeVersion, String partitionName, String applicationName, String formName) throws CasePersistenceException {
        String METHOD_NAME = "getCaseDisplayInfo";
        CaseDisplayUtil.debugLog("getCaseDisplayInfo", "caseDefinitionNamespace: " + caseDefinitionNamespace + "caseArtifactName: " + caseArtifactName + "formType: " + formType + "compositeVersion: " + compositeVersion + "partitionName: " + partitionName + "applicationName: " + applicationName + "formName: " + formName);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        ICasePersistence persistence = ServicesLocator.getCasePersistence();
        StringBuilder query = new StringBuilder();
        query.append("select c from CaseDisplay c where c.compositeNamespace = :compositeNamespace");
        parameters.put("compositeNamespace", caseDefinitionNamespace);
        query.append(" and c.cmNamespace = :cmNamespace");
        parameters.put("cmNamespace", caseArtifactName);
        query.append(" and c.formType = :formType");
        parameters.put("formType", formType.toString());
        if (compositeVersion == null) {
            query.append(" and c.compositeVersion IS NULL");
        } else {
            query.append(" and c.compositeVersion = :compositeVersion");
            parameters.put("compositeVersion", compositeVersion);
        }
        if (partitionName == null) {
            query.append(" and c.partitionname IS NULL");
        } else {
            query.append(" and c.partitionname = :partitionname");
            parameters.put("partitionname", partitionName);
        }
        if (applicationName != null) {
            query.append(" and c.applicationname = :applicationname");
            parameters.put("applicationname", applicationName);
        }
        if (formName != null) {
            if (DEFAULT_CASE_DISPLAY_FORM_NAME.equals(formName)) {
                query.append(" and ( c.formname IS NULL or c.formname = :formname )");
                parameters.put("formname", formName);
            } else {
                query.append(" and c.formname = :formname");
                parameters.put("formname", formName);
            }
        }
        query.append(" order by c.applicationname asc");
        List caseDisplayList = persistence.findWithQuery(query.toString(), parameters);
        List<TCaseDisplayInfo> caseDisplayInfo = CaseDisplayUtil.transformCaseDisplayToTCaseDisplayInfo(caseDisplayList);
        CaseDisplayUtil.debugLog("getCaseDisplayInfo", "Returning: " + caseDisplayInfo.size());
        return caseDisplayInfo;
    }

    public static List<TCaseDisplayInfo> setCaseDisplayTranslations(Locale locale, String caseDefinitionNamespace, String caseArtifactName, ICaseMetadataService.FORM_TYPE formType, String partitionName, String compositeVersion, List<TCaseDisplayInfo> result) {
        return result;
    }

    public static void deployCaseDisplayInfo(CaseDefinition metadata, String caseArtifactName, ICaseMetadataService.FORM_TYPE formType) {
        String METHOD_NAME = "deployCaseDisplayInfo";
        CaseDisplayUtil.debugLog("deployCaseDisplayInfo", "Deploying CaseDisplayInfo for case deployment: " + metadata.toString());
        ArrayList<TCaseDisplayInfo> entriesToCreate = new ArrayList<TCaseDisplayInfo>();
        HashSet<String> foundForms = new HashSet<String>();
        CaseDisplayUtil.getCaseDisplayInfoFromPlaceholders(metadata, true, true, false, caseArtifactName, formType, foundForms);
        List<TCaseDisplayInfo> entriesToAdd = CaseDisplayUtil.getCaseDisplayInfoFromPlaceholders(metadata, false, true, false, caseArtifactName, formType, foundForms);
        entriesToCreate.addAll(entriesToAdd);
        entriesToAdd = CaseDisplayUtil.getCaseDisplayInfoFromPlaceholders(metadata, true, false, false, caseArtifactName, formType, foundForms);
        entriesToCreate.addAll(entriesToAdd);
        entriesToAdd = CaseDisplayUtil.getCaseDisplayInfoFromPlaceholders(metadata, false, false, false, caseArtifactName, formType, foundForms);
        entriesToCreate.addAll(entriesToAdd);
        try {
            CaseDisplayUtil.insertCaseDisplayInfo(metadata.getNamespace(), caseArtifactName, metadata.getCompositeVersion(), metadata.getApplicationName(), formType, entriesToCreate);
        }
        catch (CasePersistenceException e) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_COMMON, (Severity)Severity.ERRORS, (String)"CaseServiceUtil", (String)"deployCaseDisplayInfo", (String)e.getMessage(), (Throwable)((Object)e));
        }
        CaseDisplayUtil.debugLog("deployCaseDisplayInfo", "Done. Number of new case display entries created: " + entriesToCreate.size());
    }

    public static String getFullFormName(TCaseDisplayInfo info) {
        String applicationName = info.getApplicationName();
        String formName = info.getFormName();
        if (applicationName == null || applicationName.length() == 0) {
            applicationName = WORKLIST_CASE_DISPLAY_APP;
        }
        if (formName == null || formName.length() == 0) {
            formName = DEFAULT_CASE_DISPLAY_FORM_NAME;
        }
        return applicationName + "." + formName;
    }

    private static StringBuilder addPredicate(StringBuilder predicate, String columnName, String operation, String bindName) {
        if (predicate == null) {
            predicate = new StringBuilder();
            predicate.append(columnName + " " + operation + " " + bindName);
        } else {
            predicate.append(" and " + columnName + " " + operation + " " + bindName);
        }
        return predicate;
    }

    private static CaseDisplay transformCaseDisplayInfoToCaseDisplay(TCaseDisplayInfo caseDisplayInfo, String namespace, String caseArtificatName, String compositeVersion, String partitionName, ICaseMetadataService.FORM_TYPE formType) {
        CaseDisplay caseDisplay = new CaseDisplay();
        caseDisplay.setApplicationname(caseDisplayInfo.getApplicationName());
        caseDisplay.setCmUri(caseDisplayInfo.getUri());
        caseDisplay.setFormName(caseDisplayInfo.getFormName());
        caseDisplay.setHostName(caseDisplayInfo.getHostname());
        caseDisplay.setHttpPort(caseDisplayInfo.getHttpPort());
        caseDisplay.setHttpsPort(caseDisplayInfo.getHttpsPort());
        caseDisplay.setCmNamespace(caseArtificatName);
        caseDisplay.setCompositeNamespace(namespace);
        caseDisplay.setCompositeVersion(compositeVersion);
        caseDisplay.setPartitionname(partitionName);
        caseDisplay.setFormType(formType.toString());
        caseDisplay.setSystemString01(CaseServiceUtil.getGUID());
        return caseDisplay;
    }

    private static List<TCaseDisplayInfo> transformCaseDisplayToTCaseDisplayInfo(List caseDisplayList) {
        ArrayList<TCaseDisplayInfo> list = new ArrayList<TCaseDisplayInfo>();
        CaseDisplay caseDisplay = null;
        TCaseDisplayInfo jaxbObj = null;
        ObjectFactory objFactory = new ObjectFactory();
        if (caseDisplayList != null && !caseDisplayList.isEmpty()) {
            for (int i = 0; i < caseDisplayList.size(); ++i) {
                caseDisplay = (CaseDisplay)caseDisplayList.get(i);
                jaxbObj = objFactory.createTCaseDisplayInfo();
                jaxbObj.setApplicationName(caseDisplay.getApplicationname());
                jaxbObj.setFormName(caseDisplay.getFormName());
                jaxbObj.setHostname(caseDisplay.getHostName());
                jaxbObj.setHttpPort(caseDisplay.getHttpPort());
                jaxbObj.setHttpsPort(caseDisplay.getHttpsPort());
                jaxbObj.setUri(caseDisplay.getCmUri());
                list.add(jaxbObj);
            }
        }
        return list;
    }

    private static List<TCaseDisplayInfo> getCaseDisplayInfoFromPlaceholders(CaseDefinition metadata, boolean matchingVersion, boolean matchingPartition, boolean matchingTemplateNS, String caseArtifactName, ICaseMetadataService.FORM_TYPE formType, Set<String> foundForms) {
        String METHOD_NAME = "getCaseDisplayInfoFromPlaceholders";
        CaseDisplayUtil.debugLog("getCaseDisplayInfoFromPlaceholders", "Called with:  matchingVersion=" + matchingVersion + " matchingPartition=" + matchingPartition + " matchingTemplateNS=" + matchingTemplateNS + " caseArtifactName=" + caseArtifactName + " formType=" + formType.name());
        ArrayList<TCaseDisplayInfo> result = new ArrayList<TCaseDisplayInfo>();
        String queryCompositeVersion = null;
        String queryPartitionName = null;
        String queryNamespace = metadata.getNamespace();
        if (matchingVersion) {
            queryCompositeVersion = metadata.getCompositeVersion();
        }
        if (matchingPartition) {
            queryPartitionName = metadata.getApplicationName();
        }
        List<Object> caseDisplayInfoList = new ArrayList();
        try {
            caseDisplayInfoList = CaseDisplayUtil.getCaseDisplayInfo(queryNamespace, caseArtifactName, formType, queryCompositeVersion, queryPartitionName, null, null);
        }
        catch (CasePersistenceException e) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_COMMON, (Severity)Severity.ERRORS, (String)"CaseServiceUtil", (String)"getCaseDisplayInfoFromPlaceholders", (String)e.getMessage(), (Throwable)((Object)e));
        }
        for (TCaseDisplayInfo tCaseDisplayInfo : caseDisplayInfoList) {
            String fullFormName = CaseDisplayUtil.getFullFormName(tCaseDisplayInfo);
            CaseDisplayUtil.debugLog("getCaseDisplayInfoFromPlaceholders", "Found entry for " + fullFormName);
            if (foundForms.contains(fullFormName)) continue;
            CaseDisplayUtil.debugLog("getCaseDisplayInfoFromPlaceholders", "Adding entry for " + fullFormName);
            foundForms.add(fullFormName);
            result.add(tCaseDisplayInfo);
        }
        CaseDisplayUtil.debugLog("getCaseDisplayInfoFromPlaceholders", "Done. Returning result size: " + result.size());
        return result;
    }

    private static void debugLog(String method, String msg) {
        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_COMMON, (Severity)Severity.DEBUG, (String)"CaseServiceUtil", (String)method, (String)msg);
    }
}

