/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.streamservice;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpel.services.workflow.verification.impl.VerificationService;
import oracle.bpel.services.workflow.worklist.servlet.WorklistServletUtil;
import oracle.bpm.casemgmt.CaseIdentifier;
import oracle.bpm.casemgmt.ICaseDocumentStreamService;
import oracle.bpm.casemgmt.ICaseRuleStreamService;
import oracle.bpm.casemgmt.common.logger.CaseLogger;
import oracle.bpm.casemgmt.factory.ServicesLocator;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;
import org.apache.commons.fileupload.DefaultFileItemFactory;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUpload;
import weblogic.servlet.security.Utils;

public class CaseManagementServlet
extends HttpServlet {
    public static String resultPage(String result) {
        return result;
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        request.setCharacterEncoding("utf-8");
        try {
            String component;
            String download = request.getHeader("download");
            if (download == null) {
                download = request.getParameter("download");
            }
            if ((component = request.getParameter("component")) != null && component.equals("CM_RULE")) {
                this.executeRuleRequest(request, response);
            } else if (download != null) {
                CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_COMMON, (Severity)Severity.DEBUG, (String)"downloading...");
                this.downloadFile(request, response);
            } else {
                response.setContentType("text/html");
                PrintWriter writer = response.getWriter();
                String resultString = this.uploadFile(request, response);
                if (resultString.contains("failed")) {
                    response.setStatus(400);
                }
                writer.write(resultString);
                writer.close();
            }
        }
        catch (Exception exc) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_COMMON, (Severity)Severity.ERRORS, (String)((Object)((Object)this)).getClass().getName(), (String)"doPost", (Throwable)exc);
            throw new ServletException((Throwable)exc);
        }
    }

    private String uploadFile(HttpServletRequest request, HttpServletResponse response) {
        String result;
        block11: {
            result = CaseManagementServlet.resultPage("File upload failed due to Exception.");
            try {
                boolean forceUpdate;
                FileUpload upload = new FileUpload((FileItemFactory)new DefaultFileItemFactory());
                InputStream inputStream = null;
                String contentType = null;
                String fileName = null;
                Properties parameters = new Properties();
                if (!FileUpload.isMultipartContent((HttpServletRequest)request)) break block11;
                List items = upload.parseRequest(request);
                Iterator iter = items.iterator();
                for (int size = items.size(); size > 0; --size) {
                    FileItem item = (FileItem)iter.next();
                    String name = item.getFieldName();
                    if (item.isFormField()) {
                        if (name.equals("uploadFile") || name.equals("commitDictionary") || name.equals("saveDictionaryToSandbox")) {
                            parameters.setProperty("operation", name);
                            continue;
                        }
                        parameters.setProperty(name, item.getString());
                        continue;
                    }
                    if (!name.equals("file")) continue;
                    fileName = item.getName();
                    contentType = item.getContentType();
                    inputStream = item.getInputStream();
                }
                String operation = parameters.getProperty("operation");
                String caseId = parameters.getProperty("caseId");
                String permissionTag = parameters.getProperty("permissionTag");
                ICaseRuleStreamService ruleStreamService = ServicesLocator.getCaseRuleStreamService();
                IBPMContext ctx = this.getContext(parameters.getProperty("token"));
                String namespace = parameters.getProperty("namespace");
                String comments = parameters.getProperty("comments");
                boolean bl = forceUpdate = parameters.getProperty("forceUpdate") != null ? Boolean.valueOf(parameters.getProperty("forceUpdate")) : false;
                if (operation == null) {
                    operation = "unknown";
                }
                if (operation.equals("uploadFile")) {
                    ICaseDocumentStreamService caseDocStreamService = ServicesLocator.getCaseDocumentStreamService();
                    CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_COMMON, (Severity)Severity.DEBUG, (String)("caseDocStreamService.uploadDocument(): " + fileName + ", contentType: " + contentType));
                    CaseIdentifier caseIdentifier = new CaseIdentifier(caseId, null, null);
                    boolean isUploaded = false;
                    try {
                        isUploaded = caseDocStreamService.uploadDocument(ctx, caseIdentifier, fileName, contentType, inputStream, comments, permissionTag);
                    }
                    catch (Exception e) {
                        String causedBy = e.getCause() != null ? "\n Caused by: " + e.getCause().getMessage() : "";
                        return CaseManagementServlet.resultPage("failed: " + e.getMessage() + causedBy);
                    }
                    result = isUploaded ? CaseManagementServlet.resultPage("Successfully created document") : CaseManagementServlet.resultPage("File upload failed");
                    return result;
                }
                if (operation.equals("saveDictionaryToSandbox")) {
                    ruleStreamService.saveDictionaryToSandbox(ctx, namespace, inputStream, comments);
                    return CaseManagementServlet.resultPage("Successfully saved the dictionary");
                }
                if (operation.equals("commitDictionary")) {
                    ruleStreamService.commitDictionary(ctx, namespace, inputStream, comments, forceUpdate);
                    return CaseManagementServlet.resultPage("Successfully committed the dictionary");
                }
                return CaseManagementServlet.resultPage("Invalid operation: " + Utils.encodeXSS((String)operation));
            }
            catch (Exception e) {
                CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_COMMON, (Severity)Severity.ERRORS, (String)((Object)((Object)this)).getClass().getName(), (String)"uploadFile", (Throwable)e);
            }
        }
        return result;
    }

    private void downloadFile(HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            String caseId = request.getParameter("caseId");
            String filename = request.getParameter("doc");
            String token = request.getParameter("token");
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_COMMON, (Severity)Severity.DEBUG, (String)("downloadFile(): token: " + token));
            IBPMContext ctx = this.getContext(token);
            ICaseDocumentStreamService caseDocStreamService = ServicesLocator.getCaseDocumentStreamService();
            CaseIdentifier caseIdentifier = new CaseIdentifier(caseId, null, null);
            InputStream inputStream = caseDocStreamService.downloadDocument(ctx, caseIdentifier, filename);
            response.setHeader("Content-Disposition", "attachment; filename=\"" + new String(WorklistServletUtil.escapeHtmlFull((String)filename).getBytes("utf-8"), "8859_1") + "\"");
            ServletOutputStream responseStream = response.getOutputStream();
            byte[] buffer = new byte[512];
            int nbytes = 0;
            if (inputStream == null) {
                String msg = "File: " + Utils.encodeXSS((String)filename) + " - does not exist.";
                response.sendError(301, msg);
                CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_COMMON, (Severity)Severity.DEBUG, (String)("Could not get stream for document: " + filename));
                return;
            }
            while ((nbytes = inputStream.read(buffer)) != -1) {
                responseStream.write(buffer, 0, nbytes);
            }
            inputStream.close();
            responseStream.close();
        }
        catch (Exception e) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_COMMON, (Severity)Severity.ERRORS, (String)((Object)((Object)this)).getClass().getName(), (String)"downloadFile", (Throwable)e);
        }
    }

    private void executeRuleRequest(HttpServletRequest request, HttpServletResponse response) {
        try {
            String methodName = request.getParameter("methodName");
            String namespace = request.getParameter("namespace");
            IBPMContext ctx = this.getContext(request.getParameter("token"));
            ICaseRuleStreamService caseStreamService = ServicesLocator.getCaseRuleStreamService();
            InputStream inputStream = null;
            if ("getDictionaryFromSandbox".equals(methodName)) {
                inputStream = caseStreamService.getDictionaryFromSandbox(ctx, namespace);
            } else if ("getActiveDictionary".equals(methodName)) {
                inputStream = caseStreamService.getActiveDictionary(ctx, namespace);
            }
            response.setHeader("Content-Disposition", "attachment; filename=\"" + new String(WorklistServletUtil.escapeHtmlFull((String)"dictionary").getBytes("utf-8"), "8859_1") + "\"");
            ServletOutputStream responseStream = response.getOutputStream();
            byte[] buffer = new byte[512];
            int nbytes = 0;
            if (inputStream == null) {
                String msg = "Rule Dicitonary for the namespace does not exist.";
                response.sendError(301, msg);
                CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_COMMON, (Severity)Severity.DEBUG, (String)"Could not get stream for dictionary: ");
                return;
            }
            while ((nbytes = inputStream.read(buffer)) != -1) {
                responseStream.write(buffer, 0, nbytes);
            }
            inputStream.close();
            responseStream.close();
        }
        catch (Exception e) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_COMMON, (Severity)Severity.ERRORS, (String)((Object)((Object)this)).getClass().getName(), (String)"executeRuleRequest", (Throwable)e);
        }
    }

    private IBPMContext getContext(String token) throws Exception {
        return (IBPMContext)new VerificationService().getContext(token);
    }
}

