/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.resource;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpel.services.workflow.resource.i18NUtil;
import oracle.bpm.casemgmt.CaseServiceException;
import oracle.bpm.casemgmt.annotations.ValidateContext;
import oracle.bpm.casemgmt.common.logger.CaseLogger;
import oracle.bpm.casemgmt.impl.CaseMetadataCache;
import oracle.bpm.casemgmt.impl.CaseMetadataException;
import oracle.bpm.casemgmt.impl.CaseServiceUtil;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;

public final class Casei18nUtil {
    private static final String CASE_RESOURCE_BUNDLE_NAME = "oracle.bpm.casemgmt.common.resources.i18n.CaseManagementResourceBundle";

    public static String getValue(IBPMContext ctx, String caseDefinitionId, Locale locale, String key, String bundleName) throws CaseServiceException {
        return Casei18nUtil.getValue(ctx, caseDefinitionId, locale, key, bundleName, false);
    }

    public static String getValue(IBPMContext ctx, String caseDefinitionId, Locale locale, String key, String bundleName, boolean isDuringReDeployment) throws CaseServiceException {
        String value = null;
        ResourceBundle systemBundle = null;
        ResourceBundle customBundle = null;
        ResourceBundle caseBundle = null;
        locale = CaseServiceUtil.getLocale(ctx, locale);
        caseBundle = Casei18nUtil.getCaseResourceBundle(ctx, caseDefinitionId, locale, isDuringReDeployment);
        if (caseBundle != null && (value = Casei18nUtil.getValueFromBundle(caseBundle, key)) != null) {
            return value;
        }
        customBundle = Casei18nUtil.getCustomResourceBundle(locale);
        if (customBundle != null && (value = Casei18nUtil.getValueFromBundle(customBundle, key)) != null) {
            return value;
        }
        systemBundle = Casei18nUtil.getSystemResourceBundle(locale, bundleName);
        if (systemBundle != null && (value = Casei18nUtil.getValueFromBundle(systemBundle, key)) != null) {
            return value;
        }
        return value;
    }

    private static ResourceBundle getSystemResourceBundle(Locale locale, String bundleName) {
        if (bundleName == null) {
            return ResourceBundle.getBundle(CASE_RESOURCE_BUNDLE_NAME, locale);
        }
        return ResourceBundle.getBundle(bundleName, locale);
    }

    private static ResourceBundle getCustomResourceBundle(Locale locale) {
        return i18NUtil.getCustomResourceBundle((String)CASE_RESOURCE_BUNDLE_NAME, (Locale)locale);
    }

    @ValidateContext
    private static ResourceBundle getCaseResourceBundle(IBPMContext ctx, String caseDefinitionId, Locale locale, boolean isDuringReDeployment) throws CaseServiceException {
        ResourceBundle bundle = null;
        CaseMetadataCache metadataCache = CaseMetadataCache.getInstance();
        try {
            bundle = metadataCache.getResourceBundle(caseDefinitionId, locale, isDuringReDeployment);
        }
        catch (CaseMetadataException e) {
            CaseServiceException se = new CaseServiceException(72802, new Object[]{caseDefinitionId, locale.toString()}, (Throwable)((Object)e));
            throw se;
        }
        return bundle;
    }

    private static String getValueFromBundle(ResourceBundle bundle, String key) {
        String value = null;
        try {
            value = bundle.getString(key);
        }
        catch (MissingResourceException misRsrcEx) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CASEMANAGEMENT, (Severity)Severity.DEBUG, (String)Casei18nUtil.class.getClass().getName(), (String)("getValue() for" + key), (Throwable)misRsrcEx);
        }
        return value;
    }
}

