/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.persistence.instance;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.persistence.Query;
import oracle.bpm.casemgmt.CaseList;
import oracle.bpm.casemgmt.common.logger.CaseLogger;
import oracle.bpm.casemgmt.impl.CaseServiceUtil;
import oracle.bpm.casemgmt.persistence.CasePersistence;
import oracle.bpm.casemgmt.persistence.CasePersistenceException;
import oracle.bpm.casemgmt.persistence.instance.ICaseInstancePersistence;
import oracle.bpm.casemgmt.persistence.model.Case;
import oracle.bpm.casemgmt.persistence.model.CaseData;
import oracle.bpm.casemgmt.persistence.model.CaseObjectUtil;
import oracle.bpm.casemgmt.persistence.model.ICaseConstants;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;

public class CaseInstancePersistence
extends CasePersistence
implements ICaseInstancePersistence {
    @Override
    public Case findCaseByCaseId(String caseId) throws CasePersistenceException {
        Case caseInstance = null;
        try {
            if (caseId != null && !caseId.equals("*")) {
                CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)("[CaseInstancePersistence] findCaseByCaseId() " + caseId));
                List queryResult = this.findWithNamedQuery("Case.findByCaseId", "caseId", caseId);
                if (queryResult.size() > 0) {
                    caseInstance = (Case)queryResult.get(0);
                }
            } else if (caseId != null && caseId.equals("*")) {
                CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)"[CaseInstancePersistence] findAll");
                List queryResult = this.findWithNamedQuery("Case.findAll");
                if (queryResult != null && queryResult.size() > 0) {
                    caseInstance = (Case)queryResult.get(0);
                }
            }
        }
        catch (CasePersistenceException e) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"findCaseByCaseId", (Throwable)((Object)e));
            throw e;
        }
        return caseInstance;
    }

    @Override
    public Case findCaseByCaseNumber(long caseNumber) throws CasePersistenceException {
        Case caseInstance = null;
        try {
            if (caseNumber > 0L) {
                CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)("[CaseInstancePersistence] findCaseByCaseNumber() " + caseNumber));
                List queryResult = this.findWithNamedQuery("Case.findByCaseNumber", ICaseConstants.caseHeaderAttributes.caseNumber.name(), caseNumber);
                if (queryResult != null && queryResult.size() > 0) {
                    caseInstance = (Case)queryResult.get(0);
                }
            }
        }
        catch (CasePersistenceException e) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"findCaseByCaseNumber", (Throwable)((Object)e));
            throw e;
        }
        return caseInstance;
    }

    @Override
    public Case findCaseByIdentificationKey(String identificationKey) throws CasePersistenceException {
        Case caseInstance = null;
        try {
            if (identificationKey != null && identificationKey.trim().length() > 0) {
                CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)("[CaseInstancePersistence] findByIdentificationKey() " + identificationKey));
                List queryResult = this.findWithNamedQuery("Case.findByIdentificationKey", ICaseConstants.caseHeaderAttributes.identificationKey.name(), identificationKey);
                if (queryResult != null && queryResult.size() > 0) {
                    caseInstance = (Case)queryResult.get(0);
                }
            }
        }
        catch (CasePersistenceException e) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"findByIdentificationKey", (Throwable)((Object)e));
            throw e;
        }
        return caseInstance;
    }

    @Override
    public CaseList queryCase(String caseQuery, Map<String, Object> queryParameters, int pageSize, int pageNumber) throws CasePersistenceException {
        CaseList caseList = null;
        long totalNumberOfCases = -1L;
        try {
            if (caseQuery != null) {
                CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)("[CaseInstancePersistence] queryCase() " + caseQuery));
                int firstResult = pageSize > 0 ? (pageNumber - 1) * pageSize : 0;
                List cases = null;
                if (firstResult == 0 && pageSize == 0) {
                    cases = this.findWithQuery(caseQuery, queryParameters, firstResult, pageSize);
                    totalNumberOfCases = cases.size();
                } else {
                    int caseInstanceIndex = caseQuery.indexOf(ICaseConstants.caseInstance);
                    String caseCountQuery = caseQuery.substring(0, caseInstanceIndex) + "count(" + ICaseConstants.caseInstance + ")" + caseQuery.substring(caseInstanceIndex + ICaseConstants.caseInstance.length());
                    totalNumberOfCases = this.countWithQuery(caseCountQuery, queryParameters);
                    cases = this.findWithQuery(caseQuery, queryParameters, firstResult, pageSize);
                }
                CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)("[CaseInstancePersistence]Query returned " + cases.size() + " of cases"));
                int totalNumberOfPages = 0;
                if (pageSize > 0) {
                    totalNumberOfPages = (int)totalNumberOfCases / pageSize;
                    int remainder = (int)totalNumberOfCases % pageSize;
                    if (remainder > 0) {
                        ++totalNumberOfPages;
                    }
                }
                caseList = new CaseList((int)totalNumberOfCases, pageSize, totalNumberOfPages, pageNumber, cases);
            }
        }
        catch (Exception e) {
            CasePersistenceException cpe = new CasePersistenceException(73006, new Object[0], e);
            throw cpe;
        }
        return caseList;
    }

    @Override
    public CaseData findCaseData(String caseDataName, String caseId, boolean readOnly) throws CasePersistenceException {
        if (caseDataName == null || caseDataName.length() == 0) {
            return null;
        }
        try {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)("[CaseInstancePersistence] findCaseDataByName: " + caseDataName));
            Query query = this.getEntityManager().createNamedQuery("CaseData.findByCaseDataName");
            query.setParameter("caseDataName", (Object)caseDataName);
            query.setParameter("case_id", (Object)caseId);
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)("[CaseInstancePersistence] Query: " + query));
            List caseDataList = query.getResultList();
            if (caseDataList == null) {
                return null;
            }
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)("[CaseInstancePersistence] Query returned " + caseDataList.size() + " of CaseData"));
            if (caseDataList.size() == 0) {
                return null;
            }
            if (readOnly) {
                if (caseDataList.get(0) == null) {
                    return null;
                }
                Case caseInstance = this.findCaseByCaseId(caseId);
                return CaseObjectUtil.getCaseDataClone((Case)caseInstance, (CaseData)((CaseData)caseDataList.get(0)));
            }
            return (CaseData)caseDataList.get(0);
        }
        catch (Exception e) {
            CasePersistenceException cpe = new CasePersistenceException(73006, new Object[0], e);
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"findCaseData", (Throwable)((Object)cpe));
            throw cpe;
        }
    }

    @Override
    public void markInstancesAsStale(String caseDefinitionId) throws CasePersistenceException {
        String queryString = "update CaseHeader ch  set ch.state = :state,ch.stateDisplayName = :displayName where ch.caseDefinitionId = :definitionId";
        String queryStringWithoutDisplayName = "update CaseHeader ch  set ch.state = :state where ch.caseDefinitionId = :definitionId";
        try {
            Locale locale = Locale.getDefault();
            String state = ICaseConstants.CaseState.STALE.name();
            String displayName = CaseServiceUtil.getTranslatedValue(locale, state);
            if (displayName == null) {
                Query query = this.getEntityManager().createQuery(queryStringWithoutDisplayName);
                query.setParameter("state", (Object)state);
                query.setParameter("definitionId", (Object)caseDefinitionId);
                query.executeUpdate();
            } else {
                Query query = this.getEntityManager().createQuery(queryString);
                query.setParameter("state", (Object)state);
                query.setParameter("displayName", (Object)displayName);
                query.setParameter("definitionId", (Object)caseDefinitionId);
                query.executeUpdate();
            }
        }
        catch (Exception e) {
            CasePersistenceException exc = new CasePersistenceException(73002, new Object[]{queryString}, e);
            throw exc;
        }
    }

    @Override
    public void updateCaseCompositeVersion(String caseId, String newCaseDefinitionId, String newCompositeDN, String newCompositeVersion, String newApplicationName, String newCompositeName) throws CasePersistenceException {
        String queryString = "update CaseHeader ch set ch.caseDefinitionId = :definitionId,ch.compositeDn = :compositeDN,ch.compositeName = :compositeName,ch.compositeVersion = :compositeVersion,ch.applicationName = :applicationName where ch.case_id = :caseId";
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("definitionId", newCaseDefinitionId);
        parameters.put("compositeDN", newCompositeDN);
        parameters.put("compositeName", newCompositeName);
        parameters.put("compositeVersion", newCompositeVersion);
        parameters.put("applicationName", newApplicationName);
        parameters.put("caseId", caseId);
        this.executeUpdateWithQuery(queryString, parameters);
    }
}

