/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.persistence.event;

import java.util.HashMap;
import java.util.List;
import oracle.bpm.casemgmt.CaseObjectsList;
import oracle.bpm.casemgmt.common.logger.CaseLogger;
import oracle.bpm.casemgmt.event.CaseEventUtil;
import oracle.bpm.casemgmt.metadata.event.model.TEventType;
import oracle.bpm.casemgmt.persistence.CasePersistence;
import oracle.bpm.casemgmt.persistence.CasePersistenceException;
import oracle.bpm.casemgmt.persistence.event.ICaseEventPersistence;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;

public class CaseEventPersistence
extends CasePersistence
implements ICaseEventPersistence {
    @Override
    public CaseObjectsList findCaseEvent(String caseId, TEventType eventType, String eventSearchString, String updatedBy, int pageSize, int pageNumber) throws CasePersistenceException {
        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_EVENT, (Severity)Severity.DEBUG, (String)("CaseEventPersistence.findCaseEvent(): caseId: " + caseId + ", eventType: " + eventType + ", updatedBy: " + updatedBy + ", pageSize: " + pageSize + ", pageNumber: " + pageNumber));
        if (pageSize == 0) {
            pageSize = 50;
        }
        List caseEvents = null;
        long totalNumberOfCaseEvents = -1L;
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        String queryString = "select o from CaseEvent o ";
        String objectCountQueryString = "select count(o) from CaseEvent o ";
        String whereClause = "";
        if (caseId != null && !caseId.equals("%")) {
            whereClause = this.andAppend(whereClause, "o.case_id = :case_id");
            parameters.put("case_id", caseId);
        }
        if (eventType != null && !eventType.equals((Object)"%")) {
            whereClause = this.andAppend(whereClause, "o.event_type = :event_type");
            parameters.put("event_type", eventType);
        }
        if (eventSearchString != null && !eventSearchString.equals("%")) {
            block8: for (CaseEventUtil.CaseEventStringSearchField searchStringField : CaseEventUtil.CaseEventStringSearchField.values()) {
                switch (searchStringField) {
                    case object_display_name: {
                        whereClause = whereClause + " and (o.object_display_name like '%" + eventSearchString + "%'";
                        continue block8;
                    }
                    case case_id: {
                        if (caseId != null && !caseId.equals("%")) continue block8;
                        whereClause = whereClause + " or o.case_id like '%" + eventSearchString + "%'";
                        continue block8;
                    }
                    case updated_by_display_name: {
                        whereClause = whereClause + " or o.updated_by_display_name like '%" + eventSearchString + "%'";
                        continue block8;
                    }
                    case updated_date: {
                        continue block8;
                    }
                }
            }
            whereClause = whereClause + ")";
        }
        if (updatedBy != null && !updatedBy.equals("%")) {
            whereClause = this.andAppend(whereClause, "o.updated_by = :updated_by");
            parameters.put("updated_by", updatedBy);
        }
        if (!whereClause.equals("")) {
            queryString = queryString + " where " + whereClause;
            objectCountQueryString = objectCountQueryString + " where " + whereClause;
        }
        queryString = queryString + " order by o.updated_date desc";
        try {
            int firstResult;
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_EVENT, (Severity)Severity.DEBUG, (String)("CaseEventPersistence.findCaseEvent(): query = " + queryString));
            int n = firstResult = pageSize > 0 ? (pageNumber - 1) * pageSize : 0;
            if (firstResult == 0 && pageSize == 0) {
                caseEvents = this.findWithQuery(queryString, parameters, firstResult, pageSize);
                totalNumberOfCaseEvents = caseEvents.size();
            } else {
                totalNumberOfCaseEvents = this.countWithQuery(objectCountQueryString, parameters);
                caseEvents = this.findWithQuery(queryString, parameters, firstResult, pageSize);
            }
        }
        catch (CasePersistenceException e) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_EVENT, (Severity)Severity.ERRORS, (String)this.getClass().getName(), (String)"findCaseEvent", (Throwable)((Object)e));
            throw e;
        }
        int totalNumberOfPages = 0;
        if (pageSize > 0) {
            totalNumberOfPages = (int)totalNumberOfCaseEvents / pageSize;
            int remainder = (int)totalNumberOfCaseEvents % pageSize;
            if (remainder > 0) {
                ++totalNumberOfPages;
            }
        }
        CaseObjectsList caseObjectsList = new CaseObjectsList((int)totalNumberOfCaseEvents, pageSize, totalNumberOfPages, pageNumber, caseEvents);
        return caseObjectsList;
    }

    @Override
    public void migrateCaseActivityEvent(String caseId, String oldDefinitionId, String newDefinitionId) throws CasePersistenceException {
        String queryString = "update CaseEvent e set e.object_name = :newDefinitionId where e.case_id = :caseId and e.object_name = :oldDefinitionId";
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("newDefinitionId", newDefinitionId);
        parameters.put("caseId", caseId);
        parameters.put("oldDefinitionId", oldDefinitionId);
        this.executeUpdateWithQuery(queryString, parameters);
    }

    private String andAppend(String string1, String string2) {
        return "".equals(string1) ? string2 : string1 + " and " + string2;
    }
}

