/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.persistence.caserule;

import java.util.HashMap;
import java.util.List;
import javax.persistence.Query;
import oracle.bpm.casemgmt.caserule.model.CaseRule;
import oracle.bpm.casemgmt.caserule.model.CaseRuleEdit;
import oracle.bpm.casemgmt.common.logger.CaseLogger;
import oracle.bpm.casemgmt.persistence.CasePersistence;
import oracle.bpm.casemgmt.persistence.CasePersistenceException;
import oracle.bpm.casemgmt.persistence.caserule.ICaseRulePersistance;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;

public class CaseRulePersistance
extends CasePersistence
implements ICaseRulePersistance {
    private static final String CLASS_NAME = "CaseRulePersistance";

    @Override
    public CaseRuleEdit findCaseRuleByUser(String user, String namespace, String tenantId) throws CasePersistenceException {
        String METHODNAME = "findCaseRuleByUser";
        CaseRuleEdit caseRule = null;
        try {
            if (user != null && user.trim().length() > 0 && namespace != null && namespace.trim().length() > 0) {
                this.debugLog("findCaseRuleByUser", "user = " + user + " namespace = " + namespace + "tenantId = " + tenantId);
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("lockedBy", user);
                params.put("namespace", namespace);
                List list = this.findWithNamedQuery("CaseRuleEdit.findByUser", params);
                if (list != null && !list.isEmpty()) {
                    caseRule = (CaseRuleEdit)list.get(0);
                }
            }
        }
        catch (CasePersistenceException e) {
            e.printStackTrace();
            throw e;
        }
        return caseRule;
    }

    @Override
    public CaseRule findActiveCaseDictionary(String namespace, String tenantId) throws CasePersistenceException {
        String METHODNAME = "findActiveCaseDictionary";
        CaseRule rule = null;
        String sql = "select o from CaseRule o where o.namespace = ?1 and o.isActive = 'T'";
        try {
            Query query = this.getEntityManager().createQuery(sql);
            query.setParameter(1, (Object)namespace);
            List result = query.getResultList();
            if (result != null && !result.isEmpty()) {
                rule = (CaseRule)result.get(0);
            }
        }
        catch (Exception e) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_RULES, (Severity)Severity.ERRORS, (String)CLASS_NAME, (String)"findActiveCaseDictionary", (Throwable)e);
            CasePersistenceException exc = new CasePersistenceException(73004, new Object[]{sql}, e);
        }
        return rule;
    }

    private void debugLog(String methodName, String message) {
        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_RULES, (Severity)Severity.DEBUG, (String)CLASS_NAME, (String)methodName, (String)message);
    }
}

