/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.persistence.activity;

import java.util.HashMap;
import java.util.List;
import oracle.bpm.casemgmt.caseactivity.model.CaseActivityDefinition;
import oracle.bpm.casemgmt.caseactivity.model.CaseActivityInstance;
import oracle.bpm.casemgmt.caseactivity.model.CaseActivityInstancePK;
import oracle.bpm.casemgmt.common.logger.CaseLogger;
import oracle.bpm.casemgmt.factory.ServicesLocator;
import oracle.bpm.casemgmt.persistence.CasePersistence;
import oracle.bpm.casemgmt.persistence.CasePersistenceException;
import oracle.bpm.casemgmt.persistence.ICasePersistence;
import oracle.bpm.casemgmt.persistence.activity.ICaseActivityPersistence;
import oracle.bpm.casemgmt.persistence.model.ICaseConstants;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;

public class CaseActivityPersistence
extends CasePersistence
implements ICaseActivityPersistence {
    private static final long serialVersionUID = 1L;

    @Override
    public List<CaseActivityDefinition> getAllManualActivitiesForCategory(String categoryName) throws CasePersistenceException {
        String methodName = "getAllManualActivitiesForCategory";
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("categoryName", categoryName);
        List activities = this.findWithNamedQuery("CaseActivityDefinition.findAllManualActivitiesForCategory", parameters);
        this.logCaseActivities(methodName, activities, "All Manual Activities For Category for category name:" + categoryName);
        return activities;
    }

    @Override
    public List<CaseActivityDefinition> getAllInstanceActivities(String caseId) throws CasePersistenceException {
        String methodName = "getAllInstanceActivities";
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("caseId", caseId);
        List activities = this.findWithQuery("select o from CaseActivityInstance i JOIN i.caseActivityDefinition o where o.isManual = 'Y' and i.caseId = :caseId", parameters);
        this.logCaseActivities(methodName, activities, "Get all instance activities for case id:" + caseId);
        return activities;
    }

    @Override
    public List<CaseActivityDefinition> getAllManualActivitiesWithoutAssociations() throws CasePersistenceException {
        String methodName = "getAllManualActivitiesWithoutAssociations";
        List activities = this.findWithNamedQuery("CaseActivityDefinition.findAllManualActivitiesWithoutAssociations");
        this.logCaseActivities(methodName, activities, "Get all manual activities without associations");
        return activities;
    }

    @Override
    public List<CaseActivityDefinition> getAllManualActivitiesForCase(String caseDefinitionId) throws CasePersistenceException {
        String methodName = "getAllManualActivitiesForCase";
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("caseDefinitionId", caseDefinitionId);
        List activities = this.findWithNamedQuery("CaseActivityDefinition.findAllManualActivitiesForCase", parameters);
        this.logCaseActivities(methodName, activities, "Get All Manual Activities for case with case definition id:" + caseDefinitionId);
        return activities;
    }

    @Override
    public void deleteCaseActivityInstance(String caseId, String caseActivityDefinitionId) throws CasePersistenceException {
        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_ACTIVITY, (Severity)Severity.DEBUG, (String)("comes into delete case activity instance for:" + caseActivityDefinitionId + ":" + caseId));
        CaseActivityInstancePK key = new CaseActivityInstancePK(caseActivityDefinitionId, caseId);
        CaseActivityInstance instance = this.find(CaseActivityInstance.class, key);
        if (instance != null) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_ACTIVITY, (Severity)Severity.DEBUG, (String)"Instance found for deletion");
            this.delete(CaseActivityInstance.class, key);
        }
    }

    @Override
    public List<CaseActivityDefinition> getAllUninvokableRequiredActivities(String caseId) throws CasePersistenceException {
        String methodName = "getAllUninvokableRequiredActivities";
        ICasePersistence persistence = ServicesLocator.getCasePersistence();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("caseId", caseId);
        List activities = persistence.findWithQuery("select o from CaseActivityDefinition o where o.isRequired = 'Y' and  o.isConditional = 'Y' and o.isManual = 'Y'  and o.definitionId NOT IN ( select i.activityDefinitionId from CaseActivityInstance i  where i.caseId = :caseId )", parameters);
        this.makeActivitiesUnavailable(activities);
        this.logCaseActivities(methodName, activities, "Get all uninvokable activities for case id:" + caseId);
        return activities;
    }

    private void makeActivitiesUnavailable(List<CaseActivityDefinition> activities) {
        for (CaseActivityDefinition activity : activities) {
            activity.setState(ICaseConstants.ActivityFilterType.UNAVAILABLE.toString());
        }
    }

    private void debugLog(String methodName, String message) {
        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_ACTIVITY, (Severity)Severity.DEBUG, (String)("ClassName:" + this.getClass().getName() + "\n" + "MethodName:" + methodName + "\n" + "Message:\n" + message + "\n"));
    }

    private void logCaseActivities(String methodName, List<CaseActivityDefinition> caseActivities, String message) {
        if (caseActivities == null) {
            return;
        }
        this.debugLog(methodName, message);
        this.debugLog(methodName, "Case Activity List count:" + caseActivities.size());
        for (CaseActivityDefinition caseActivity : caseActivities) {
            this.logCaseActivity(methodName, caseActivity, null);
        }
    }

    private void logCaseActivity(String methodName, CaseActivityDefinition caseActivity, String message) {
        String msg = message + "\n" + "CaseActivityDefinition for :" + caseActivity.getName() + "\n" + "Definition Id:" + caseActivity.getDefinitionId() + "\n" + "Is custom activity:" + caseActivity.getIsCustom() + "\n" + "Is global:" + caseActivity.getIsGlobal() + "\n" + "Is case specific:" + caseActivity.getIsCaseSpecific() + "\n" + "Is conditional:" + caseActivity.getIsConditional() + "\n" + "Required:" + caseActivity.getIsRequired() + "\n" + "Repeatable:" + caseActivity.getIsRepeatable() + "\n" + "Manual:" + caseActivity.getIsManual() + "\n" + "State:" + caseActivity.getState() + "\n" + "Class Name:" + caseActivity.getClassName() + "\n" + "Type: " + caseActivity.getType() + "\n" + "Relevance:" + caseActivity.getRelevance().toString() + "\n";
        this.debugLog(methodName, msg);
    }
}

