/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.persistence;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import oracle.bpm.casemgmt.common.logger.CaseLogger;
import oracle.bpm.casemgmt.factory.ServicesLocator;
import oracle.bpm.casemgmt.persistence.CasePersistenceException;
import oracle.bpm.casemgmt.persistence.ICasePersistence;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;

public class CasePersistence
implements ICasePersistence,
Serializable {
    @PersistenceContext(unitName="casemgmt_persistence_unit", name="persistence/casemgmt")
    private EntityManager em;
    public static final String CASEMGMT_PERSISTENCE_UNIT = "casemgmt_persistence_unit";
    public static final String CASEMGMT_PERSISTENCE_NAME = "persistence/casemgmt";

    public void setEntityManager(EntityManager entityManager) {
        this.em = entityManager;
    }

    @Override
    public <T> T persist(T t) throws CasePersistenceException {
        try {
            EntityManager em = this.getEntityManager();
            em.persist(t);
            em.flush();
            em.refresh(t);
            em.clear();
            return t;
        }
        catch (Exception e) {
            CasePersistenceException exc = new CasePersistenceException(73000, new Object[]{t.getClass().getName()}, e);
            throw exc;
        }
    }

    @Override
    public <T> T update(T t) throws CasePersistenceException {
        try {
            EntityManager em = this.getEntityManager();
            t = em.merge(t);
            em.flush();
            em.refresh(t);
            em.clear();
            return (T)t;
        }
        catch (Exception e) {
            CasePersistenceException exc = new CasePersistenceException(73001, new Object[]{t.getClass().getName()}, e);
            throw exc;
        }
    }

    @Override
    public void delete(Class type, Object id) throws CasePersistenceException {
        EntityManager em = this.getEntityManager();
        try {
            Object ref = em.getReference(type, id);
            em.remove(ref);
            em.flush();
        }
        catch (Exception e) {
            String idString = id != null ? id.toString() : null;
            CasePersistenceException exc = new CasePersistenceException(73003, new Object[]{idString, type.getClass().getName()}, e);
            throw exc;
        }
    }

    @Override
    public int executeUpdateWithNamedQuery(String namedQueryName) throws CasePersistenceException {
        try {
            int result = this.getEntityManager().createNamedQuery(namedQueryName).executeUpdate();
            this.getEntityManager().flush();
            return result;
        }
        catch (Exception e) {
            CasePersistenceException exc = new CasePersistenceException(73002, new Object[]{namedQueryName}, e);
            throw exc;
        }
    }

    @Override
    public int executeUpdateWithNamedQuery(String namedQueryName, String paramName, Object paramValue) throws CasePersistenceException {
        try {
            int result = this.getEntityManager().createNamedQuery(namedQueryName).setParameter(paramName, paramValue).executeUpdate();
            this.getEntityManager().flush();
            return result;
        }
        catch (Exception e) {
            CasePersistenceException exc = new CasePersistenceException(73002, new Object[]{namedQueryName}, e);
            throw exc;
        }
    }

    @Override
    public int executeUpdateWithQuery(String queryString) throws CasePersistenceException {
        try {
            Query query = null;
            query = this.getEntityManager().createQuery(queryString);
            int result = query.executeUpdate();
            this.getEntityManager().flush();
            return result;
        }
        catch (Exception e) {
            CasePersistenceException exc = new CasePersistenceException(73002, new Object[]{queryString}, e);
            throw exc;
        }
    }

    @Override
    public int executeUpdateWithQuery(String queryString, Map<String, Object> parameters) throws CasePersistenceException {
        try {
            Set<Map.Entry<String, Object>> rawParameters = parameters.entrySet();
            Query query = null;
            query = this.getEntityManager().createQuery(queryString);
            for (Map.Entry<String, Object> entry : rawParameters) {
                query.setParameter(entry.getKey(), entry.getValue());
            }
            int result = query.executeUpdate();
            this.getEntityManager().flush();
            return result;
        }
        catch (Exception e) {
            CasePersistenceException exc = new CasePersistenceException(73002, new Object[]{queryString}, e);
            throw exc;
        }
    }

    @Override
    public List findWithNamedQuery(String namedQueryName) throws CasePersistenceException {
        try {
            return this.getEntityManager().createNamedQuery(namedQueryName).getResultList();
        }
        catch (Exception e) {
            CasePersistenceException exc = new CasePersistenceException(73004, new Object[]{namedQueryName}, e);
            throw exc;
        }
    }

    @Override
    public List findWithNamedQuery(String namedQueryName, String paramName, Object paramValue) throws CasePersistenceException {
        List resultList = null;
        try {
            Query query = this.getEntityManager().createNamedQuery(namedQueryName);
            if (query != null) {
                resultList = query.setParameter(paramName, paramValue).getResultList();
            }
            return resultList;
        }
        catch (Exception e) {
            CasePersistenceException exc = new CasePersistenceException(73004, new Object[]{namedQueryName}, e);
            throw exc;
        }
    }

    @Override
    public <T> T find(Class<T> type, Object id) throws CasePersistenceException {
        try {
            return (T)this.getEntityManager().find(type, id);
        }
        catch (Exception e) {
            String idString = id != null ? id.toString() : null;
            CasePersistenceException exc = new CasePersistenceException(73005, new Object[]{idString, type.getClass().getName()}, e);
            throw exc;
        }
    }

    @Override
    public List findWithNamedQuery(String namedQueryName, Map<String, Object> parameters) throws CasePersistenceException {
        return this.findWithNamedQuery(namedQueryName, parameters, 0);
    }

    @Override
    public List findWithNamedQuery(String queryName, int resultLimit) throws CasePersistenceException {
        try {
            return this.getEntityManager().createNamedQuery(queryName).setMaxResults(resultLimit).getResultList();
        }
        catch (Exception e) {
            CasePersistenceException exc = new CasePersistenceException(73004, new Object[]{queryName}, e);
            throw exc;
        }
    }

    @Override
    public <T> List<T> findByNativeQuery(String sql, Class<T> type) throws CasePersistenceException {
        try {
            return this.getEntityManager().createNativeQuery(sql, type).getResultList();
        }
        catch (Exception e) {
            CasePersistenceException exc = new CasePersistenceException(73004, new Object[]{sql}, e);
            throw exc;
        }
    }

    @Override
    public List findWithQuery(String queryString, Map<String, Object> parameters) throws CasePersistenceException {
        return this.findWithQuery(queryString, parameters, 0, 0);
    }

    @Override
    public List findWithQuery(String queryString, int resultLimit) throws CasePersistenceException {
        try {
            return this.getEntityManager().createNamedQuery(queryString).setMaxResults(resultLimit).getResultList();
        }
        catch (Exception e) {
            CasePersistenceException exc = new CasePersistenceException(73004, new Object[]{queryString}, e);
            throw exc;
        }
    }

    @Override
    public List findWithNamedQuery(String namedQueryName, Map<String, Object> parameters, int resultLimit) throws CasePersistenceException {
        try {
            Set<Map.Entry<String, Object>> rawParameters = parameters.entrySet();
            Query query = this.getEntityManager().createNamedQuery(namedQueryName);
            if (resultLimit > 0) {
                query.setMaxResults(resultLimit);
            }
            for (Map.Entry<String, Object> entry : rawParameters) {
                query.setParameter(entry.getKey(), entry.getValue());
            }
            return query.getResultList();
        }
        catch (Exception e) {
            CasePersistenceException exc = new CasePersistenceException(73004, new Object[]{namedQueryName}, e);
            throw exc;
        }
    }

    @Override
    public List findWithQuery(String queryString) throws CasePersistenceException {
        List resultList = null;
        try {
            Query query = this.getEntityManager().createQuery(queryString);
            if (query != null) {
                resultList = query.getResultList();
            }
            return resultList;
        }
        catch (Exception e) {
            CasePersistenceException exc = new CasePersistenceException(73004, new Object[]{queryString}, e);
            throw exc;
        }
    }

    @Override
    public List findWithQuery(String queryString, Map<String, Object> parameters, int firstResult, int resultLimit) throws CasePersistenceException {
        try {
            Set<Map.Entry<String, Object>> rawParameters = parameters.entrySet();
            Query query = this.getEntityManager().createQuery(queryString);
            if (firstResult > 0) {
                query.setFirstResult(firstResult);
            }
            if (resultLimit > 0) {
                query.setMaxResults(resultLimit);
            }
            for (Map.Entry<String, Object> entry : rawParameters) {
                query.setParameter(entry.getKey(), entry.getValue());
            }
            return query.getResultList();
        }
        catch (Exception e) {
            CasePersistenceException exc = new CasePersistenceException(73004, new Object[]{queryString}, e);
            throw exc;
        }
    }

    @Override
    public long countWithQuery(String countQueryString, Map<String, Object> parameters) throws CasePersistenceException {
        try {
            Set<Map.Entry<String, Object>> rawParameters = parameters.entrySet();
            Query query = this.getEntityManager().createQuery(countQueryString);
            for (Map.Entry<String, Object> entry : rawParameters) {
                query.setParameter(entry.getKey(), entry.getValue());
            }
            return (Long)query.getSingleResult();
        }
        catch (Exception e) {
            CasePersistenceException exc = new CasePersistenceException(73004, new Object[]{countQueryString}, e);
            throw exc;
        }
    }

    public EntityManager getEntityManager() {
        if (this.em != null) {
            return this.em;
        }
        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_INSTANCE, (Severity)Severity.DEBUG, (String)"CasePersistence.getEntityManager():");
        EntityManager entityManager = ServicesLocator.getEntityManagerFactory().getEntityManager();
        return entityManager;
    }
}

