/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.permission;

import java.security.Permission;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpm.casemgmt.CaseDocumentObject;
import oracle.bpm.casemgmt.CaseIdentifier;
import oracle.bpm.casemgmt.CaseServiceException;
import oracle.bpm.casemgmt.factory.ServicesLocator;
import oracle.bpm.casemgmt.metadata.Case.model.CaseMetadata;
import oracle.bpm.casemgmt.metadata.Case.model.TPermissionTag;
import oracle.bpm.casemgmt.metadata.common.model.TActionEnum;
import oracle.bpm.casemgmt.metadata.common.model.TCaseObjectEnum;
import oracle.bpm.casemgmt.permission.CasePermission;
import oracle.bpm.casemgmt.persistence.model.Case;
import oracle.bpm.casemgmt.persistence.model.CaseData;
import oracle.bpm.casemgmt.persistence.model.CaseEvent;
import oracle.bpm.casemgmt.persistence.model.CaseHeader;
import oracle.bpm.casemgmt.persistence.model.CaseMilestone;
import oracle.bpm.casemgmt.persistence.model.CaseStakeHolder;
import oracle.bpm.casemgmt.persistence.model.Comment;
import oracle.bpm.casemgmt.persistence.model.DatabaseDocument;
import oracle.bpm.casemgmt.persistence.model.ICaseConstants;
import oracle.bpm.services.common.exception.BPMException;
import oracle.bpm.services.internal.InternalBPMContext;

public class PermissionUtil {
    private static final String DELIMIT = ".";
    private static final String ROLE_SUFFIX = "Role";
    static final String PROCESS_ROLES_APP = "OracleBPMProcessRolesApp";

    public static ICaseConstants.CaseObjectType getObjectType(Object caseObject) {
        if (caseObject instanceof Case) {
            return ICaseConstants.CaseObjectType.CASE;
        }
        if (caseObject instanceof CaseHeader) {
            return ICaseConstants.CaseObjectType.HEADER;
        }
        if (caseObject instanceof Comment) {
            return ICaseConstants.CaseObjectType.COMMENT;
        }
        if (caseObject instanceof CaseMilestone) {
            return ICaseConstants.CaseObjectType.MILESTONE;
        }
        if (caseObject instanceof CaseStakeHolder) {
            return ICaseConstants.CaseObjectType.STAKEHOLDER;
        }
        if (caseObject instanceof CaseData) {
            return ICaseConstants.CaseObjectType.DATA;
        }
        if (caseObject instanceof CaseDocumentObject) {
            return ICaseConstants.CaseObjectType.DOCUMENT;
        }
        if (caseObject instanceof DatabaseDocument) {
            return ICaseConstants.CaseObjectType.DOCUMENT;
        }
        if (caseObject instanceof CaseEvent) {
            return ICaseConstants.CaseObjectType.EVENT;
        }
        throw new IllegalArgumentException("Unknown type: " + caseObject.getClass().getName());
    }

    static String getStakeHolderAppRoleName(String caseName, String logicalRoleName) {
        return caseName + DELIMIT + logicalRoleName;
    }

    static String getStakeHolderPermissionName(String caseName, TCaseObjectEnum caseObjectType) {
        return caseName + DELIMIT + caseObjectType.value();
    }

    static String getTagPermissionName(String caseName, TPermissionTag permissionTag, TCaseObjectEnum caseObjectType) {
        return caseName + DELIMIT + PermissionUtil.getPermissionTagNameString(permissionTag) + DELIMIT + caseObjectType.value();
    }

    static String getPermissionTagAppRoleName(String caseName, TPermissionTag permissionTag, TActionEnum action) {
        return caseName + DELIMIT + PermissionUtil.getPermissionTagNameString(permissionTag) + DELIMIT + action.value() + DELIMIT + ROLE_SUFFIX;
    }

    static String getPermissionTagNameString(TPermissionTag permissionTag) {
        if (permissionTag.isSetTagName()) {
            return permissionTag.getTagName().value().toUpperCase();
        }
        return permissionTag.getCustomTagName().toUpperCase();
    }

    static String getPermissionTagNameStringInNormalCase(TPermissionTag permissionTag) {
        if (permissionTag.isSetTagName()) {
            return permissionTag.getTagName().value();
        }
        return permissionTag.getCustomTagName();
    }

    static String getPermissionClassName(TCaseObjectEnum caseObjType) {
        return "oracle.bpm.casemgmt.permission.CasePermission";
    }

    static Permission getPermission(String permissionName, TActionEnum caseAction) {
        return new CasePermission(permissionName, caseAction.value());
    }

    static Case getCase(CaseIdentifier caseIdentifier) throws CaseServiceException {
        try {
            IBPMContext context = InternalBPMContext.getInternalBPMContext();
            ArrayList<ICaseConstants.CaseInfo> CASE_INFO_STAKEHOLDER = new ArrayList<ICaseConstants.CaseInfo>();
            CASE_INFO_STAKEHOLDER.add(ICaseConstants.CaseInfo.STAKEHOLDER);
            return ServicesLocator.getInternalCaseService().getCase(context, caseIdentifier, CASE_INFO_STAKEHOLDER);
        }
        catch (BPMException be) {
            be.printStackTrace();
            return null;
        }
    }

    static CaseMetadata getCaseMetadata(String caseDefId) throws CaseServiceException {
        try {
            IBPMContext context = InternalBPMContext.getInternalBPMContext();
            return ServicesLocator.getCaseMetadataService().getCaseMetadata(context, caseDefId);
        }
        catch (BPMException be) {
            be.printStackTrace();
            return null;
        }
    }

    static Set<TActionEnum> getAllActions(TCaseObjectEnum caseObjectType) {
        HashSet<TActionEnum> retActionSet = new HashSet<TActionEnum>();
        for (TActionEnum caseAction : TActionEnum.values()) {
            if (!PermissionUtil.canPerformActionOnCaseObject(caseAction, caseObjectType)) continue;
            retActionSet.add(caseAction);
        }
        return retActionSet;
    }

    static boolean canHavePermissionTagOnCaseObject(TCaseObjectEnum caseObjType) {
        switch (caseObjType) {
            case CASE: {
                return false;
            }
        }
        return true;
    }

    static boolean canPerformActionOnCaseObject(TActionEnum caseAction, TCaseObjectEnum caseObjType) {
        switch (caseObjType) {
            case CASE: 
            case COMMENT: 
            case DOCUMENT: 
            case DATA: {
                switch (caseAction) {
                    case READ: 
                    case UPDATE: {
                        return true;
                    }
                }
                return false;
            }
            case EVENT: 
            case ACTIVITY: {
                switch (caseAction) {
                    case INVOKE: {
                        return true;
                    }
                }
                return false;
            }
            case MILESTONE: 
            case STAKEHOLDER: 
            case HEADER: {
                switch (caseAction) {
                    case READ: 
                    case UPDATE: {
                        return true;
                    }
                }
                return false;
            }
        }
        return false;
    }
}

