/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.permission;

import java.security.Permission;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpm.casemgmt.CaseIdentifier;
import oracle.bpm.casemgmt.CaseServiceException;
import oracle.bpm.casemgmt.common.logger.CaseLogger;
import oracle.bpm.casemgmt.factory.ServicesLocator;
import oracle.bpm.casemgmt.identity.ICaseIdentityService;
import oracle.bpm.casemgmt.impl.CaseServiceUtil;
import oracle.bpm.casemgmt.metadata.Case.model.CaseMetadata;
import oracle.bpm.casemgmt.metadata.Case.model.ObjectFactory;
import oracle.bpm.casemgmt.metadata.Case.model.TCaseMetadata;
import oracle.bpm.casemgmt.metadata.Case.model.TPermissionTag;
import oracle.bpm.casemgmt.metadata.Case.model.TPermissionTags;
import oracle.bpm.casemgmt.metadata.common.model.TActionEnum;
import oracle.bpm.casemgmt.metadata.common.model.TCaseObjectEnum;
import oracle.bpm.casemgmt.permission.CasePermissionDeployer;
import oracle.bpm.casemgmt.permission.CasePermissionException;
import oracle.bpm.casemgmt.permission.IAuthenticationStoreManager;
import oracle.bpm.casemgmt.permission.ICasePermissionServiceInternal;
import oracle.bpm.casemgmt.permission.PermissionUtil;
import oracle.bpm.casemgmt.persistence.model.ActionUserCanPerform;
import oracle.bpm.casemgmt.persistence.model.Case;
import oracle.bpm.casemgmt.persistence.model.CaseHeader;
import oracle.bpm.casemgmt.persistence.model.CaseObject;
import oracle.bpm.casemgmt.persistence.model.CaseObjectPermission;
import oracle.bpm.casemgmt.persistence.model.CaseStakeHolder;
import oracle.bpm.casemgmt.persistence.model.CaseStakeHolderMember;
import oracle.bpm.casemgmt.persistence.model.ICaseConstants;
import oracle.bpm.casemgmt.persistence.model.PermissionTag;
import oracle.bpm.casemgmt.persistence.model.UserPermissions;
import oracle.bpm.casemgmt.resource.Casei18nUtil;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;
import oracle.bpm.services.internal.InternalBPMContext;
import oracle.fabric.composite.model.ComponentModel;
import oracle.fabric.composite.model.CompositeModel;
import oracle.tip.pc.services.identity.BPMAppRole;
import oracle.tip.pc.services.identity.BPMIdentityException;
import oracle.tip.pc.services.identity.BPMUser;

public class CasePermissionServiceInternal
implements ICasePermissionServiceInternal {
    private IAuthenticationStoreManager m_authMgr;
    private static final String CLASS = "CasePermissionServiceInternal";

    @Override
    public void onDeployCreateCasePermissions(IBPMContext ctx, String caseName, CaseMetadata caseMetadata, boolean isRedeployment) throws CasePermissionException {
        String METHOD = "onDeployCreateCasePermissions";
        if (caseMetadata == null || caseMetadata.getValue() == null) {
            this.errorLog("onDeployCreateCasePermissions", "Received Null CaseMetadata for " + caseName);
            return;
        }
        try {
            CasePermissionDeployer casePermDep = new CasePermissionDeployer(this.getAuthenticationStoreManager());
            casePermDep.onDeployCreateCasePermissions(ctx, caseName, caseMetadata, isRedeployment);
        }
        catch (CasePermissionException e) {
            CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_PERMISSION, (Severity)Severity.ERRORS, (String)CLASS, (String)"onDeployCreateCasePermissions", (Throwable)((Object)e));
        }
    }

    @Override
    public void onUndeployRemoveCasePermissions(IBPMContext ctx, String caseName, CaseMetadata caseMetadata) throws CasePermissionException {
    }

    @Override
    public Set<String> getPermissionTags(IBPMContext ctx, CaseIdentifier caseId) throws CasePermissionException {
        String METHOD = "getPermissionTags";
        HashSet<String> retTagSet = new HashSet<String>();
        try {
            if (!this.isAdminContext(ctx)) {
                return retTagSet;
            }
            Case caseInst = PermissionUtil.getCase(caseId);
            String caseDefId = caseInst.getCaseHeader().getCaseDefinitionId();
            CaseMetadata caseMetadata = PermissionUtil.getCaseMetadata(caseDefId);
            TPermissionTags permTags = ((TCaseMetadata)caseMetadata.getValue()).getPermissionTags();
            if (permTags != null && permTags.isSetPermissionTag()) {
                List permTagList = permTags.getPermissionTag();
                for (TPermissionTag permissionTag : permTagList) {
                    retTagSet.add(PermissionUtil.getPermissionTagNameString(permissionTag));
                }
            }
        }
        catch (CaseServiceException cse) {
            throw new CasePermissionException(74803, new Object[0], cse);
        }
        return retTagSet;
    }

    @Override
    public Set<String> getPermissionTagsUserCanUse(IBPMContext ctx, CaseIdentifier caseId, ICaseConstants.CaseObjectPermissionType action, ICaseConstants.CaseObjectType caseObjectType) throws CasePermissionException {
        String METHOD = "getPermissionTagsUserCanUse";
        try {
            Case caseInst = PermissionUtil.getCase(caseId);
            return this.getPermissionTagsUserCanUseInternal(ctx, caseInst, action, caseObjectType);
        }
        catch (CaseServiceException cse) {
            throw new CasePermissionException(74803, new Object[0], cse);
        }
    }

    @Override
    public Set<ICaseConstants.CaseObjectPermissionType> getActionsUserCanPerform(IBPMContext ctx, CaseIdentifier caseIdentifier, Case caseInstance, ICaseConstants.CaseObjectType persCaseObjectType) throws CasePermissionException {
        String METHOD = "getActionsUserCanPerform";
        Set<TActionEnum> tActionSet = null;
        TCaseObjectEnum tCaseObjectType = this.convertCaseObjectType(persCaseObjectType);
        try {
            if (this.isAdminContext(ctx)) {
                tActionSet = PermissionUtil.getAllActions(tCaseObjectType);
            } else {
                if (caseInstance == null) {
                    caseInstance = PermissionUtil.getCase(caseIdentifier);
                }
                String caseName = this.getCompositeName(caseInstance);
                Set<CaseStakeHolder> stakeHolderRolesOfUser = this.getStakeHolderRolesOfUser(ctx, caseInstance, caseName);
                tActionSet = this.getActionsStakeHoldersCanPerform(caseName, tCaseObjectType, stakeHolderRolesOfUser);
            }
        }
        catch (CaseServiceException cse) {
            throw new CasePermissionException(74803, new Object[0], cse);
        }
        return this.convertMetadata2PersistenceCaseActions(tActionSet);
    }

    @Override
    public Set<ICaseConstants.CaseObjectPermissionType> getActionsUserCanPerformOnCaseObject(IBPMContext ctx, CaseIdentifier caseId, Case caseInst, CaseObject caseObj) throws CasePermissionException {
        String METHOD = "getActionsUserCanPerformOnCaseObject";
        if (caseObj == null) {
            return new HashSet<ICaseConstants.CaseObjectPermissionType>();
        }
        Set<TActionEnum> tActionSet = null;
        TCaseObjectEnum tCaseObjectType = this.convertCaseObjectType(PermissionUtil.getObjectType(caseObj));
        try {
            if (this.isAdminContext(ctx)) {
                tActionSet = PermissionUtil.getAllActions(tCaseObjectType);
            } else {
                if (caseInst == null) {
                    caseInst = PermissionUtil.getCase(caseId);
                }
                String caseName = this.getCompositeName(caseInst);
                Set<CaseStakeHolder> stakeHolderRolesOfUser = this.getStakeHolderRolesOfUser(ctx, caseInst, caseName);
                Set<TActionEnum> stakeHolderAction = this.getActionsStakeHoldersCanPerform(caseName, tCaseObjectType, stakeHolderRolesOfUser);
                Set<TActionEnum> userTagAction = this.getTagActionsUserCanPerform(ctx, caseName, caseObj);
                tActionSet = this.getIntersection(stakeHolderAction, userTagAction);
            }
        }
        catch (CaseServiceException cse) {
            throw new CasePermissionException(74803, new Object[0], cse);
        }
        return this.convertMetadata2PersistenceCaseActions(tActionSet);
    }

    @Override
    public boolean checkCaseTagPermission(IBPMContext ctx, CaseIdentifier caseId, String permissionTagName, ICaseConstants.CaseObjectPermissionType action, ICaseConstants.CaseObjectType caseObjectType) throws CasePermissionException {
        String METHOD = "checkCaseTagPermission";
        try {
            Case caseInst = PermissionUtil.getCase(caseId);
            String caseDefinitionId = caseInst.getCaseHeader().getCaseDefinitionId();
            CaseMetadata caseMetadata = PermissionUtil.getCaseMetadata(caseDefinitionId);
            TPermissionTags permTags = ((TCaseMetadata)caseMetadata.getValue()).getPermissionTags();
            TCaseObjectEnum tCaseObjectType = this.convertCaseObjectType(caseObjectType);
            TActionEnum tAction = this.convertPers2MetadataCaseAction(action);
            if (!PermissionUtil.canHavePermissionTagOnCaseObject(tCaseObjectType)) {
                this.debugLog("checkCaseTagPermission", tCaseObjectType + " cannot have permission tags. " + "Returning true, since any stakeholder can perform any valid action on case object without tag.");
                return true;
            }
            if (!PermissionUtil.canPerformActionOnCaseObject(tAction, tCaseObjectType)) {
                this.debugLog("checkCaseTagPermission", "Action " + tAction + " is not allowed on " + tCaseObjectType);
                return false;
            }
            if (permissionTagName == null || permissionTagName.trim().equals("")) {
                this.debugLog("checkCaseTagPermission", "CaseTag Permission is being checked for empty permission tag!. Returning true, since any stakeholder can perform any valid action on case object without tag.");
                return true;
            }
            if (permTags == null || !permTags.isSetPermissionTag()) {
                this.debugLog("checkCaseTagPermission", "CaseTag Permission is being checked for a case without permission tag defined. Returning true, since any stakeholder can perform any valid action on case object without tag.");
                return true;
            }
            this.debugLog("checkCaseTagPermission", "Checking case tag permission for : " + permissionTagName);
            List permTagList = permTags.getPermissionTag();
            boolean found = false;
            TPermissionTag tPermissionTag = null;
            for (TPermissionTag pt : permTagList) {
                String ptName = PermissionUtil.getPermissionTagNameString(pt);
                if (!ptName.equalsIgnoreCase(permissionTagName)) continue;
                found = true;
                tPermissionTag = pt;
                break;
            }
            if (!found) {
                this.debugLog("checkCaseTagPermission", "Permission tag " + permissionTagName + " not found in metadata");
                return false;
            }
            if (this.isAdminContext(ctx)) {
                return true;
            }
            String caseName = this.getCompositeName(caseDefinitionId);
            ICaseIdentityService idtySvc = ServicesLocator.getCaseIdentityService();
            BPMUser user = idtySvc.lookupUser(ctx);
            String permissionName = PermissionUtil.getTagPermissionName(caseName, tPermissionTag, tCaseObjectType);
            Permission permission = PermissionUtil.getPermission(permissionName, tAction);
            return user.hasPermission(permission, "OracleBPMProcessRolesApp");
        }
        catch (BPMIdentityException bie) {
            throw new CasePermissionException(74804, new Object[0], bie);
        }
        catch (CaseServiceException cse) {
            throw new CasePermissionException(74803, new Object[0], cse);
        }
    }

    @Override
    public boolean addCaseActivityPermissionTag(IBPMContext ctx, CaseIdentifier caseId, String caseActivityId, String tag) throws CasePermissionException {
        return true;
    }

    @Override
    public boolean removeCaseActivityPermissionTag(IBPMContext ctx, CaseIdentifier caseId, String caseActivityId) throws CasePermissionException {
        return true;
    }

    @Override
    public void createStakeHolderAppRoleWithDefaultPermission(Case caseInst, String stakeHolderName) throws CasePermissionException {
        String METHOD = "createStakeHolderAppRoleWithDefaultPermission ";
        String caseName = this.getCompositeName(caseInst);
        String appRoleName = PermissionUtil.getStakeHolderAppRoleName(caseName, stakeHolderName);
        ICaseIdentityService idtySvc = ServicesLocator.getCaseIdentityService();
        BPMAppRole appRole = idtySvc.lookupAppRole(appRoleName, "OracleBPMProcessRolesApp");
        if (appRole != null) {
            return;
        }
        String displayName = appRoleName;
        String description = appRoleName;
        this.debugLog("createStakeHolderAppRoleWithDefaultPermission ", "Creating TAG appRole : " + appRoleName);
        this.getAuthenticationStoreManager().createAppRole("OracleBPMProcessRolesApp", appRoleName, displayName, description);
        CasePermissionDeployer casePermDep = new CasePermissionDeployer(this.getAuthenticationStoreManager());
        casePermDep.grantDefaultPermissionToStakeHolderAppRole(caseName, appRoleName);
    }

    @Override
    public UserPermissions getPermissionsForUser(IBPMContext ctx, Case caseInstance) throws CasePermissionException, CaseServiceException {
        CaseIdentifier caseIdentifier = new CaseIdentifier(caseInstance.getCaseHeader().getCaseId(), caseInstance.getCaseHeader().getCaseNumber(), caseInstance.getCaseHeader().getIdentificationKey());
        String caseDefinitionId = caseInstance.getCaseHeader().getCaseDefinitionId();
        UserPermissions userPermissions = new UserPermissions();
        userPermissions.setUserId(ctx.getUser());
        HashSet<CaseObjectPermission> caseObjectPermissionSet = new HashSet<CaseObjectPermission>();
        HashSet<String> alreadyPopulatedCaseObjects = new HashSet<String>();
        for (ICaseConstants.CaseObjectType caseObjectType : ICaseConstants.CaseObjectType.values()) {
            String currentCaseObjectType = this.convertCaseObjectType(caseObjectType).toString();
            if (alreadyPopulatedCaseObjects.contains(currentCaseObjectType)) continue;
            alreadyPopulatedCaseObjects.add(currentCaseObjectType);
            CaseObjectPermission caseObjectPermission = new CaseObjectPermission();
            caseObjectPermission.setCaseObject(caseObjectType.toString());
            Set<String> actionsForCaseObj = CasePermissionServiceInternal.getNameStringForActions(this.getActionsUserCanPerform(ctx, caseIdentifier, caseInstance, caseObjectType));
            HashSet<ActionUserCanPerform> actionUserCanPerformSet = new HashSet<ActionUserCanPerform>();
            for (String action : actionsForCaseObj) {
                Set<String> permissionTags = this.getPermissionTagsUserCanUseInternal(ctx, caseInstance, ICaseConstants.CaseObjectPermissionType.valueOf((String)action), caseObjectType);
                ActionUserCanPerform actionUserCanPerform = new ActionUserCanPerform();
                actionUserCanPerform.setAction(action);
                HashSet<PermissionTag> permissionTagSet = new HashSet<PermissionTag>();
                for (String tag : permissionTags) {
                    PermissionTag permissionTag = new PermissionTag();
                    permissionTag.setName(tag);
                    String bundle = null;
                    String permissionTagDisplayName = Casei18nUtil.getValue(ctx, caseDefinitionId, CaseServiceUtil.getLocale(ctx, null), tag, bundle);
                    if (permissionTagDisplayName == null || permissionTagDisplayName.isEmpty()) {
                        permissionTagDisplayName = tag;
                    }
                    permissionTag.setDisplayName(permissionTagDisplayName);
                    permissionTagSet.add(permissionTag);
                }
                actionUserCanPerform.setPermissionTag(permissionTagSet);
                actionUserCanPerformSet.add(actionUserCanPerform);
            }
            caseObjectPermission.setActionUserCanPerform(actionUserCanPerformSet);
            caseObjectPermissionSet.add(caseObjectPermission);
        }
        userPermissions.setCaseObjectPermission(caseObjectPermissionSet);
        return userPermissions;
    }

    private static Set<String> getNameStringForActions(Set<ICaseConstants.CaseObjectPermissionType> actionSet) {
        HashSet<String> actionNames = new HashSet<String>();
        for (ICaseConstants.CaseObjectPermissionType action : actionSet) {
            actionNames.add(action.toString());
        }
        return actionNames;
    }

    private String getCompositeName(String caseDefId) {
        if (caseDefId != null) {
            ComponentModel componentModel = ServicesLocator.getCaseSE().getCaseComponentModel(caseDefId);
            CompositeModel compositeModel = componentModel.getComposite();
            return compositeModel.getName();
        }
        return null;
    }

    private String getCompositeName(Case caseInst) {
        CaseHeader caseHeader;
        if (caseInst != null && (caseHeader = caseInst.getCaseHeader()) != null) {
            String compositeName = caseHeader.getCompositeName();
            if (compositeName != null && !"".equals(compositeName)) {
                return compositeName;
            }
            String caseDefId = caseHeader.getCaseDefinitionId();
            return this.getCompositeName(caseDefId);
        }
        return null;
    }

    private Set<TActionEnum> getIntersection(Set<TActionEnum> set1, Set<TActionEnum> set2) {
        HashSet<TActionEnum> interSectionSet = new HashSet<TActionEnum>();
        if (this.isEmpty(set1) || this.isEmpty(set2)) {
            return interSectionSet;
        }
        for (TActionEnum action : set1) {
            if (!set2.contains(action)) continue;
            interSectionSet.add(action);
        }
        return interSectionSet;
    }

    private boolean isEmpty(Set<TActionEnum> set) {
        return set == null || set.size() == 0;
    }

    private Set<TActionEnum> getTagActionsUserCanPerform(IBPMContext ctx, String caseName, CaseObject caseObj) throws CasePermissionException {
        String METHOD = "getTagActionsUserCanPerform";
        HashSet<TActionEnum> permTagActionSet = new HashSet<TActionEnum>();
        try {
            TCaseObjectEnum tCaseObjectType = this.convertCaseObjectType(PermissionUtil.getObjectType(caseObj));
            String permTagStr = caseObj.getPermissionTag();
            if (permTagStr == null || permTagStr.equals("")) {
                for (TActionEnum tAction : TActionEnum.values()) {
                    if (!PermissionUtil.canPerformActionOnCaseObject(tAction, tCaseObjectType)) continue;
                    permTagActionSet.add(tAction);
                }
                return permTagActionSet;
            }
            ObjectFactory of = new ObjectFactory();
            TPermissionTag permissionTag = of.createTPermissionTag();
            permissionTag.setCustomTagName(permTagStr);
            ICaseIdentityService idtySvc = ServicesLocator.getCaseIdentityService();
            BPMUser user = idtySvc.lookupUser(ctx);
            String permissionName = PermissionUtil.getTagPermissionName(caseName, permissionTag, tCaseObjectType);
            for (TActionEnum tAction : TActionEnum.values()) {
                Permission permission;
                if (!PermissionUtil.canPerformActionOnCaseObject(tAction, tCaseObjectType) || !user.hasPermission(permission = PermissionUtil.getPermission(permissionName, tAction), "OracleBPMProcessRolesApp")) continue;
                permTagActionSet.add(tAction);
            }
        }
        catch (BPMIdentityException bie) {
            throw new CasePermissionException(74804, new Object[0], bie);
        }
        return permTagActionSet;
    }

    private Set<TActionEnum> getActionsStakeHoldersCanPerform(String caseName, TCaseObjectEnum tCaseObjectType, Set<CaseStakeHolder> stakeHolderRolesOfUser) throws CasePermissionException {
        String METHOD = "getActionsStakeHoldersCanPerform";
        String permissionName = PermissionUtil.getStakeHolderPermissionName(caseName, tCaseObjectType);
        String permissionClass = PermissionUtil.getPermissionClassName(tCaseObjectType);
        HashSet<TActionEnum> retActionSet = new HashSet<TActionEnum>();
        try {
            ICaseIdentityService idtySvc = ServicesLocator.getCaseIdentityService();
            for (CaseStakeHolder stakeHolderRole : stakeHolderRolesOfUser) {
                BPMAppRole appRole;
                String appRoleName = stakeHolderRole.getPermissionMemberRole();
                if (appRoleName == null || "".equals(appRoleName)) {
                    appRoleName = PermissionUtil.getStakeHolderAppRoleName(caseName, stakeHolderRole.getObjectName());
                }
                if ((appRole = idtySvc.lookupAppRole(appRoleName, "OracleBPMProcessRolesApp")) == null) {
                    this.debugLog("getActionsStakeHoldersCanPerform", "Stakeholder-Approle not found : " + appRoleName);
                    continue;
                }
                for (TActionEnum tAction : TActionEnum.values()) {
                    Permission actionPermission;
                    if (!PermissionUtil.canPerformActionOnCaseObject(tAction, tCaseObjectType) || !appRole.hasPermission(actionPermission = PermissionUtil.getPermission(permissionName, tAction), "OracleBPMProcessRolesApp")) continue;
                    retActionSet.add(tAction);
                }
            }
        }
        catch (BPMIdentityException bie) {
            throw new CasePermissionException(74804, new Object[0], bie);
        }
        return retActionSet;
    }

    private Set<CaseStakeHolder> getStakeHolderRolesOfUser(IBPMContext ctx, Case caseInstance, String caseName) throws CaseServiceException {
        String METHOD = "getStakeHolderRolesOfUser";
        ICaseIdentityService idtySvc = ServicesLocator.getCaseIdentityService();
        HashSet<CaseStakeHolder> retSHSet = new HashSet<CaseStakeHolder>();
        List stakeHoldersList = caseInstance.getCaseStakeHolders();
        if (stakeHoldersList != null) {
            for (CaseStakeHolder stakeHolder : stakeHoldersList) {
                if (idtySvc.isInAppRole(ctx, stakeHolder.getObjectName(), "OracleBPMProcessRolesApp")) {
                    retSHSet.add(stakeHolder);
                    continue;
                }
                if (stakeHolder.getPermissionMemberRole() != null && idtySvc.isInAppRole(ctx, stakeHolder.getPermissionMemberRole(), "OracleBPMProcessRolesApp")) {
                    retSHSet.add(stakeHolder);
                    continue;
                }
                if (!this.isInStakeHolder(ctx, idtySvc, stakeHolder)) continue;
                retSHSet.add(stakeHolder);
            }
        }
        return retSHSet;
    }

    private boolean isInStakeHolder(IBPMContext ctx, ICaseIdentityService idtySvc, CaseStakeHolder stakeHolder) {
        List stakeHolderMembers = stakeHolder.getCaseStakeHolderMembers();
        if (stakeHolderMembers == null || stakeHolderMembers.size() == 0) {
            return false;
        }
        boolean retVal = false;
        block5: for (CaseStakeHolderMember shMem : stakeHolderMembers) {
            ICaseConstants.IdentityType resourceType = Enum.valueOf(ICaseConstants.IdentityType.class, shMem.getStakeHolderType());
            switch (resourceType) {
                case USER: {
                    String user = shMem.getStakeHolder();
                    if (!ctx.getUser().equals(user)) continue block5;
                    retVal = true;
                    continue block5;
                }
                case GROUP: {
                    String group = shMem.getStakeHolder();
                    if (!idtySvc.isUserInGroup(ctx, group)) continue block5;
                    retVal = true;
                    continue block5;
                }
                case APPLICATION_ROLE: {
                    String appRole = shMem.getStakeHolder();
                    if (!idtySvc.isInAppRole(ctx, appRole, "OracleBPMProcessRolesApp")) continue block5;
                    retVal = true;
                    continue block5;
                }
            }
        }
        this.debugLog("isInStakeHolder", "Is user '" + ctx.getUser() + "' part of '" + stakeHolder.getObjectName() + "' stakeholder : " + retVal);
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IAuthenticationStoreManager getAuthenticationStoreManager() throws CasePermissionException {
        if (this.m_authMgr != null) {
            return this.m_authMgr;
        }
        CasePermissionServiceInternal casePermissionServiceInternal = this;
        synchronized (casePermissionServiceInternal) {
            if (this.m_authMgr == null) {
                this.m_authMgr = ServicesLocator.getAuthenticationStoreManager();
            }
        }
        return this.m_authMgr;
    }

    private Set<ICaseConstants.CaseObjectPermissionType> convertMetadata2PersistenceCaseActions(Set<TActionEnum> tActions) {
        HashSet<ICaseConstants.CaseObjectPermissionType> persAction = new HashSet<ICaseConstants.CaseObjectPermissionType>();
        if (tActions == null || tActions.size() == 0) {
            return persAction;
        }
        for (TActionEnum tAction : tActions) {
            persAction.add(this.convertMetadata2PersCaseAction(tAction));
        }
        return persAction;
    }

    private ICaseConstants.CaseObjectPermissionType convertMetadata2PersCaseAction(TActionEnum tAction) {
        switch (tAction) {
            case UPDATE: {
                return ICaseConstants.CaseObjectPermissionType.UPDATE;
            }
            case INVOKE: {
                return ICaseConstants.CaseObjectPermissionType.INVOKE;
            }
        }
        return ICaseConstants.CaseObjectPermissionType.READ;
    }

    private TActionEnum convertPers2MetadataCaseAction(ICaseConstants.CaseObjectPermissionType persAction) {
        switch (persAction) {
            case UPDATE: {
                return TActionEnum.UPDATE;
            }
            case INVOKE: {
                return TActionEnum.INVOKE;
            }
        }
        return TActionEnum.READ;
    }

    private TCaseObjectEnum convertCaseObjectType(ICaseConstants.CaseObjectType persistenceType) {
        switch (persistenceType) {
            case COMMENT: {
                return TCaseObjectEnum.COMMENT;
            }
            case DOCUMENT: 
            case DATABASE_ECM_DOCUMENT: {
                return TCaseObjectEnum.DOCUMENT;
            }
            case DATA: {
                return TCaseObjectEnum.DATA;
            }
            case EVENT: {
                return TCaseObjectEnum.EVENT;
            }
            case ACTIVITY: {
                return TCaseObjectEnum.ACTIVITY;
            }
            case MILESTONE: {
                return TCaseObjectEnum.MILESTONE;
            }
            case STAKEHOLDER: {
                return TCaseObjectEnum.STAKEHOLDER;
            }
            case HEADER: {
                return TCaseObjectEnum.HEADER;
            }
        }
        return TCaseObjectEnum.CASE;
    }

    private boolean isAdminContext(IBPMContext ctx) throws CasePermissionException {
        try {
            ICaseIdentityService idtySvc = ServicesLocator.getCaseIdentityService();
            return ctx instanceof InternalBPMContext || idtySvc.isAdminContext(ctx);
        }
        catch (Exception e) {
            throw new CasePermissionException(74804, new Object[0], e);
        }
    }

    private void debugLog(String method, String msg) {
        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_PERMISSION, (Severity)Severity.DEBUG, (String)CLASS, (String)method, (String)msg);
    }

    private void errorLog(String method, String msg) {
        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_PERMISSION, (Severity)Severity.ERRORS, (String)CLASS, (String)method, (String)msg);
    }

    private Set<String> getPermissionTagsUserCanUseInternal(IBPMContext ctx, Case caseInstance, ICaseConstants.CaseObjectPermissionType action, ICaseConstants.CaseObjectType caseObjectType) throws CasePermissionException {
        HashSet<String> retTagSet = new HashSet<String>();
        TCaseObjectEnum tCaseObjectType = this.convertCaseObjectType(caseObjectType);
        TActionEnum tAction = this.convertPers2MetadataCaseAction(action);
        try {
            if (!PermissionUtil.canHavePermissionTagOnCaseObject(tCaseObjectType)) {
                return retTagSet;
            }
            if (!PermissionUtil.canPerformActionOnCaseObject(tAction, tCaseObjectType)) {
                return retTagSet;
            }
            String caseDefinitionId = caseInstance.getCaseHeader().getCaseDefinitionId();
            CaseMetadata caseMetadata = PermissionUtil.getCaseMetadata(caseDefinitionId);
            TPermissionTags permTags = ((TCaseMetadata)caseMetadata.getValue()).getPermissionTags();
            if (permTags == null || !permTags.isSetPermissionTag()) {
                return retTagSet;
            }
            List permTagList = permTags.getPermissionTag();
            String caseName = this.getCompositeName(caseInstance);
            ICaseIdentityService idtySvc = ServicesLocator.getCaseIdentityService();
            BPMUser user = idtySvc.lookupUser(ctx);
            boolean isAdmin = this.isAdminContext(ctx);
            for (TPermissionTag permissionTag : permTagList) {
                String permissionName = PermissionUtil.getTagPermissionName(caseName, permissionTag, tCaseObjectType);
                Permission permission = PermissionUtil.getPermission(permissionName, tAction);
                if (!isAdmin && !user.hasPermission(permission, "OracleBPMProcessRolesApp")) continue;
                retTagSet.add(PermissionUtil.getPermissionTagNameStringInNormalCase(permissionTag));
                this.debugLog("getPermissionTagsUserCanUse", "User : " + user.getName() + " has permission : " + permissionName + " " + tAction.value());
            }
        }
        catch (BPMIdentityException bie) {
            throw new CasePermissionException(74804, new Object[0], bie);
        }
        catch (CaseServiceException cse) {
            throw new CasePermissionException(74803, new Object[0], cse);
        }
        return retTagSet;
    }
}

