/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.permission;

import java.security.Permission;
import java.util.HashSet;
import java.util.List;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpm.casemgmt.common.logger.CaseLogger;
import oracle.bpm.casemgmt.factory.ServicesLocator;
import oracle.bpm.casemgmt.identity.ICaseIdentityService;
import oracle.bpm.casemgmt.metadata.Case.model.CaseMetadata;
import oracle.bpm.casemgmt.metadata.Case.model.TCaseMetadata;
import oracle.bpm.casemgmt.metadata.Case.model.TPermissionTag;
import oracle.bpm.casemgmt.metadata.Case.model.TPermissionTags;
import oracle.bpm.casemgmt.metadata.Case.model.TStakeHolder;
import oracle.bpm.casemgmt.metadata.Case.model.TStakeHolders;
import oracle.bpm.casemgmt.metadata.common.model.TActionEnum;
import oracle.bpm.casemgmt.metadata.common.model.TCaseObjectEnum;
import oracle.bpm.casemgmt.permission.CasePermission;
import oracle.bpm.casemgmt.permission.CasePermissionException;
import oracle.bpm.casemgmt.permission.IAuthenticationStoreManager;
import oracle.bpm.casemgmt.permission.PermissionUtil;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;
import oracle.tip.pc.services.identity.BPMAppRole;

class CasePermissionDeployer {
    private IAuthenticationStoreManager m_authMgr;
    private static final String CLASS = "CasePermissionDeployer";

    CasePermissionDeployer(IAuthenticationStoreManager authMgr) {
        this.m_authMgr = authMgr;
    }

    void grantDefaultPermissionToStakeHolderAppRole(String caseName, String appRoleName) throws CasePermissionException {
        String METHOD = "grantDefaultPermissionToStakeHolderAppRole";
        if (appRoleName == null) {
            return;
        }
        ICaseIdentityService idtySvc = ServicesLocator.getCaseIdentityService();
        for (TCaseObjectEnum caseObjType : TCaseObjectEnum.values()) {
            String permissionClass = PermissionUtil.getPermissionClassName(caseObjType);
            String permissionName = PermissionUtil.getStakeHolderPermissionName(caseName, caseObjType);
            StringBuffer actionBuf = new StringBuffer();
            for (TActionEnum caseAction : TActionEnum.values()) {
                if (!PermissionUtil.canPerformActionOnCaseObject(caseAction, caseObjType)) continue;
                if (actionBuf.length() == 0) {
                    actionBuf.append(caseAction.value());
                    continue;
                }
                actionBuf.append(",").append(caseAction.value());
            }
            this.debugLog("grantDefaultPermissionToStakeHolderAppRole", "Stakeholder appRole permission : " + appRoleName + " : " + permissionName + "{ " + permissionClass + ", " + actionBuf.toString() + " }");
            if (this.appRoleHasPermission(idtySvc, appRoleName, permissionName, actionBuf.toString())) {
                this.debugLog("grantDefaultPermissionToStakeHolderAppRole", "Already permission has been granted.");
                continue;
            }
            this.debugLog("grantDefaultPermissionToStakeHolderAppRole", "Granting permissions.");
            this.getAuthenticationStoreManager().grantPermissionToAppRole("OracleBPMProcessRolesApp", appRoleName, permissionName, permissionClass, actionBuf.toString());
        }
    }

    void onDeployCreateCasePermissions(IBPMContext ctx, String caseName, CaseMetadata caseMetadata, boolean isRedeployment) {
        String METHOD = "onDeployCreateCasePermissions";
        try {
            this.createPermissionTagAppRoles(caseName, caseMetadata);
        }
        catch (CasePermissionException cpe) {
            this.logDeploymentError(caseName, "onDeployCreateCasePermissions", cpe);
        }
        try {
            this.grantPermissionToPermissionTagAppRoles(caseName, caseMetadata);
        }
        catch (CasePermissionException cpe) {
            this.logDeploymentError(caseName, "onDeployCreateCasePermissions", cpe);
        }
        try {
            this.grantPermissionToStakeHolderAppRoles(caseName, caseMetadata);
        }
        catch (CasePermissionException cpe) {
            this.logDeploymentError(caseName, "onDeployCreateCasePermissions", cpe);
        }
    }

    private IAuthenticationStoreManager getAuthenticationStoreManager() {
        return this.m_authMgr;
    }

    private void createPermissionTagAppRoles(String caseName, CaseMetadata caseMetadata) throws CasePermissionException {
        String METHOD = "createPermissionTagAppRoles ";
        TPermissionTags permTags = ((TCaseMetadata)caseMetadata.getValue()).getPermissionTags();
        if (permTags == null || !permTags.isSetPermissionTag()) {
            return;
        }
        List permTagList = permTags.getPermissionTag();
        HashSet<String> couldNotCreateSet = new HashSet<String>();
        CasePermissionException _lastException = null;
        for (TPermissionTag permTag : permTagList) {
            for (TActionEnum caseAction : TActionEnum.values()) {
                String appRoleName;
                String displayName = appRoleName = PermissionUtil.getPermissionTagAppRoleName(caseName, permTag, caseAction);
                String description = appRoleName;
                this.debugLog("createPermissionTagAppRoles ", "Creating TAG appRole : " + appRoleName);
                try {
                    this.getAuthenticationStoreManager().createAppRole("OracleBPMProcessRolesApp", appRoleName, displayName, description);
                }
                catch (CasePermissionException cpe) {
                    this.errorLog("createPermissionTagAppRoles ", "Could not create appRole : " + appRoleName + " due to error : " + cpe.getMessage());
                    couldNotCreateSet.add(appRoleName);
                    _lastException = cpe;
                }
            }
        }
        if (_lastException != null) {
            throw new CasePermissionException(74800, new Object[]{couldNotCreateSet}, (Throwable)((Object)_lastException));
        }
    }

    private void grantPermissionToPermissionTagAppRoles(String caseName, CaseMetadata caseMetadata) throws CasePermissionException {
        String METHOD = "grantPermissionToPermissionTagAppRoles";
        TPermissionTags permTags = ((TCaseMetadata)caseMetadata.getValue()).getPermissionTags();
        if (permTags == null || !permTags.isSetPermissionTag()) {
            return;
        }
        HashSet<String> couldNotGrantPermissions = new HashSet<String>();
        HashSet<String> couldNotGrantRoles = new HashSet<String>();
        CasePermissionException _lastException = null;
        List permTagList = permTags.getPermissionTag();
        ICaseIdentityService idtySvc = ServicesLocator.getCaseIdentityService();
        for (TPermissionTag permTag : permTagList) {
            for (TCaseObjectEnum caseObjType : TCaseObjectEnum.values()) {
                if (!PermissionUtil.canHavePermissionTagOnCaseObject(caseObjType)) continue;
                String permissionClass = PermissionUtil.getPermissionClassName(caseObjType);
                String permissionName = PermissionUtil.getTagPermissionName(caseName, permTag, caseObjType);
                for (TActionEnum caseAction : TActionEnum.values()) {
                    if (!PermissionUtil.canPerformActionOnCaseObject(caseAction, caseObjType)) continue;
                    String appRoleName = PermissionUtil.getPermissionTagAppRoleName(caseName, permTag, caseAction);
                    this.debugLog("grantPermissionToPermissionTagAppRoles", "TAG appRole permission : " + appRoleName + "{ " + permissionClass + ", " + caseAction.value() + " }");
                    if (this.appRoleHasPermission(idtySvc, appRoleName, permissionName, caseAction.value())) {
                        this.debugLog("grantPermissionToPermissionTagAppRoles", "Already permission has been granted.");
                        continue;
                    }
                    this.debugLog("grantPermissionToPermissionTagAppRoles", "Granting permission");
                    try {
                        this.getAuthenticationStoreManager().grantPermissionToAppRole("OracleBPMProcessRolesApp", appRoleName, permissionName, permissionClass, caseAction.value());
                    }
                    catch (CasePermissionException cpe) {
                        this.errorLog("grantPermissionToPermissionTagAppRoles", "Could not grant permission to approle : " + appRoleName + "{ " + permissionClass + ", " + caseAction.value() + " }" + " due to error : " + cpe.getMessage());
                        couldNotGrantPermissions.add(permissionName);
                        couldNotGrantRoles.add(appRoleName);
                        _lastException = cpe;
                    }
                }
            }
        }
        if (_lastException != null) {
            throw new CasePermissionException(74801, new Object[]{((Object)couldNotGrantPermissions).toString(), ((Object)couldNotGrantRoles).toString()}, (Throwable)((Object)_lastException));
        }
    }

    private void grantPermissionToStakeHolderAppRoles(String caseName, CaseMetadata caseMetadata) throws CasePermissionException {
        String METHOD = "grantPermissionToStakeHolderAppRoles";
        TStakeHolders stakeHolders = ((TCaseMetadata)caseMetadata.getValue()).getStakeHolders();
        if (stakeHolders == null || stakeHolders.getStakeHolder().size() == 0) {
            return;
        }
        HashSet<String> couldNotGrantRoles = new HashSet<String>();
        CasePermissionException _lastException = null;
        for (TStakeHolder stakeHolder : stakeHolders.getStakeHolder()) {
            String appRoleName = PermissionUtil.getStakeHolderAppRoleName(caseName, stakeHolder.getName());
            try {
                this.grantDefaultPermissionToStakeHolderAppRole(caseName, appRoleName);
            }
            catch (CasePermissionException cpe) {
                this.errorLog("grantPermissionToStakeHolderAppRoles", "Could not grant permission to approle : " + appRoleName + " due to error : " + cpe.getMessage());
                couldNotGrantRoles.add(appRoleName);
                _lastException = cpe;
            }
        }
        if (_lastException != null) {
            throw new CasePermissionException(74801, new Object[]{"DEFAULT STAKEHOLDER Permissions", ((Object)couldNotGrantRoles).toString()}, (Throwable)((Object)_lastException));
        }
    }

    private boolean appRoleHasPermission(ICaseIdentityService idtySvc, String appRoleName, String permissionName, String caseAction) {
        try {
            BPMAppRole bpmAppRole = idtySvc.lookupAppRole(appRoleName, "OracleBPMProcessRolesApp");
            CasePermission permission = new CasePermission(permissionName, caseAction);
            return bpmAppRole.hasPermission((Permission)permission, "OracleBPMProcessRolesApp");
        }
        catch (Exception e) {
            return false;
        }
    }

    private void logDeploymentError(String caseName, String method, CasePermissionException e) {
        CasePermissionException cpe = new CasePermissionException(74805, new Object[]{caseName}, (Throwable)((Object)e));
        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_PERMISSION, (Severity)Severity.ERRORS, (String)CLASS, (String)method, (Throwable)((Object)cpe));
    }

    private void errorLog(String method, String msg) {
        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_PERMISSION, (Severity)Severity.ERRORS, (String)CLASS, (String)method, (String)msg);
    }

    private void debugLog(String method, String msg) {
        CaseLogger.log((LoggerComponent)LoggerComponent.COMPONENT_CM_PERMISSION, (Severity)Severity.DEBUG, (String)("CasePermissionDeployer." + method + "() : " + msg));
    }
}

