/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.permission;

import java.security.Permission;
import oracle.bpm.casemgmt.persistence.model.ICaseConstants;

public class CasePermission
extends Permission {
    private String mActions;
    private int mHashCode;
    private static String PERMISSION_DELIMT = ",";

    public CasePermission(String name, String actions) {
        super(name);
        String[] actionsArr = actions.split(PERMISSION_DELIMT);
        for (ICaseConstants.CaseObjectPermissionType perm : ICaseConstants.CaseObjectPermissionType.values()) {
            if (!this.contains(actionsArr, perm.name())) continue;
            this.mActions = this.mActions == null ? perm.name() : this.mActions + PERMISSION_DELIMT + perm.name();
        }
        this.debugLog("CasePermission", "Name : " + name + ", mActions : " + this.mActions);
        this.mHashCode = (name + PERMISSION_DELIMT + this.mActions).hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof CasePermission)) {
            return false;
        }
        CasePermission casePerm = (CasePermission)obj;
        this.debugLog("equals", "casePerm : Name : " + casePerm.getName() + ", Actions : " + casePerm.getActions());
        this.debugLog("equals", "this : Name : " + this.getName() + ", Actions : " + this.getActions());
        if (!casePerm.getName().equals(this.getName())) {
            return false;
        }
        return casePerm.getActions().equals(this.getActions());
    }

    @Override
    public String getActions() {
        return this.mActions;
    }

    @Override
    public int hashCode() {
        return this.mHashCode;
    }

    @Override
    public boolean implies(Permission permission) {
        String[] actionArr;
        if (!(permission instanceof CasePermission)) {
            return false;
        }
        CasePermission casePerm = (CasePermission)permission;
        this.debugLog("implies", "casePerm : Name : " + casePerm.getName() + ", Actions : " + casePerm.getActions());
        this.debugLog("implies", "this : Name : " + this.getName() + ", Actions : " + this.getActions());
        if (!casePerm.getName().equals(this.getName())) {
            return false;
        }
        if (casePerm.getActions().equals(this.getActions())) {
            return true;
        }
        for (String a : actionArr = casePerm.getActions().split(PERMISSION_DELIMT)) {
            if (this.getActions().indexOf(a) != -1) continue;
            return false;
        }
        return true;
    }

    private boolean contains(String[] actionArr, String action) {
        for (String a : actionArr) {
            if (!a.equalsIgnoreCase(action)) continue;
            return true;
        }
        return false;
    }

    private void debugLog(String method, String msg) {
    }
}

